/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.SystemClock;
import android.util.Log;
import android.view.TextureView;
import android.view.WindowManager;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ar.rtc.IRtcEngineEventHandler;
import org.ar.rtc.video.CameraCapturerConfiguration;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.Logging;
import org.webrtc.RendererCommon;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;

public class VideoCapturerAndroid
implements CameraVideoCapturer,
Camera.PreviewCallback,
SurfaceTextureHelper.OnTextureFrameAvailableListener {
    private static final String TAG = "VideoCapturerAndroid";
    private static final int CAMERA_STOP_TIMEOUT_MS = 7000;
    private Camera camera;
    private final AtomicBoolean isCameraRunning = new AtomicBoolean();
    private volatile Handler cameraThreadHandler;
    private Context applicationContext;
    private final Object cameraIdLock = new Object();
    private int id;
    private Camera.CameraInfo info;
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private int requestedWidth;
    private int requestedHeight;
    private int requestedFramerate;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final Object pendingCameraSwitchLock = new Object();
    private volatile boolean pendingCameraSwitch;
    private VideoCapturer.CapturerObserver frameObserver = null;
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private boolean firstFrameReported;
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private final Set<byte[]> queuedBuffers = new HashSet<byte[]>();
    private final boolean isCapturingToTexture;
    private SurfaceTextureHelper surfaceHelper;
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private int openCameraAttempts;
    private boolean mIsAutoFaceFocusEnabled = false;
    private Object mObjectLock = new Object();
    private IRtcEngineEventHandler rtcEngineEventHandler;
    private int surfaceWidth;
    private int surfaceHeight;
    private boolean enableFaceDetection;
    private TextureView localSurface;
    private static final long CAMERA_OPEN_REQUEST_INTERVAL = 2000L;
    private HandlerThread mCameraRecoverHandlerThread = null;
    private Handler mHandler = null;
    private Object mRecoverThreadObjectLock = new Object();
    private CameraCapturerConfiguration cameraCapturerConfiguration = new CameraCapturerConfiguration(CameraCapturerConfiguration.CD_640x480, CameraCapturerConfiguration.CAMERA_DIRECTION.CAMERA_FRONT);
    private final Camera.ErrorCallback cameraErrorCallback = new Camera.ErrorCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(int error, final Camera camera) {
            String errorMessage = error == 100 ? "Camera server died!" : "Camera error: " + error;
            Logging.e(VideoCapturerAndroid.TAG, errorMessage);
            if ((error == 2 || error == 100 || error == 1) && VideoCapturerAndroid.this.camera != null) {
                Object object = VideoCapturerAndroid.this.mRecoverThreadObjectLock;
                synchronized (object) {
                    if (VideoCapturerAndroid.this.mCameraRecoverHandlerThread == null) {
                        VideoCapturerAndroid.this.mCameraRecoverHandlerThread = new HandlerThread("camera-recover-thread");
                        VideoCapturerAndroid.this.mCameraRecoverHandlerThread.start();
                        if (VideoCapturerAndroid.this.mCameraRecoverHandlerThread != null) {
                            VideoCapturerAndroid.this.mHandler = new Handler(VideoCapturerAndroid.this.mCameraRecoverHandlerThread.getLooper());
                        }
                    }
                    if (VideoCapturerAndroid.this.mHandler != null) {
                        VideoCapturerAndroid.this.mHandler.postDelayed(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Object object = VideoCapturerAndroid.this.mRecoverThreadObjectLock;
                                synchronized (object) {
                                    if (VideoCapturerAndroid.this.isForeground() && null != camera) {
                                        VideoCapturerAndroid.this.maybePostOnCameraThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                VideoCapturerAndroid.this.stopCaptureOnCameraThread(false);
                                                VideoCapturerAndroid.this.startCaptureOnCameraThread(VideoCapturerAndroid.this.requestedWidth, VideoCapturerAndroid.this.requestedHeight, VideoCapturerAndroid.this.requestedFramerate);
                                            }
                                        });
                                    } else if (VideoCapturerAndroid.this.mHandler != null) {
                                        VideoCapturerAndroid.this.mHandler.postDelayed((Runnable)this, 2000L);
                                    }
                                }
                            }
                        }, 2000L);
                    }
                }
            }
            if (VideoCapturerAndroid.this.eventsHandler != null) {
                VideoCapturerAndroid.this.eventsHandler.onCameraError(errorMessage);
            }
        }
    };

    public static VideoCapturerAndroid create(String name) {
        return VideoCapturerAndroid.create(name, null, false);
    }

    public static VideoCapturerAndroid create(String name, CameraVideoCapturer.CameraEventsHandler eventsHandler) {
        return VideoCapturerAndroid.create(name, eventsHandler, false);
    }

    public void setRtcEngineEventHandler(IRtcEngineEventHandler rtcEngineEventHandler) {
        this.rtcEngineEventHandler = rtcEngineEventHandler;
    }

    @Deprecated
    public static VideoCapturerAndroid create(String name, CameraVideoCapturer.CameraEventsHandler eventsHandler, boolean captureToTexture) {
        try {
            return new VideoCapturerAndroid(name, eventsHandler, captureToTexture);
        }
        catch (RuntimeException e) {
            Logging.e(TAG, "Couldn't create camera.", e);
            return null;
        }
    }

    public TextureView getLocalSurface() {
        return this.localSurface;
    }

    public void setLocalSurface(TextureView localSurface) {
        this.localSurface = localSurface;
    }

    public void printStackTrace() {
        StackTraceElement[] cameraStackTraces;
        Thread cameraThread = null;
        if (this.cameraThreadHandler != null) {
            cameraThread = this.cameraThreadHandler.getLooper().getThread();
        }
        if (cameraThread != null && (cameraStackTraces = cameraThread.getStackTrace()).length > 0) {
            Logging.d(TAG, "VideoCapturerAndroid stacks trace:");
            for (StackTraceElement stackTrace : cameraStackTraces) {
                Logging.d(TAG, stackTrace.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        if (Camera.getNumberOfCameras() < 2) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.pendingCameraSwitchLock;
        synchronized (object) {
            if (this.pendingCameraSwitch) {
                Logging.w(TAG, "Ignoring camera switch request.");
                if (switchEventsHandler != null) {
                    switchEventsHandler.onCameraSwitchError("Pending camera switch already in progress.");
                }
                return;
            }
            this.pendingCameraSwitch = true;
        }
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                VideoCapturerAndroid.this.switchCameraOnCameraThread();
                Object object = VideoCapturerAndroid.this.pendingCameraSwitchLock;
                synchronized (object) {
                    VideoCapturerAndroid.this.pendingCameraSwitch = false;
                }
                if (switchEventsHandler != null) {
                    switchEventsHandler.onCameraSwitchDone(((VideoCapturerAndroid)VideoCapturerAndroid.this).info.facing == 1);
                }
            }
        });
        if (!didPost && switchEventsHandler != null) {
            switchEventsHandler.onCameraSwitchError("Camera is stopped.");
        }
    }

    @Override
    public void addMediaRecorderToCamera(MediaRecorder mediaRecorder, CameraVideoCapturer.MediaRecorderHandler resultHandler) {
    }

    @Override
    public void removeMediaRecorderFromCamera(CameraVideoCapturer.MediaRecorderHandler resultHandler) {
    }

    @Override
    public void changeCaptureFormat(int width, int height, final int framerate) {
        this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.startPreviewOnCameraThread(((VideoCapturerAndroid)VideoCapturerAndroid.this).cameraCapturerConfiguration.dimensions.width, ((VideoCapturerAndroid)VideoCapturerAndroid.this).cameraCapturerConfiguration.dimensions.height, framerate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCurrentCameraId() {
        Object object = this.cameraIdLock;
        synchronized (object) {
            return this.id;
        }
    }

    @Override
    public List<CameraEnumerationAndroid.CaptureFormat> getSupportedFormats() {
        return Camera1Enumerator.getSupportedFormats(this.getCurrentCameraId());
    }

    private static Rect calculateTapArea(float x, float y, float coefficient, int width, int height) {
        float focusAreaSize = 300.0f;
        int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
        int centerX = (int)(x / (float)width * 2000.0f - 1000.0f);
        int centerY = (int)(y / (float)height * 2000.0f - 1000.0f);
        int halfAreaSize = areaSize / 2;
        RectF rectF = new RectF((float)VideoCapturerAndroid.clamp(centerX - halfAreaSize, -1000, 1000), (float)VideoCapturerAndroid.clamp(centerY - halfAreaSize, -1000, 1000), (float)VideoCapturerAndroid.clamp(centerX + halfAreaSize, -1000, 1000), (float)VideoCapturerAndroid.clamp(centerY + halfAreaSize, -1000, 1000));
        return new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
    }

    private static int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setFocus(float x, float y) {
        if (this.camera == null) {
            return -1;
        }
        Rect focusRect = VideoCapturerAndroid.calculateTapArea(x, y, 1.0f, this.surfaceWidth, this.surfaceHeight);
        try {
            this.camera.cancelAutoFocus();
        }
        catch (RuntimeException e) {
            Logging.w("CAMERA1", "Failed to cancle AutoFocus" + e);
        }
        Camera.Parameters params = this.camera.getParameters();
        if (params == null) {
            return -1;
        }
        if (params.getMaxNumFocusAreas() > 0) {
            ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
            focusAreas.add(new Camera.Area(focusRect, 800));
            params.setFocusAreas(focusAreas);
        } else {
            Log.i((String)"CAMERA1", (String)"focus areas not supported");
        }
        final String currentFocusMode = params.getFocusMode();
        if (VideoCapturerAndroid.isSupported("macro", params.getSupportedFocusModes())) {
            params.setFocusMode("macro");
            Object object = this.mObjectLock;
            synchronized (object) {
                this.camera.setParameters(params);
            }
            if (this.rtcEngineEventHandler != null) {
                this.rtcEngineEventHandler.onCameraFocusAreaChanged(focusRect);
            }
        } else {
            Log.i((String)"focus", (String)"FOCUS_MODE_MACRO is not supported");
        }
        try {
            this.camera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    Camera.Parameters params = camera.getParameters();
                    params.setFocusMode(currentFocusMode);
                    camera.setParameters(params);
                }
            });
        }
        catch (Exception e) {
            return -1;
        }
        return 0;
    }

    public int setExposure(float x, float y) {
        if (this.camera == null) {
            return -1;
        }
        Rect meteringRect = VideoCapturerAndroid.calculateTapArea(x, y, 1.5f, this.surfaceWidth, this.surfaceHeight);
        Camera.Parameters params = this.camera.getParameters();
        if (params.getMaxNumMeteringAreas() > 0) {
            ArrayList<Camera.Area> meteringAreas = new ArrayList<Camera.Area>();
            meteringAreas.add(new Camera.Area(meteringRect, 800));
            params.setMeteringAreas(meteringAreas);
        } else {
            Log.i((String)TAG, (String)"metering areas not supported");
        }
        this.camera.setParameters(params);
        if (this.rtcEngineEventHandler != null) {
            this.rtcEngineEventHandler.onCameraExposureAreaChanged(meteringRect);
        }
        return 0;
    }

    public boolean isCapturingToTexture() {
        return this.isCapturingToTexture;
    }

    public VideoCapturerAndroid(String cameraName, CameraVideoCapturer.CameraEventsHandler eventsHandler, boolean captureToTexture) {
        if (Camera.getNumberOfCameras() == 0) {
            throw new RuntimeException("No cameras available");
        }
        this.id = cameraName == null || cameraName.equals("") ? 0 : Camera1Enumerator.getCameraIndex(cameraName);
        this.eventsHandler = eventsHandler;
        this.isCapturingToTexture = captureToTexture;
        Logging.d(TAG, "VideoCapturerAndroid isCapturingToTexture : " + this.isCapturingToTexture);
    }

    private void checkIsOnCameraThread() {
        if (this.cameraThreadHandler == null) {
            Logging.e(TAG, "Camera is not initialized - can't check thread.");
        } else if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private boolean maybePostOnCameraThread(Runnable runnable) {
        return this.maybePostDelayedOnCameraThread(0, runnable);
    }

    private boolean maybePostDelayedOnCameraThread(int delayMs, Runnable runnable) {
        return this.cameraThreadHandler != null && this.isCameraRunning.get() && this.cameraThreadHandler.postAtTime(runnable, (Object)this, SystemClock.uptimeMillis() + (long)delayMs);
    }

    @Override
    public void dispose() {
        Logging.d(TAG, "dispose");
    }

    private boolean isInitialized() {
        return this.applicationContext != null && this.frameObserver != null;
    }

    @Override
    public void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, VideoCapturer.CapturerObserver frameObserver) {
        Logging.d(TAG, "initialize");
        if (applicationContext == null) {
            throw new IllegalArgumentException("applicationContext not set.");
        }
        if (frameObserver == null) {
            throw new IllegalArgumentException("frameObserver not set.");
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized");
        }
        this.applicationContext = applicationContext;
        this.frameObserver = frameObserver;
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    @Override
    public void startCapture(final int width, final int height, final int framerate) {
        Logging.d(TAG, "startCapture requested: " + width + "x" + height + "@" + framerate);
        if (!this.isInitialized()) {
            throw new IllegalStateException("startCapture called in uninitialized state");
        }
        if (this.surfaceHelper == null) {
            this.frameObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("No SurfaceTexture created.");
            }
            return;
        }
        if (this.isCameraRunning.getAndSet(true)) {
            Logging.e(TAG, "Camera has already been started.");
            return;
        }
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.openCameraAttempts = 0;
                VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate);
            }
        });
        if (!didPost) {
            this.frameObserver.onCapturerStarted(false);
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Could not post task to camera thread.");
            }
            this.isCameraRunning.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startCaptureOnCameraThread(final int width, final int height, final int framerate) {
        block13: {
            this.checkIsOnCameraThread();
            if (!this.isCameraRunning.get()) {
                Logging.e(TAG, "startCaptureOnCameraThread: Camera is stopped");
                return;
            }
            if (this.camera != null) {
                Logging.e(TAG, "startCaptureOnCameraThread: Camera has already been started.");
                return;
            }
            this.firstFrameReported = false;
            try {
                try {
                    Object object = this.cameraIdLock;
                    synchronized (object) {
                        Logging.d(TAG, "Opening camera " + this.id);
                        if (this.eventsHandler != null) {
                            this.eventsHandler.onCameraOpening(Camera1Enumerator.getDeviceName(this.id));
                        }
                        this.camera = Camera.open((int)this.id);
                        this.info = new Camera.CameraInfo();
                        Camera.getCameraInfo((int)this.id, (Camera.CameraInfo)this.info);
                    }
                }
                catch (RuntimeException e) {
                    ++this.openCameraAttempts;
                    if (this.openCameraAttempts < 3) {
                        Logging.e(TAG, "Camera.open failed, retrying", e);
                        this.maybePostDelayedOnCameraThread(500, new Runnable(){

                            @Override
                            public void run() {
                                VideoCapturerAndroid.this.startCaptureOnCameraThread(width, height, framerate);
                            }
                        });
                        return;
                    }
                    throw e;
                }
                this.camera.setPreviewTexture(this.surfaceHelper.getSurfaceTexture());
                Logging.d(TAG, "Camera orientation: " + this.info.orientation + " .Device orientation: " + this.getDeviceOrientation());
                this.camera.setErrorCallback(this.cameraErrorCallback);
                this.startPreviewOnCameraThread(width, height, framerate);
                this.frameObserver.onCapturerStarted(true);
                if (this.isCapturingToTexture) {
                    this.surfaceHelper.startListening(this);
                }
                this.cameraStatistics = new CameraVideoCapturer.CameraStatistics(this.surfaceHelper, this.eventsHandler);
            }
            catch (IOException | RuntimeException e) {
                Logging.e(TAG, "startCapture failed", e);
                this.stopCaptureOnCameraThread(true);
                this.frameObserver.onCapturerStarted(false);
                if (this.eventsHandler == null) break block13;
                this.eventsHandler.onCameraError("Camera can not be started.");
            }
        }
    }

    private void startPreviewOnCameraThread(int width, int height, int framerate) {
        List focusModes;
        Size previewSize;
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get() || this.camera == null) {
            Logging.e(TAG, "startPreviewOnCameraThread: Camera is stopped");
            return;
        }
        Logging.d(TAG, "startPreviewOnCameraThread requested: " + width + "x" + height + "@" + framerate);
        this.requestedWidth = this.cameraCapturerConfiguration.dimensions.width;
        this.requestedHeight = this.cameraCapturerConfiguration.dimensions.height;
        this.requestedFramerate = framerate;
        Camera.Parameters parameters = this.camera.getParameters();
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> supportedFramerates = Camera1Enumerator.convertFramerates(parameters.getSupportedPreviewFpsRange());
        Logging.d(TAG, "Available fps ranges: " + supportedFramerates);
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(supportedFramerates, framerate);
        List<Size> supportedPreviewSizes = Camera1Enumerator.convertSizes(parameters.getSupportedPreviewSizes());
        Size mSize = this.requestedWidth < this.requestedHeight ? new Size(this.requestedWidth, this.requestedHeight) : new Size(this.requestedWidth, this.requestedHeight);
        if (supportedPreviewSizes.contains(mSize)) {
            previewSize = mSize;
        } else {
            Iterator<Size> it = supportedPreviewSizes.iterator();
            while (it.hasNext()) {
                Size m = it.next();
                if (m.width >= m.height) continue;
                it.remove();
            }
            previewSize = CameraEnumerationAndroid.getClosestSupportedSize(supportedPreviewSizes, this.requestedWidth, this.requestedHeight);
        }
        Logging.d(TAG, "Available preview sizes: " + supportedPreviewSizes);
        Logging.d(TAG, "best preview sizes: " + previewSize);
        Logging.d(TAG, "best fpsRange: min->" + fpsRange.min + "|" + fpsRange.max + "<-Max");
        CameraEnumerationAndroid.CaptureFormat captureFormat = new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, fpsRange);
        if (captureFormat.equals(this.captureFormat)) {
            return;
        }
        Logging.d(TAG, "isVideoStabilizationSupported: " + parameters.isVideoStabilizationSupported());
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (captureFormat.framerate.max > 0) {
            parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        }
        parameters.setPreviewSize(previewSize.width, previewSize.height);
        if (!this.isCapturingToTexture) {
            parameters.setPreviewFormat(captureFormat.imageFormat);
        }
        Size pictureSize = CameraEnumerationAndroid.getClosestSupportedSize(Camera1Enumerator.convertSizes(parameters.getSupportedPictureSizes()), width, height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (this.captureFormat != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        if ((focusModes = parameters.getSupportedFocusModes()).contains("continuous-video")) {
            Logging.d(TAG, "Enable continuous auto focus mode.");
            parameters.setFocusMode("continuous-video");
        }
        Logging.d(TAG, "Start capturing: " + captureFormat);
        this.captureFormat = captureFormat;
        this.camera.setParameters(parameters);
        this.camera.setDisplayOrientation(0);
        if (!this.isCapturingToTexture) {
            this.queuedBuffers.clear();
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                this.queuedBuffers.add(buffer.array());
                this.camera.addCallbackBuffer(buffer.array());
            }
            this.camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        try {
            this.camera.startPreview();
            if (this.enableFaceDetection) {
                this.startFaceDetect();
            }
            if (this.localSurface != null) {
                this.surfaceWidth = this.localSurface.getMeasuredWidth();
                this.surfaceHeight = this.localSurface.getMeasuredHeight();
                this.localSurface.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                    }

                    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                        Log.d((String)"SizeChanged", (String)("width" + width + "--" + height));
                        VideoCapturerAndroid.this.surfaceWidth = width;
                        VideoCapturerAndroid.this.surfaceHeight = height;
                    }

                    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                        return false;
                    }

                    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
                    }
                });
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)e.getMessage());
        }
    }

    @Override
    public void stopCapture() throws InterruptedException {
        Logging.d(TAG, "stopCapture");
        final CountDownLatch barrier = new CountDownLatch(1);
        boolean didPost = this.maybePostOnCameraThread(new Runnable(){

            @Override
            public void run() {
                VideoCapturerAndroid.this.stopCaptureOnCameraThread(true);
                barrier.countDown();
            }
        });
        if (!didPost) {
            Logging.e(TAG, "Calling stopCapture() for already stopped camera.");
            return;
        }
        if (!barrier.await(7000L, TimeUnit.MILLISECONDS)) {
            Logging.e(TAG, "Camera stop timeout");
            this.printStackTrace();
            if (this.eventsHandler != null) {
                this.eventsHandler.onCameraError("Camera stop timeout");
            }
        }
        this.frameObserver.onCapturerStopped();
        if (this.enableFaceDetection) {
            // empty if block
        }
        Logging.d(TAG, "stopCapture done");
    }

    private void stopCaptureOnCameraThread(boolean stopHandler) {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "stopCaptureOnCameraThread");
        if (this.surfaceHelper != null) {
            this.surfaceHelper.stopListening();
        }
        if (stopHandler) {
            this.isCameraRunning.set(false);
            this.cameraThreadHandler.removeCallbacksAndMessages((Object)this);
        }
        if (this.cameraStatistics != null) {
            this.cameraStatistics.release();
            this.cameraStatistics = null;
        }
        Logging.d(TAG, "Stop preview.");
        if (this.camera != null) {
            this.camera.stopPreview();
            this.camera.setPreviewCallbackWithBuffer(null);
        }
        this.queuedBuffers.clear();
        this.captureFormat = null;
        Logging.d(TAG, "Release camera.");
        if (this.camera != null) {
            this.camera.release();
            this.camera = null;
        }
        if (this.eventsHandler != null) {
            this.eventsHandler.onCameraClosed();
        }
        Logging.d(TAG, "stopCaptureOnCameraThread done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraOnCameraThread() {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e(TAG, "switchCameraOnCameraThread: Camera is stopped");
            return;
        }
        Logging.d(TAG, "switchCameraOnCameraThread");
        this.stopCaptureOnCameraThread(false);
        Object object = this.cameraIdLock;
        synchronized (object) {
            this.id = (this.id + 1) % Camera.getNumberOfCameras();
        }
        this.startCaptureOnCameraThread(this.requestedWidth, this.requestedHeight, this.requestedFramerate);
        Logging.d(TAG, "switchCameraOnCameraThread done");
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.applicationContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    @Override
    public boolean useBackCamera() {
        if (this.info == null) {
            return true;
        }
        return this.info.facing == 0;
    }

    private int getFrameOrientation() {
        int rotation = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        return (this.info.orientation + rotation) % 360;
    }

    private int getFaceOrientation() {
        int result;
        int rotation = this.getDeviceOrientation();
        if (this.info.facing == 1) {
            result = (this.info.orientation + rotation) % 360;
            result = (360 - result) % 360;
        } else {
            result = (this.info.orientation - rotation + 360) % 360;
        }
        return result;
    }

    public void onPreviewFrame(byte[] data, Camera callbackCamera) {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e(TAG, "onPreviewFrame: Camera is stopped");
            return;
        }
        if (!this.queuedBuffers.contains(data)) {
            return;
        }
        if (this.camera != callbackCamera) {
            throw new RuntimeException("Unexpected camera in callback!");
        }
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onByteBufferFrameCaptured(data, this.captureFormat.width, this.captureFormat.height, this.getFrameOrientation(), captureTimeNs);
        this.camera.addCallbackBuffer(data);
    }

    @Override
    public void onTextureFrameAvailable(int oesTextureId, float[] transformMatrix, long timestampNs) {
        this.checkIsOnCameraThread();
        if (!this.isCameraRunning.get()) {
            Logging.e(TAG, "onTextureFrameAvailable: Camera is stopped");
            this.surfaceHelper.returnTextureFrame();
            return;
        }
        if (this.eventsHandler != null && !this.firstFrameReported) {
            this.eventsHandler.onFirstFrameAvailable();
            this.firstFrameReported = true;
        }
        int rotation = this.getFrameOrientation();
        if (this.info.facing == 1) {
            transformMatrix = RendererCommon.multiplyMatrices(transformMatrix, RendererCommon.horizontalFlipMatrix());
        }
        this.cameraStatistics.addFrame();
        this.frameObserver.onTextureFrameCaptured(this.captureFormat.width, this.captureFormat.height, oesTextureId, transformMatrix, rotation, timestampNs);
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public boolean isZoomSupported() {
        Camera.Parameters parameters;
        if (this.camera != null && (parameters = this.getCameraParameters()) != null) {
            return parameters.isZoomSupported();
        }
        return false;
    }

    private boolean isZoomSupported(Camera.Parameters parameters) {
        if (parameters != null) {
            boolean isZoomSupported = parameters.isZoomSupported();
            return isZoomSupported;
        }
        return false;
    }

    public Camera.Parameters getCameraParameters() {
        try {
            Camera.Parameters parameters = this.camera.getParameters();
            return parameters;
        }
        catch (RuntimeException var3) {
            Logging.e("CAMERA1", "getCameraParameters: Camera.getParameters: ", var3);
            if (this.camera != null) {
                this.camera.release();
                this.camera = null;
            }
            return null;
        }
    }

    public boolean isTorchSupported() {
        Camera.Parameters parameters;
        if (this.camera != null && (parameters = this.getCameraParameters()) != null) {
            return VideoCapturerAndroid.isSupported("torch", parameters.getSupportedFlashModes());
        }
        return false;
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported == null ? false : supported.indexOf(value) >= 0;
    }

    public int setTorchMode(boolean isTorchOn) {
        if (isTorchOn) {
            if (this.camera != null) {
                Camera.Parameters parameter = this.camera.getParameters();
                parameter.setFlashMode("torch");
                this.camera.setParameters(parameter);
            }
        } else if (this.camera != null) {
            Camera.Parameters parameter = this.camera.getParameters();
            parameter.setFlashMode("off");
            this.camera.setParameters(parameter);
        }
        return 0;
    }

    public boolean isFocusSupported() {
        Camera.Parameters parameters;
        if (this.camera != null && (parameters = this.getCameraParameters()) != null) {
            boolean isFocusSupported = parameters.getMaxNumFocusAreas() > 0 && VideoCapturerAndroid.isSupported("auto", parameters.getSupportedFocusModes());
            return isFocusSupported;
        }
        return false;
    }

    private List<Integer> getZoomRatios() {
        Camera.Parameters parameters;
        if (this.camera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            return parameters.getZoomRatios();
        }
        return null;
    }

    public int setZoom(float zoomValue) {
        Camera.Parameters parameters;
        int maxZoom;
        if (zoomValue < 0.0f) {
            return -1;
        }
        int zoomRatio = (int)(zoomValue * 100.0f + 0.5f);
        List<Integer> zoomRatios = this.getZoomRatios();
        if (zoomRatios == null) {
            return -1;
        }
        int zoomLevel = 0;
        for (int i = 0; i < zoomRatios.size(); ++i) {
            maxZoom = zoomRatios.get(i);
            if (zoomRatio > maxZoom) continue;
            zoomLevel = i;
            break;
        }
        if (this.camera != null && this.isZoomSupported(parameters = this.getCameraParameters())) {
            maxZoom = parameters.getMaxZoom();
            if (zoomLevel > maxZoom) {
                Logging.w("CAMERA1", "zoom value is larger than maxZoom value");
                return -1;
            }
            parameters.setZoom(zoomLevel);
            try {
                this.camera.setParameters(parameters);
            }
            catch (Exception var8) {
                Logging.w("CAMERA1", "setParameters failed, zoomLevel: " + zoomLevel + ", " + var8);
            }
        }
        return 0;
    }

    public float getMaxZoom() {
        if (this.camera != null) {
            List<Integer> zoomRatios;
            Camera.Parameters parameters = this.getCameraParameters();
            int maxZoom = 0;
            if (this.isZoomSupported(parameters)) {
                maxZoom = parameters.getMaxZoom();
            }
            if ((zoomRatios = this.getZoomRatios()) != null && zoomRatios.size() > maxZoom) {
                return (float)zoomRatios.get(maxZoom).intValue() / 100.0f;
            }
        }
        return -1.0f;
    }

    public boolean isAutoFaceFocusSupported() {
        Camera.Parameters parameters;
        return this.camera != null && (parameters = this.getCameraParameters()) != null && parameters.getMaxNumDetectedFaces() > 0 && parameters.getMaxNumFocusAreas() > 0 && VideoCapturerAndroid.isSupported("auto", parameters.getSupportedFocusModes());
    }

    public boolean isExposureSupported() {
        Camera.Parameters parameters;
        boolean isExposureSupported = false;
        if (this.camera != null && (parameters = this.getCameraParameters()) != null) {
            isExposureSupported = parameters.getMaxNumMeteringAreas() > 0;
        }
        return isExposureSupported;
    }

    public void setCameraAutoFocusFaceModeEnabled(boolean enabled) {
        this.mIsAutoFaceFocusEnabled = enabled;
    }

    public int enableFaceDetection(boolean enable) {
        this.enableFaceDetection = enable;
        return 0;
    }

    public int setCameraCapturerConfiguration(CameraCapturerConfiguration config) {
        this.cameraCapturerConfiguration = config;
        String frontCameraDeviceName = CameraEnumerationAndroid.getNameOfFrontFacingDevice();
        String backCameraDeviceName = CameraEnumerationAndroid.getNameOfBackFacingDevice();
        int numberOfCameras = CameraEnumerationAndroid.getDeviceCount();
        if (this.cameraCapturerConfiguration.cameraDirection.getValue() == 0) {
            if (numberOfCameras >= 1 && backCameraDeviceName != null) {
                this.id = 0;
            }
        } else if (numberOfCameras >= 1 && frontCameraDeviceName != null) {
            this.id = 1;
        }
        return 0;
    }

    private void startFaceDetect() {
        if (this.camera != null) {
            this.camera.startFaceDetection();
            this.camera.setFaceDetectionListener(new Camera.FaceDetectionListener(){

                public void onFaceDetection(Camera.Face[] faces, Camera camera) {
                    VideoCapturerAndroid.this.rtcEngineEventHandler.onFacePositionChanged(VideoCapturerAndroid.this.surfaceWidth, VideoCapturerAndroid.this.surfaceHeight, VideoCapturerAndroid.this.transForm(faces));
                }
            });
        }
    }

    private void stopFaceDetect() {
        if (this.camera != null) {
            this.camera.stopFaceDetection();
        }
    }

    private IRtcEngineEventHandler.ARFacePositionInfo[] transForm(Camera.Face[] faces) {
        Matrix matrix = new Matrix();
        boolean mirror = this.getCurrentCameraId() == 1;
        if (mirror) {
            matrix.setScale(-1.0f, 1.0f);
        } else {
            matrix.setScale(1.0f, 1.0f);
        }
        matrix.postRotate(Float.valueOf(this.getFaceOrientation()).floatValue());
        matrix.postScale((float)this.surfaceWidth / 2000.0f, (float)this.surfaceHeight / 2000.0f);
        matrix.postTranslate((float)this.surfaceWidth / 2.0f, (float)this.surfaceHeight / 2.0f);
        HashSet<IRtcEngineEventHandler.ARFacePositionInfo> list = new HashSet<IRtcEngineEventHandler.ARFacePositionInfo>();
        for (Camera.Face rectF : faces) {
            RectF srcRect = new RectF(rectF.rect);
            RectF dstRect = new RectF(0.0f, 0.0f, 0.0f, 0.0f);
            matrix.mapRect(dstRect, srcRect);
            IRtcEngineEventHandler.ARFacePositionInfo arFacePositionInfo = new IRtcEngineEventHandler.ARFacePositionInfo();
            arFacePositionInfo.x = dstRect.left;
            arFacePositionInfo.y = dstRect.top;
            arFacePositionInfo.height = dstRect.bottom - dstRect.top;
            arFacePositionInfo.width = dstRect.right - dstRect.left;
            arFacePositionInfo.distance = 0;
            list.add(arFacePositionInfo);
        }
        return list.toArray(new IRtcEngineEventHandler.ARFacePositionInfo[0]);
    }

    private boolean isForeground() {
        if (this.applicationContext != null) {
            ActivityManager activityManager = (ActivityManager)this.applicationContext.getSystemService("activity");
            List processes = activityManager.getRunningAppProcesses();
            if (processes == null) {
                Logging.e("CAMERA1", "List of RunningAppProcessInfo is null");
                return false;
            }
            for (int i = 0; i < processes.size(); ++i) {
                ActivityManager.RunningAppProcessInfo processInfo = (ActivityManager.RunningAppProcessInfo)processes.get(i);
                if (processInfo == null) {
                    Logging.e("CAMERA1", "ActivityManager.RunningAppProcessInfo is null");
                    continue;
                }
                if (!processInfo.processName.equals(this.applicationContext.getPackageName()) || processInfo.importance != 100) continue;
                return true;
            }
        }
        return false;
    }

    public int allocate() {
        try {
            this.camera = Camera.open((int)this.id);
        }
        catch (RuntimeException var2) {
            Logging.e("CAMERA1", "allocate: Camera.open: ", var2);
            return -1;
        }
        Camera.CameraInfo cameraInfo = VideoCapturerAndroid.getCameraInfo(this.id);
        if (cameraInfo == null) {
            this.camera.release();
            this.camera = null;
            return -2;
        }
        return 0;
    }

    protected static Camera.CameraInfo getCameraInfo(int id) {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)id, (Camera.CameraInfo)cameraInfo);
            return cameraInfo;
        }
        catch (RuntimeException var3) {
            Logging.e("CAMERA1", "getCameraInfo: Camera.getCameraInfo: ", var3);
            return null;
        }
    }
}

