/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.recorder;

import android.media.MediaFormat;
import androidx.annotation.RequiresApi;
import java.util.Objects;

public class AudioEncodeConfig {
    final String codecName;
    final String mimeType;
    final int bitRate;
    final int sampleRate;
    final int channelCount;
    final int profile;

    @RequiresApi(api=19)
    public AudioEncodeConfig(String codecName, String mimeType, int bitRate, int sampleRate, int channelCount, int profile) {
        this.codecName = codecName;
        this.mimeType = Objects.requireNonNull(mimeType);
        this.bitRate = bitRate;
        this.sampleRate = sampleRate;
        this.channelCount = channelCount;
        this.profile = profile;
    }

    MediaFormat toFormat() {
        MediaFormat format = MediaFormat.createAudioFormat((String)this.mimeType, (int)this.sampleRate, (int)this.channelCount);
        format.setInteger("aac-profile", this.profile);
        format.setInteger("bitrate", this.bitRate);
        return format;
    }

    public String toString() {
        return "AudioEncodeConfig{codecName='" + this.codecName + '\'' + ", mimeType='" + this.mimeType + '\'' + ", bitRate=" + this.bitRate + ", sampleRate=" + this.sampleRate + ", channelCount=" + this.channelCount + ", profile=" + this.profile + '}';
    }
}

