/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.recorder;

import android.hardware.display.VirtualDisplay;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.RequiresApi;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.recorder.AudioEncodeConfig;
import org.webrtc.recorder.BaseEncoder;
import org.webrtc.recorder.Encoder;
import org.webrtc.recorder.MicRecorder;
import org.webrtc.recorder.VideoEncodeConfig;
import org.webrtc.recorder.VideoEncoder;

public class ScreenRecorder {
    private static final String TAG = "ScreenRecorder";
    private static final boolean VERBOSE = true;
    private static final int INVALID_INDEX = -1;
    static final String VIDEO_AVC = "video/avc";
    static final String AUDIO_AAC = "audio/mp4a-latm";
    private String mDstPath;
    private VideoEncoder mVideoEncoder;
    private MicRecorder mAudioEncoder;
    private MediaFormat mVideoOutputFormat = null;
    private MediaFormat mAudioOutputFormat = null;
    private int mVideoTrackIndex = -1;
    private int mAudioTrackIndex = -1;
    private MediaMuxer mMuxer;
    private boolean mMuxerStarted = false;
    private AtomicBoolean mForceQuit = new AtomicBoolean(false);
    private AtomicBoolean mIsRunning = new AtomicBoolean(false);
    private VirtualDisplay mVirtualDisplay;
    private HandlerThread mWorker;
    private CallbackHandler mHandler;
    private Callback mCallback;
    private LinkedList<Integer> mPendingVideoEncoderBufferIndices = new LinkedList();
    private LinkedList<Integer> mPendingAudioEncoderBufferIndices = new LinkedList();
    private LinkedList<MediaCodec.BufferInfo> mPendingAudioEncoderBufferInfos = new LinkedList();
    private LinkedList<MediaCodec.BufferInfo> mPendingVideoEncoderBufferInfos = new LinkedList();
    private static final int MSG_START = 0;
    private static final int MSG_STOP = 1;
    private static final int MSG_ERROR = 2;
    private static final int STOP_WITH_EOS = 1;
    private long mVideoPtsOffset;
    private long mAudioPtsOffset;

    public ScreenRecorder(VideoEncodeConfig video, AudioEncodeConfig audio, VirtualDisplay display, String dstPath) {
        this.mVirtualDisplay = display;
        this.mDstPath = dstPath;
        this.mVideoEncoder = new VideoEncoder(video);
        this.mAudioEncoder = audio == null ? null : new MicRecorder(audio);
    }

    public final void quit() {
        this.mForceQuit.set(true);
        if (!this.mIsRunning.get()) {
            this.release();
        } else {
            this.signalStop(false);
        }
    }

    public void start() {
        if (this.mWorker != null) {
            throw new IllegalStateException();
        }
        this.mWorker = new HandlerThread(TAG);
        this.mWorker.start();
        this.mHandler = new CallbackHandler(this.mWorker.getLooper());
        this.mHandler.sendEmptyMessage(0);
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public String getSavedPath() {
        return this.mDstPath;
    }

    private void signalEndOfStream() {
        MediaCodec.BufferInfo eos = new MediaCodec.BufferInfo();
        ByteBuffer buffer = ByteBuffer.allocate(0);
        eos.set(0, 0, 0L, 4);
        Log.i((String)TAG, (String)"Signal EOS to muxer ");
        if (this.mVideoTrackIndex != -1) {
            this.writeSampleData(this.mVideoTrackIndex, eos, buffer);
        }
        if (this.mAudioTrackIndex != -1) {
            this.writeSampleData(this.mAudioTrackIndex, eos, buffer);
        }
        this.mVideoTrackIndex = -1;
        this.mAudioTrackIndex = -1;
    }

    @RequiresApi(api=20)
    private void record() {
        if (this.mIsRunning.get() || this.mForceQuit.get()) {
            throw new IllegalStateException();
        }
        if (this.mVirtualDisplay == null) {
            throw new IllegalStateException("maybe release");
        }
        this.mIsRunning.set(true);
        try {
            this.mMuxer = new MediaMuxer(this.mDstPath, 0);
            this.prepareVideoEncoder();
            this.prepareAudioEncoder();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.mVirtualDisplay.setSurface(this.mVideoEncoder.getInputSurface());
        Log.d((String)TAG, (String)("set surface to display: " + this.mVirtualDisplay.getDisplay()));
    }

    private void muxVideo(int index, MediaCodec.BufferInfo buffer) {
        if (!this.mIsRunning.get()) {
            Log.w((String)TAG, (String)"muxVideo: Already stopped!");
            return;
        }
        if (!this.mMuxerStarted || this.mVideoTrackIndex == -1) {
            this.mPendingVideoEncoderBufferIndices.add(index);
            this.mPendingVideoEncoderBufferInfos.add(buffer);
            return;
        }
        ByteBuffer encodedData = this.mVideoEncoder.getOutputBuffer(index);
        this.writeSampleData(this.mVideoTrackIndex, buffer, encodedData);
        this.mVideoEncoder.releaseOutputBuffer(index);
        if ((buffer.flags & 4) != 0) {
            Log.d((String)TAG, (String)"Stop encoder and muxer, since the buffer has been marked with EOS");
            this.mVideoTrackIndex = -1;
            this.signalStop(true);
        }
    }

    private void muxAudio(int index, MediaCodec.BufferInfo buffer) {
        if (!this.mIsRunning.get()) {
            Log.w((String)TAG, (String)"muxAudio: Already stopped!");
            return;
        }
        if (!this.mMuxerStarted || this.mAudioTrackIndex == -1) {
            this.mPendingAudioEncoderBufferIndices.add(index);
            this.mPendingAudioEncoderBufferInfos.add(buffer);
            return;
        }
        ByteBuffer encodedData = this.mAudioEncoder.getOutputBuffer(index);
        this.writeSampleData(this.mAudioTrackIndex, buffer, encodedData);
        this.mAudioEncoder.releaseOutputBuffer(index);
        if ((buffer.flags & 4) != 0) {
            Log.d((String)TAG, (String)"Stop encoder and muxer, since the buffer has been marked with EOS");
            this.mAudioTrackIndex = -1;
            this.signalStop(true);
        }
    }

    private void writeSampleData(int track, MediaCodec.BufferInfo buffer, ByteBuffer encodedData) {
        boolean eos;
        if ((buffer.flags & 2) != 0) {
            Log.d((String)TAG, (String)"Ignoring BUFFER_FLAG_CODEC_CONFIG");
            buffer.size = 0;
        }
        boolean bl = eos = (buffer.flags & 4) != 0;
        if (buffer.size == 0 && !eos) {
            Log.d((String)TAG, (String)"info.size == 0, drop it.");
            encodedData = null;
        } else {
            if (buffer.presentationTimeUs != 0L) {
                if (track == this.mVideoTrackIndex) {
                    this.resetVideoPts(buffer);
                } else if (track == this.mAudioTrackIndex) {
                    this.resetAudioPts(buffer);
                }
            }
            Log.d((String)TAG, (String)("[" + Thread.currentThread().getId() + "] Got buffer, track=" + track + ", info: size=" + buffer.size + ", presentationTimeUs=" + buffer.presentationTimeUs));
            if (!eos && this.mCallback != null) {
                this.mCallback.onRecording(buffer.presentationTimeUs);
            }
        }
        if (encodedData != null) {
            encodedData.position(buffer.offset);
            encodedData.limit(buffer.offset + buffer.size);
            this.mMuxer.writeSampleData(track, encodedData, buffer);
            Log.i((String)TAG, (String)("Sent " + buffer.size + " bytes to MediaMuxer on track " + track));
        }
    }

    private void resetAudioPts(MediaCodec.BufferInfo buffer) {
        if (this.mAudioPtsOffset == 0L) {
            this.mAudioPtsOffset = buffer.presentationTimeUs;
            buffer.presentationTimeUs = 0L;
        } else {
            buffer.presentationTimeUs -= this.mAudioPtsOffset;
        }
    }

    private void resetVideoPts(MediaCodec.BufferInfo buffer) {
        if (this.mVideoPtsOffset == 0L) {
            this.mVideoPtsOffset = buffer.presentationTimeUs;
            buffer.presentationTimeUs = 0L;
        } else {
            buffer.presentationTimeUs -= this.mVideoPtsOffset;
        }
    }

    private void resetVideoOutputFormat(MediaFormat newFormat) {
        if (this.mVideoTrackIndex >= 0 || this.mMuxerStarted) {
            throw new IllegalStateException("output format already changed!");
        }
        Log.i((String)TAG, (String)("Video output format changed.\n New format: " + newFormat.toString()));
        this.mVideoOutputFormat = newFormat;
    }

    private void resetAudioOutputFormat(MediaFormat newFormat) {
        if (this.mAudioTrackIndex >= 0 || this.mMuxerStarted) {
            throw new IllegalStateException("output format already changed!");
        }
        Log.i((String)TAG, (String)("Audio output format changed.\n New format: " + newFormat.toString()));
        this.mAudioOutputFormat = newFormat;
    }

    private void startMuxerIfReady() {
        int index;
        MediaCodec.BufferInfo info;
        if (this.mMuxerStarted || this.mVideoOutputFormat == null || this.mAudioEncoder != null && this.mAudioOutputFormat == null) {
            return;
        }
        this.mVideoTrackIndex = this.mMuxer.addTrack(this.mVideoOutputFormat);
        this.mAudioTrackIndex = this.mAudioEncoder == null ? -1 : this.mMuxer.addTrack(this.mAudioOutputFormat);
        this.mMuxer.start();
        this.mMuxerStarted = true;
        Log.i((String)TAG, (String)("Started media muxer, videoIndex=" + this.mVideoTrackIndex));
        if (this.mPendingVideoEncoderBufferIndices.isEmpty() && this.mPendingAudioEncoderBufferIndices.isEmpty()) {
            return;
        }
        Log.i((String)TAG, (String)"Mux pending video output buffers...");
        while ((info = this.mPendingVideoEncoderBufferInfos.poll()) != null) {
            index = this.mPendingVideoEncoderBufferIndices.poll();
            this.muxVideo(index, info);
        }
        if (this.mAudioEncoder != null) {
            while ((info = this.mPendingAudioEncoderBufferInfos.poll()) != null) {
                index = this.mPendingAudioEncoderBufferIndices.poll();
                this.muxAudio(index, info);
            }
        }
        Log.i((String)TAG, (String)"Mux pending video output buffers done.");
    }

    private void prepareVideoEncoder() throws IOException {
        BaseEncoder.Callback callback = new BaseEncoder.Callback(){
            boolean ranIntoError = false;

            @Override
            public void onOutputBufferAvailable(BaseEncoder codec, int index, MediaCodec.BufferInfo info) {
                Log.i((String)ScreenRecorder.TAG, (String)("VideoEncoder output buffer available: index=" + index));
                try {
                    ScreenRecorder.this.muxVideo(index, info);
                }
                catch (Exception e) {
                    Log.e((String)ScreenRecorder.TAG, (String)"Muxer encountered an error! ", (Throwable)e);
                    Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)e).sendToTarget();
                }
            }

            @Override
            public void onError(Encoder codec, Exception e) {
                this.ranIntoError = true;
                Log.e((String)ScreenRecorder.TAG, (String)"VideoEncoder ran into an error! ", (Throwable)e);
                Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)e).sendToTarget();
            }

            @Override
            public void onOutputFormatChanged(BaseEncoder codec, MediaFormat format) {
                ScreenRecorder.this.resetVideoOutputFormat(format);
                ScreenRecorder.this.startMuxerIfReady();
            }
        };
        this.mVideoEncoder.setCallback(callback);
        this.mVideoEncoder.prepare();
    }

    private void prepareAudioEncoder() throws IOException {
        MicRecorder micRecorder = this.mAudioEncoder;
        if (micRecorder == null) {
            return;
        }
        BaseEncoder.Callback callback = new BaseEncoder.Callback(){
            boolean ranIntoError = false;

            @Override
            public void onOutputBufferAvailable(BaseEncoder codec, int index, MediaCodec.BufferInfo info) {
                Log.i((String)ScreenRecorder.TAG, (String)("[" + Thread.currentThread().getId() + "] AudioEncoder output buffer available: index=" + index));
                try {
                    ScreenRecorder.this.muxAudio(index, info);
                }
                catch (Exception e) {
                    Log.e((String)ScreenRecorder.TAG, (String)"Muxer encountered an error! ", (Throwable)e);
                    Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)e).sendToTarget();
                }
            }

            @Override
            public void onOutputFormatChanged(BaseEncoder codec, MediaFormat format) {
                Log.d((String)ScreenRecorder.TAG, (String)("[" + Thread.currentThread().getId() + "] AudioEncoder returned new format " + format));
                ScreenRecorder.this.resetAudioOutputFormat(format);
                ScreenRecorder.this.startMuxerIfReady();
            }

            @Override
            public void onError(Encoder codec, Exception e) {
                this.ranIntoError = true;
                Log.e((String)ScreenRecorder.TAG, (String)"MicRecorder ran into an error! ", (Throwable)e);
                Message.obtain((Handler)ScreenRecorder.this.mHandler, (int)2, (Object)e).sendToTarget();
            }
        };
        micRecorder.setCallback(callback);
        micRecorder.prepare();
    }

    private void signalStop(boolean stopWithEOS) {
        Message msg = Message.obtain((Handler)this.mHandler, (int)1, (int)(stopWithEOS ? 1 : 0), (int)0);
        this.mHandler.sendMessageAtFrontOfQueue(msg);
    }

    private void stopEncoders() {
        this.mIsRunning.set(false);
        this.mPendingAudioEncoderBufferInfos.clear();
        this.mPendingAudioEncoderBufferIndices.clear();
        this.mPendingVideoEncoderBufferInfos.clear();
        this.mPendingVideoEncoderBufferIndices.clear();
        try {
            if (this.mVideoEncoder != null) {
                this.mVideoEncoder.stop();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            if (this.mAudioEncoder != null) {
                this.mAudioEncoder.stop();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void release() {
        if (this.mVirtualDisplay != null) {
            if (Build.VERSION.SDK_INT >= 20) {
                this.mVirtualDisplay.setSurface(null);
            }
            this.mVirtualDisplay = null;
        }
        this.mAudioOutputFormat = null;
        this.mVideoOutputFormat = null;
        this.mAudioTrackIndex = -1;
        this.mVideoTrackIndex = -1;
        this.mMuxerStarted = false;
        if (this.mWorker != null) {
            this.mWorker.quitSafely();
            this.mWorker = null;
        }
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.release();
            this.mVideoEncoder = null;
        }
        if (this.mAudioEncoder != null) {
            this.mAudioEncoder.release();
            this.mAudioEncoder = null;
        }
        if (this.mMuxer != null) {
            try {
                this.mMuxer.stop();
                this.mMuxer.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mMuxer = null;
        }
        this.mHandler = null;
    }

    protected void finalize() throws Throwable {
        if (this.mVirtualDisplay != null) {
            Log.e((String)TAG, (String)"release() not called!");
            this.release();
        }
    }

    private class CallbackHandler
    extends Handler {
        CallbackHandler(Looper looper) {
            super(looper);
        }

        @RequiresApi(api=20)
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    try {
                        ScreenRecorder.this.record();
                        if (ScreenRecorder.this.mCallback == null) break;
                        ScreenRecorder.this.mCallback.onStart();
                        break;
                    }
                    catch (Exception e) {
                        msg.obj = e;
                    }
                }
                case 1: 
                case 2: {
                    ScreenRecorder.this.stopEncoders();
                    if (msg.arg1 != 1) {
                        ScreenRecorder.this.signalEndOfStream();
                    }
                    if (ScreenRecorder.this.mCallback != null) {
                        ScreenRecorder.this.mCallback.onStop((Throwable)msg.obj);
                    }
                    ScreenRecorder.this.release();
                }
            }
        }
    }

    public static interface Callback {
        public void onStop(Throwable var1);

        public void onStart();

        public void onRecording(long var1);
    }
}

