/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.recorder;

import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import androidx.annotation.RequiresApi;
import java.util.Objects;
import org.webrtc.recorder.Utils;

public class VideoEncodeConfig {
    final int width;
    final int height;
    final int bitrate;
    final int framerate;
    final int iframeInterval;
    final String codecName;
    final String mimeType;
    final MediaCodecInfo.CodecProfileLevel codecProfileLevel;

    @RequiresApi(api=19)
    public VideoEncodeConfig(int width, int height, int bitrate, int framerate, int iframeInterval, String codecName, String mimeType, MediaCodecInfo.CodecProfileLevel codecProfileLevel) {
        this.width = width;
        this.height = height;
        this.bitrate = bitrate;
        this.framerate = framerate;
        this.iframeInterval = iframeInterval;
        this.codecName = codecName;
        this.mimeType = Objects.requireNonNull(mimeType);
        this.codecProfileLevel = codecProfileLevel;
    }

    MediaFormat toFormat() {
        MediaFormat format = MediaFormat.createVideoFormat((String)this.mimeType, (int)this.width, (int)this.height);
        format.setInteger("color-format", 2130708361);
        format.setInteger("bitrate", this.bitrate);
        format.setInteger("frame-rate", this.framerate);
        format.setInteger("i-frame-interval", this.iframeInterval);
        if (this.codecProfileLevel != null && this.codecProfileLevel.profile != 0 && this.codecProfileLevel.level != 0) {
            format.setInteger("profile", this.codecProfileLevel.profile);
            format.setInteger("level", this.codecProfileLevel.level);
        }
        return format;
    }

    public String toString() {
        return "VideoEncodeConfig{width=" + this.width + ", height=" + this.height + ", bitrate=" + this.bitrate + ", framerate=" + this.framerate + ", iframeInterval=" + this.iframeInterval + ", codecName='" + this.codecName + '\'' + ", mimeType='" + this.mimeType + '\'' + ", codecProfileLevel=" + (this.codecProfileLevel == null ? "" : Utils.avcProfileLevelToString(this.codecProfileLevel)) + '}';
    }
}

