/*
 * Decompiled with CFR 0.152.
 */
package org.anyrtc;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.DatabaseErrorHandler;
import android.database.sqlite.SQLiteDatabase;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.UserHandle;
import android.util.Range;
import android.view.Display;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.anyrtc.Camera2Enumerator;
import org.anyrtc.CameraEnumerationAndroid;
import org.anyrtc.CameraSession;
import org.anyrtc.Histogram;
import org.anyrtc.SurfaceTextureHelper;
import org.anyrtc.TextureBufferImpl;
import org.anyrtc.VideoFrame;
import org.webrtc.Logging;
import org.webrtc.Size;

@TargetApi(value=21)
class Camera2Session
extends Context
implements CameraSession {
    private static final String TAG = "Camera2Session";
    private static final Histogram camera2StartTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StartTimeMs", 1, 10000, 50);
    private static final Histogram camera2StopTimeMsHistogram = Histogram.createCounts("WebRTC.Android.Camera2.StopTimeMs", 1, 10000, 50);
    private static final Histogram camera2ResolutionHistogram = Histogram.createEnumeration("WebRTC.Android.Camera2.Resolution", CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    private final Handler cameraThreadHandler;
    private final CameraSession.CreateSessionCallback callback;
    private final CameraSession.Events events;
    private final Context applicationContext;
    private final CameraManager cameraManager;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final String cameraId;
    private final int width;
    private final int height;
    private final int framerate;
    private CameraCharacteristics cameraCharacteristics;
    private int cameraOrientation;
    private boolean isCameraFrontFacing;
    private int fpsUnitFactor;
    private CameraEnumerationAndroid.CaptureFormat captureFormat;
    @Nullable
    private CameraDevice cameraDevice;
    @Nullable
    private Surface surface;
    @Nullable
    private CameraCaptureSession captureSession;
    private SessionState state = SessionState.RUNNING;
    private boolean firstFrameReported;
    private final long constructionTimeNs;

    public AssetManager getAssets() {
        return null;
    }

    public Resources getResources() {
        return null;
    }

    public PackageManager getPackageManager() {
        return null;
    }

    public ContentResolver getContentResolver() {
        return null;
    }

    public Looper getMainLooper() {
        return null;
    }

    public Context getApplicationContext() {
        return null;
    }

    public void setTheme(int resid) {
    }

    public Resources.Theme getTheme() {
        return null;
    }

    public ClassLoader getClassLoader() {
        return null;
    }

    public String getPackageName() {
        return null;
    }

    public ApplicationInfo getApplicationInfo() {
        return null;
    }

    public String getPackageResourcePath() {
        return null;
    }

    public String getPackageCodePath() {
        return null;
    }

    public SharedPreferences getSharedPreferences(String name, int mode) {
        return null;
    }

    public boolean moveSharedPreferencesFrom(Context sourceContext, String name) {
        return false;
    }

    public boolean deleteSharedPreferences(String name) {
        return false;
    }

    public FileInputStream openFileInput(String name) throws FileNotFoundException {
        return null;
    }

    public FileOutputStream openFileOutput(String name, int mode) throws FileNotFoundException {
        return null;
    }

    public boolean deleteFile(String name) {
        return false;
    }

    public File getFileStreamPath(String name) {
        return null;
    }

    public File getDataDir() {
        return null;
    }

    public File getFilesDir() {
        return null;
    }

    public File getNoBackupFilesDir() {
        return null;
    }

    @Nullable
    public File getExternalFilesDir(@Nullable String type) {
        return null;
    }

    public File[] getExternalFilesDirs(String type) {
        return new File[0];
    }

    public File getObbDir() {
        return null;
    }

    public File[] getObbDirs() {
        return new File[0];
    }

    public File getCacheDir() {
        return null;
    }

    public File getCodeCacheDir() {
        return null;
    }

    @Nullable
    public File getExternalCacheDir() {
        return null;
    }

    public File[] getExternalCacheDirs() {
        return new File[0];
    }

    public File[] getExternalMediaDirs() {
        return new File[0];
    }

    public String[] fileList() {
        return new String[0];
    }

    public File getDir(String name, int mode) {
        return null;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory) {
        return null;
    }

    public SQLiteDatabase openOrCreateDatabase(String name, int mode, SQLiteDatabase.CursorFactory factory, @Nullable DatabaseErrorHandler errorHandler) {
        return null;
    }

    public boolean moveDatabaseFrom(Context sourceContext, String name) {
        return false;
    }

    public boolean deleteDatabase(String name) {
        return false;
    }

    public File getDatabasePath(String name) {
        return null;
    }

    public String[] databaseList() {
        return new String[0];
    }

    public Drawable getWallpaper() {
        return null;
    }

    public Drawable peekWallpaper() {
        return null;
    }

    public int getWallpaperDesiredMinimumWidth() {
        return 0;
    }

    public int getWallpaperDesiredMinimumHeight() {
        return 0;
    }

    public void setWallpaper(Bitmap bitmap) throws IOException {
    }

    public void setWallpaper(InputStream data) throws IOException {
    }

    public void clearWallpaper() throws IOException {
    }

    public void startActivity(Intent intent) {
    }

    public void startActivity(Intent intent, @Nullable Bundle options) {
    }

    public void startActivities(Intent[] intents) {
    }

    public void startActivities(Intent[] intents, Bundle options) {
    }

    public void startIntentSender(IntentSender intent, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags) throws IntentSender.SendIntentException {
    }

    public void startIntentSender(IntentSender intent, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
    }

    public void sendBroadcast(Intent intent) {
    }

    public void sendBroadcast(Intent intent, @Nullable String receiverPermission) {
    }

    public void sendOrderedBroadcast(Intent intent, @Nullable String receiverPermission) {
    }

    public void sendOrderedBroadcast(@NonNull Intent intent, @Nullable String receiverPermission, @Nullable BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
    }

    public void sendBroadcastAsUser(Intent intent, UserHandle user) {
    }

    public void sendBroadcastAsUser(Intent intent, UserHandle user, @Nullable String receiverPermission) {
    }

    public void sendOrderedBroadcastAsUser(Intent intent, UserHandle user, @Nullable String receiverPermission, BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
    }

    public void sendStickyBroadcast(Intent intent) {
    }

    public void sendStickyOrderedBroadcast(Intent intent, BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
    }

    public void removeStickyBroadcast(Intent intent) {
    }

    public void sendStickyBroadcastAsUser(Intent intent, UserHandle user) {
    }

    public void sendStickyOrderedBroadcastAsUser(Intent intent, UserHandle user, BroadcastReceiver resultReceiver, @Nullable Handler scheduler, int initialCode, @Nullable String initialData, @Nullable Bundle initialExtras) {
    }

    public void removeStickyBroadcastAsUser(Intent intent, UserHandle user) {
    }

    @Nullable
    public Intent registerReceiver(@Nullable BroadcastReceiver receiver, IntentFilter filter) {
        return null;
    }

    @Nullable
    public Intent registerReceiver(@Nullable BroadcastReceiver receiver, IntentFilter filter, int flags) {
        return null;
    }

    @Nullable
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler) {
        return null;
    }

    @Nullable
    public Intent registerReceiver(BroadcastReceiver receiver, IntentFilter filter, @Nullable String broadcastPermission, @Nullable Handler scheduler, int flags) {
        return null;
    }

    public void unregisterReceiver(BroadcastReceiver receiver) {
    }

    @Nullable
    public ComponentName startService(Intent service) {
        return null;
    }

    @Nullable
    public ComponentName startForegroundService(Intent service) {
        return null;
    }

    public boolean stopService(Intent service) {
        return false;
    }

    public boolean bindService(Intent service, @NonNull ServiceConnection conn, int flags) {
        return false;
    }

    public void unbindService(@NonNull ServiceConnection conn) {
    }

    public boolean startInstrumentation(@NonNull ComponentName className, @Nullable String profileFile, @Nullable Bundle arguments) {
        return false;
    }

    public Object getSystemService(@NonNull String name) {
        return null;
    }

    @Nullable
    public String getSystemServiceName(@NonNull Class<?> serviceClass) {
        return null;
    }

    public int checkPermission(@NonNull String permission2, int pid, int uid) {
        return 0;
    }

    public int checkCallingPermission(@NonNull String permission2) {
        return 0;
    }

    public int checkCallingOrSelfPermission(@NonNull String permission2) {
        return 0;
    }

    public int checkSelfPermission(@NonNull String permission2) {
        return 0;
    }

    public void enforcePermission(@NonNull String permission2, int pid, int uid, @Nullable String message) {
    }

    public void enforceCallingPermission(@NonNull String permission2, @Nullable String message) {
    }

    public void enforceCallingOrSelfPermission(@NonNull String permission2, @Nullable String message) {
    }

    public void grantUriPermission(String toPackage, Uri uri, int modeFlags) {
    }

    public void revokeUriPermission(Uri uri, int modeFlags) {
    }

    public void revokeUriPermission(String toPackage, Uri uri, int modeFlags) {
    }

    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags) {
        return 0;
    }

    public int checkCallingUriPermission(Uri uri, int modeFlags) {
        return 0;
    }

    public int checkCallingOrSelfUriPermission(Uri uri, int modeFlags) {
        return 0;
    }

    public int checkUriPermission(@Nullable Uri uri, @Nullable String readPermission, @Nullable String writePermission, int pid, int uid, int modeFlags) {
        return 0;
    }

    public void enforceUriPermission(Uri uri, int pid, int uid, int modeFlags, String message) {
    }

    public void enforceCallingUriPermission(Uri uri, int modeFlags, String message) {
    }

    public void enforceCallingOrSelfUriPermission(Uri uri, int modeFlags, String message) {
    }

    public void enforceUriPermission(@Nullable Uri uri, @Nullable String readPermission, @Nullable String writePermission, int pid, int uid, int modeFlags, @Nullable String message) {
    }

    public Context createPackageContext(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    public Context createContextForSplit(String splitName) throws PackageManager.NameNotFoundException {
        return null;
    }

    public Context createConfigurationContext(@NonNull Configuration overrideConfiguration) {
        return null;
    }

    public Context createDisplayContext(@NonNull Display display) {
        return null;
    }

    public Context createDeviceProtectedStorageContext() {
        return null;
    }

    public boolean isDeviceProtectedStorage() {
        return false;
    }

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate) {
        new Camera2Session(callback, events, applicationContext, cameraManager, surfaceTextureHelper, cameraId, width, height, framerate);
    }

    private Camera2Session(CameraSession.CreateSessionCallback callback, CameraSession.Events events, Context applicationContext, CameraManager cameraManager, SurfaceTextureHelper surfaceTextureHelper, String cameraId, int width, int height, int framerate) {
        Logging.d(TAG, "Create new camera2 session on camera " + cameraId);
        this.constructionTimeNs = System.nanoTime();
        this.cameraThreadHandler = new Handler();
        this.callback = callback;
        this.events = events;
        this.applicationContext = applicationContext;
        this.cameraManager = cameraManager;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.width = width;
        this.height = height;
        this.framerate = framerate;
        this.start();
    }

    private void start() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "start");
        try {
            this.cameraCharacteristics = this.cameraManager.getCameraCharacteristics(this.cameraId);
        }
        catch (CameraAccessException e) {
            this.reportError("getCameraCharacteristics(): " + e.getMessage());
            return;
        }
        this.cameraOrientation = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        this.isCameraFrontFacing = (Integer)this.cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
        this.findCaptureFormat();
        this.openCamera();
    }

    private void findCaptureFormat() {
        this.checkIsOnCameraThread();
        Range[] fpsRanges = (Range[])this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        this.fpsUnitFactor = Camera2Enumerator.getFpsUnitFactor(fpsRanges);
        List<CameraEnumerationAndroid.CaptureFormat.FramerateRange> framerateRanges = Camera2Enumerator.convertFramerates(fpsRanges, this.fpsUnitFactor);
        List<Size> sizes = Camera2Enumerator.getSupportedSizes(this.cameraCharacteristics);
        Logging.d(TAG, "Available preview sizes: " + sizes);
        Logging.d(TAG, "Available fps ranges: " + framerateRanges);
        if (framerateRanges.isEmpty() || sizes.isEmpty()) {
            this.reportError("No supported capture formats.");
            return;
        }
        CameraEnumerationAndroid.CaptureFormat.FramerateRange bestFpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange(framerateRanges, this.framerate);
        Size bestSize = CameraEnumerationAndroid.getClosestSupportedSize(sizes, this.width, this.height);
        CameraEnumerationAndroid.reportCameraResolution(camera2ResolutionHistogram, bestSize);
        this.captureFormat = new CameraEnumerationAndroid.CaptureFormat(bestSize.width, bestSize.height, bestFpsRange);
        Logging.d(TAG, "Using capture format: " + this.captureFormat);
    }

    private void openCamera() {
        this.checkIsOnCameraThread();
        Logging.d(TAG, "Opening camera " + this.cameraId);
        this.events.onCameraOpening();
        try {
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
                return;
            }
            this.cameraManager.openCamera(this.cameraId, (CameraDevice.StateCallback)new CameraStateCallback(), this.cameraThreadHandler);
        }
        catch (CameraAccessException e) {
            this.reportError("Failed to open camera: " + (Object)((Object)e));
            return;
        }
    }

    @Override
    public void stop() {
        Logging.d(TAG, "Stop camera2 session on camera " + this.cameraId);
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.state = SessionState.STOPPED;
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            camera2StopTimeMsHistogram.addSample(stopTimeMs);
        }
    }

    private void stopInternal() {
        Logging.d(TAG, "Stop internal");
        this.checkIsOnCameraThread();
        this.surfaceTextureHelper.stopListening();
        if (this.captureSession != null) {
            this.captureSession.close();
            this.captureSession = null;
        }
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        if (this.cameraDevice != null) {
            this.cameraDevice.close();
            this.cameraDevice = null;
        }
        Logging.d(TAG, "Stop done");
    }

    private void reportError(String error) {
        this.checkIsOnCameraThread();
        Logging.e(TAG, "Error: " + error);
        boolean startFailure = this.captureSession == null && this.state != SessionState.STOPPED;
        this.state = SessionState.STOPPED;
        this.stopInternal();
        if (startFailure) {
            this.callback.onFailure(CameraSession.FailureType.ERROR, error);
        } else {
            this.events.onCameraError(this, error);
        }
    }

    private int getFrameOrientation() {
        int rotation = CameraSession.getDeviceOrientation(this.applicationContext);
        if (!this.isCameraFrontFacing) {
            rotation = 360 - rotation;
        }
        return (this.cameraOrientation + rotation) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private static class CameraCaptureCallback
    extends CameraCaptureSession.CaptureCallback {
        private CameraCaptureCallback() {
        }

        public void onCaptureFailed(CameraCaptureSession session, CaptureRequest request, CaptureFailure failure) {
            Logging.d(Camera2Session.TAG, "Capture failed: " + failure);
        }
    }

    private class CaptureSessionCallback
    extends CameraCaptureSession.StateCallback {
        private CaptureSessionCallback() {
        }

        public void onConfigureFailed(CameraCaptureSession session) {
            Camera2Session.this.checkIsOnCameraThread();
            session.close();
            Camera2Session.this.reportError("Failed to configure capture session.");
        }

        public void onConfigured(CameraCaptureSession session) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera capture session configured.");
            Camera2Session.this.captureSession = session;
            try {
                CaptureRequest.Builder captureRequestBuilder = Camera2Session.this.cameraDevice.createCaptureRequest(3);
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, (Object)new Range((Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.min / Camera2Session.this.fpsUnitFactor), (Comparable)Integer.valueOf(((Camera2Session)Camera2Session.this).captureFormat.framerate.max / Camera2Session.this.fpsUnitFactor)));
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                captureRequestBuilder.set(CaptureRequest.CONTROL_AE_LOCK, (Object)false);
                this.chooseStabilizationMode(captureRequestBuilder);
                this.chooseFocusMode(captureRequestBuilder);
                captureRequestBuilder.addTarget(Camera2Session.this.surface);
                session.setRepeatingRequest(captureRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)new CameraCaptureCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException e) {
                Camera2Session.this.reportError("Failed to start capture request. " + (Object)((Object)e));
                return;
            }
            Camera2Session.this.surfaceTextureHelper.startListening(frame -> {
                Camera2Session.this.checkIsOnCameraThread();
                if (Camera2Session.this.state != SessionState.RUNNING) {
                    Logging.d(Camera2Session.TAG, "Texture frame captured but camera is no longer running.");
                    return;
                }
                if (!Camera2Session.this.firstFrameReported) {
                    Camera2Session.this.firstFrameReported = true;
                    int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - Camera2Session.this.constructionTimeNs);
                    camera2StartTimeMsHistogram.addSample(startTimeMs);
                }
                VideoFrame modifiedFrame = new VideoFrame(CameraSession.createTextureBufferWithModifiedTransformMatrix((TextureBufferImpl)frame.getBuffer(), Camera2Session.this.isCameraFrontFacing, -Camera2Session.this.cameraOrientation), Camera2Session.this.getFrameOrientation(), frame.getTimestampNs());
                Camera2Session.this.events.onFrameCaptured(Camera2Session.this, modifiedFrame);
                modifiedFrame.release();
            });
            Logging.d(Camera2Session.TAG, "Camera device successfully started.");
            Camera2Session.this.callback.onDone(Camera2Session.this);
        }

        private void chooseStabilizationMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableVideoStabilization;
            int[] availableOpticalStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION);
            if (availableOpticalStabilization != null) {
                for (int mode : availableOpticalStabilization) {
                    if (mode != 1) continue;
                    captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)1);
                    captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)0);
                    Logging.d(Camera2Session.TAG, "Using optical stabilization.");
                    return;
                }
            }
            for (int mode : availableVideoStabilization = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) {
                if (mode != 1) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_VIDEO_STABILIZATION_MODE, (Object)1);
                captureRequestBuilder.set(CaptureRequest.LENS_OPTICAL_STABILIZATION_MODE, (Object)0);
                Logging.d(Camera2Session.TAG, "Using video stabilization.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Stabilization not available.");
        }

        private void chooseFocusMode(CaptureRequest.Builder captureRequestBuilder) {
            int[] availableFocusModes;
            for (int mode : availableFocusModes = (int[])Camera2Session.this.cameraCharacteristics.get(CameraCharacteristics.CONTROL_AF_AVAILABLE_MODES)) {
                if (mode != 3) continue;
                captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)3);
                Logging.d(Camera2Session.TAG, "Using continuous video auto-focus.");
                return;
            }
            Logging.d(Camera2Session.TAG, "Auto-focus is not available.");
        }
    }

    private class CameraStateCallback
    extends CameraDevice.StateCallback {
        private CameraStateCallback() {
        }

        private String getErrorDescription(int errorCode) {
            switch (errorCode) {
                case 4: {
                    return "Camera device has encountered a fatal error.";
                }
                case 3: {
                    return "Camera device could not be opened due to a device policy.";
                }
                case 1: {
                    return "Camera device is in use already.";
                }
                case 5: {
                    return "Camera service has encountered a fatal error.";
                }
                case 2: {
                    return "Camera device could not be opened because there are too many other open camera devices.";
                }
            }
            return "Unknown camera error: " + errorCode;
        }

        public void onDisconnected(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            boolean startFailure = Camera2Session.this.captureSession == null && Camera2Session.this.state != SessionState.STOPPED;
            Camera2Session.this.state = SessionState.STOPPED;
            Camera2Session.this.stopInternal();
            if (startFailure) {
                Camera2Session.this.callback.onFailure(CameraSession.FailureType.DISCONNECTED, "Camera disconnected / evicted.");
            } else {
                Camera2Session.this.events.onCameraDisconnected(Camera2Session.this);
            }
        }

        public void onError(CameraDevice camera, int errorCode) {
            Camera2Session.this.checkIsOnCameraThread();
            Camera2Session.this.reportError(this.getErrorDescription(errorCode));
        }

        public void onOpened(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera opened.");
            Camera2Session.this.cameraDevice = camera;
            Camera2Session.this.surfaceTextureHelper.setTextureSize(((Camera2Session)Camera2Session.this).captureFormat.width, ((Camera2Session)Camera2Session.this).captureFormat.height);
            Camera2Session.this.surface = new Surface(Camera2Session.this.surfaceTextureHelper.getSurfaceTexture());
            try {
                camera.createCaptureSession(Arrays.asList(Camera2Session.this.surface), (CameraCaptureSession.StateCallback)new CaptureSessionCallback(), Camera2Session.this.cameraThreadHandler);
            }
            catch (CameraAccessException e) {
                Camera2Session.this.reportError("Failed to create capture session. " + (Object)((Object)e));
                return;
            }
        }

        public void onClosed(CameraDevice camera) {
            Camera2Session.this.checkIsOnCameraThread();
            Logging.d(Camera2Session.TAG, "Camera device closed.");
            Camera2Session.this.events.onCameraClosed(Camera2Session.this);
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

