/*
 * Decompiled with CFR 0.152.
 */
package org.anyrtc;

import androidx.annotation.Nullable;
import java.util.List;
import java.util.Map;
import org.anyrtc.MediaStreamTrack;

public class RtpParameters {
    public final String transactionId;
    private final Rtcp rtcp;
    private final List<HeaderExtension> headerExtensions;
    public final List<Encoding> encodings;
    public final List<Codec> codecs;

    RtpParameters(String transactionId, Rtcp rtcp, List<HeaderExtension> headerExtensions, List<Encoding> encodings, List<Codec> codecs) {
        this.transactionId = transactionId;
        this.rtcp = rtcp;
        this.headerExtensions = headerExtensions;
        this.encodings = encodings;
        this.codecs = codecs;
    }

    String getTransactionId() {
        return this.transactionId;
    }

    public Rtcp getRtcp() {
        return this.rtcp;
    }

    public List<HeaderExtension> getHeaderExtensions() {
        return this.headerExtensions;
    }

    List<Encoding> getEncodings() {
        return this.encodings;
    }

    List<Codec> getCodecs() {
        return this.codecs;
    }

    public static class HeaderExtension {
        private final String uri;
        private final int id;
        private final boolean encrypted;

        HeaderExtension(String uri, int id, boolean encrypted) {
            this.uri = uri;
            this.id = id;
            this.encrypted = encrypted;
        }

        public String getUri() {
            return this.uri;
        }

        public int getId() {
            return this.id;
        }

        public boolean getEncrypted() {
            return this.encrypted;
        }
    }

    public static class Rtcp {
        private final String cname;
        private final boolean reducedSize;

        Rtcp(String cname, boolean reducedSize) {
            this.cname = cname;
            this.reducedSize = reducedSize;
        }

        public String getCname() {
            return this.cname;
        }

        public boolean getReducedSize() {
            return this.reducedSize;
        }
    }

    public static class Codec {
        public int payloadType;
        public String name;
        MediaStreamTrack.MediaType kind;
        public Integer clockRate;
        public Integer numChannels;
        public Map<String, String> parameters;

        Codec(int payloadType, String name, MediaStreamTrack.MediaType kind, Integer clockRate, Integer numChannels, Map<String, String> parameters) {
            this.payloadType = payloadType;
            this.name = name;
            this.kind = kind;
            this.clockRate = clockRate;
            this.numChannels = numChannels;
            this.parameters = parameters;
        }

        int getPayloadType() {
            return this.payloadType;
        }

        String getName() {
            return this.name;
        }

        MediaStreamTrack.MediaType getKind() {
            return this.kind;
        }

        Integer getClockRate() {
            return this.clockRate;
        }

        Integer getNumChannels() {
            return this.numChannels;
        }

        Map getParameters() {
            return this.parameters;
        }
    }

    public static class Encoding {
        @Nullable
        public String rid;
        public boolean active = true;
        @Nullable
        public Integer maxBitrateBps;
        @Nullable
        public Integer minBitrateBps;
        @Nullable
        public Integer maxFramerate;
        @Nullable
        public Integer numTemporalLayers;
        @Nullable
        public Double scaleResolutionDownBy;
        public Long ssrc;

        Encoding(String rid, boolean active, Double scaleResolutionDownBy) {
            this.rid = rid;
            this.active = active;
            this.scaleResolutionDownBy = scaleResolutionDownBy;
        }

        Encoding(String rid, boolean active, Integer maxBitrateBps, Integer minBitrateBps, Integer maxFramerate, Integer numTemporalLayers, Double scaleResolutionDownBy, Long ssrc) {
            this.rid = rid;
            this.active = active;
            this.maxBitrateBps = maxBitrateBps;
            this.minBitrateBps = minBitrateBps;
            this.maxFramerate = maxFramerate;
            this.numTemporalLayers = numTemporalLayers;
            this.scaleResolutionDownBy = scaleResolutionDownBy;
            this.ssrc = ssrc;
        }

        @Nullable
        String getRid() {
            return this.rid;
        }

        boolean getActive() {
            return this.active;
        }

        @Nullable
        Integer getMaxBitrateBps() {
            return this.maxBitrateBps;
        }

        @Nullable
        Integer getMinBitrateBps() {
            return this.minBitrateBps;
        }

        @Nullable
        Integer getMaxFramerate() {
            return this.maxFramerate;
        }

        @Nullable
        Integer getNumTemporalLayers() {
            return this.numTemporalLayers;
        }

        @Nullable
        Double getScaleResolutionDownBy() {
            return this.scaleResolutionDownBy;
        }

        Long getSsrc() {
            return this.ssrc;
        }
    }
}

