/*
 * Decompiled with CFR 0.152.
 */
package org.anyrtc;

import android.graphics.Matrix;
import java.nio.ByteBuffer;
import org.anyrtc.RefCounted;

public class VideoFrame
implements RefCounted {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;

    public VideoFrame(Buffer buffer, int rotation, long timestampNs) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getRotation() {
        return this.rotation;
    }

    public long getTimestampNs() {
        return this.timestampNs;
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    public void release() {
        this.buffer.release();
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        public int getTextureId();

        public Matrix getTransformMatrix();

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            private Type(int glTarget) {
                this.glTarget = glTarget;
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface I420Buffer
    extends Buffer {
        public ByteBuffer getDataY();

        public ByteBuffer getDataU();

        public ByteBuffer getDataV();

        public int getStrideY();

        public int getStrideU();

        public int getStrideV();
    }

    public static interface Buffer
    extends RefCounted {
        public int getWidth();

        public int getHeight();

        public I420Buffer toI420();

        @Override
        public void retain();

        @Override
        public void release();

        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

