/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Environment;
import android.os.Looper;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.MainThread;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.ar.rtc.IAudioEffectManager;
import org.ar.rtc.IAudioFrameObserver;
import org.ar.rtc.IRtcEngineEventHandler;
import org.ar.rtc.MediaAddress;
import org.ar.rtc.RtcChannel;
import org.ar.rtc.RtcEngine;
import org.ar.rtc.VideoEncoderConfiguration;
import org.ar.rtc.internal.ARDeviceUtil;
import org.ar.rtc.internal.EncryptionConfig;
import org.ar.rtc.internal.LastmileProbeConfig;
import org.ar.rtc.internal.RtcChannelImpl;
import org.ar.rtc.live.LiveInjectStreamConfig;
import org.ar.rtc.live.LiveTranscoding;
import org.ar.rtc.mediaio.IVideoSink;
import org.ar.rtc.mediaio.IVideoSource;
import org.ar.rtc.net.ARNetUtil;
import org.ar.rtc.video.ARVideoFrame;
import org.ar.rtc.video.CameraCapturerConfiguration;
import org.ar.rtc.video.ChannelMediaInfo;
import org.ar.rtc.video.ChannelMediaRelayConfiguration;
import org.ar.rtc.video.VideoCanvas;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.ARAudioManager;
import org.webrtc.ARMainHandler;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.RendererCommon;
import org.webrtc.VideoCapturerAndroid;
import org.webrtc.VideoRenderer;
import org.webrtc.voiceengine.WebRtcAudioEffects;

public class RtcEngineImpl
extends RtcEngine
implements IAudioEffectManager,
ARDeviceUtil.LifecycleEvent {
    private long fNativeAppId;
    private static boolean sLibLoaded = false;
    private final ConcurrentHashMap<IRtcEngineEventHandler, Integer> mRtcHandlers = new ConcurrentHashMap();
    private WeakReference<Context> mContext;
    private String appId = "";
    private int channelProfile = 0;
    private int role = 2;
    private List<MediaAddress> addressList = new ArrayList<MediaAddress>();
    private final EglBase mEglBase;
    private VideoCapturerAndroid mVideoCapturer = null;
    private static RtcEngineImpl mInstance = null;
    private int mCameraId = 1;
    private RtcChannelImpl mDefaultRtcChannel = null;
    private final LinkedList<RtcChannelImpl> mRtcChannels = new LinkedList();
    private ARAudioManager arAudioManager;
    private IRtcEngineEventHandler handler;
    private ARNetUtil.NetworkType mCurNetWorkType = ARNetUtil.NetworkType.NETWORK_NO;
    private boolean isNoNet = false;
    private boolean isCameraOpen = false;
    ARDeviceUtil arDeviceUtil;
    private int mVideoSourceType = 1;
    private int mExAudioSampleRate = 0;
    private int mExAudioChannels = 0;
    private int mExAudioSinkChannels = -1;
    private int mExAudioSinkSampleRate = -1;
    private boolean enableFaceDetection;
    private static boolean b_audio_is_music_ = false;
    private CameraCapturerConfiguration cameraCapturerConfiguration = new CameraCapturerConfiguration(CameraCapturerConfiguration.CD_640x480, CameraCapturerConfiguration.CAMERA_DIRECTION.CAMERA_FRONT);
    private ConnectionChangeBroadcastReceiver netChangeBroadcastReceiver = new ConnectionChangeBroadcastReceiver();
    private IRtcEngineEventHandler engineEventHandler = new IRtcEngineEventHandler(){

        @Override
        public void onJoinChannelSuccess(String channel, String uid, int elapsed) {
            super.onJoinChannelSuccess(channel, uid, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onJoinChannelSuccess(channel, uid, elapsed);
            }
        }

        @Override
        public void onLocalVideoStateChanged(int localVideoState, int error) {
            super.onLocalVideoStateChanged(localVideoState, error);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLocalVideoStateChanged(localVideoState, error);
            }
        }

        @Override
        public void onRejoinChannelSuccess(String channel, String uid, int elapsed) {
            super.onRejoinChannelSuccess(channel, uid, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRejoinChannelSuccess(channel, uid, elapsed);
            }
        }

        @Override
        public void onConnectionLost() {
            super.onConnectionLost();
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onConnectionLost();
            }
        }

        @Override
        public void onError(int err) {
            super.onError(err);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onError(err);
            }
        }

        @Override
        public void onFirstLocalVideoFrame(int width, int height, int elapsed) {
            super.onFirstLocalVideoFrame(width, height, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstLocalVideoFrame(width, height, elapsed);
            }
        }

        @Override
        public void onFirstLocalAudioFrame(int elapsed) {
            super.onFirstLocalAudioFrame(elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstLocalAudioFrame(elapsed);
            }
        }

        @Override
        public void onFirstLocalAudioFramePublished(int elapsed) {
            super.onFirstLocalAudioFramePublished(elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstLocalAudioFramePublished(elapsed);
            }
        }

        @Override
        public void onFirstLocalVideoFramePublished(int elapsed) {
            super.onFirstLocalVideoFramePublished(elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstLocalVideoFramePublished(elapsed);
            }
        }

        @Override
        public void onTokenPrivilegeWillExpire(String token) {
            super.onTokenPrivilegeWillExpire(token);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onTokenPrivilegeWillExpire(token);
            }
        }

        @Override
        public void onActiveSpeaker(String uid) {
            super.onActiveSpeaker(uid);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onActiveSpeaker(uid);
            }
        }

        @Override
        public void onRequestToken() {
            super.onRequestToken();
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRequestToken();
            }
        }

        @Override
        public void onWarning(int warn) {
            super.onWarning(warn);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onWarning(warn);
            }
        }

        @Override
        public void onLeaveChannel(IRtcEngineEventHandler.RtcStats stats) {
            super.onLeaveChannel(stats);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLeaveChannel(stats);
            }
        }

        @Override
        public void onRtcStats(IRtcEngineEventHandler.RtcStats stats) {
            super.onRtcStats(stats);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRtcStats(stats);
            }
        }

        @Override
        public void onLocalAudioStats(IRtcEngineEventHandler.LocalAudioStats stats) {
            super.onLocalAudioStats(stats);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLocalAudioStats(stats);
            }
        }

        @Override
        public void onLocalVideoStats(IRtcEngineEventHandler.LocalVideoStats stats) {
            super.onLocalVideoStats(stats);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLocalVideoStats(stats);
            }
        }

        @Override
        public void onUserJoined(String uid, int elapsed) {
            super.onUserJoined(uid, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onUserJoined(uid, elapsed);
            }
        }

        @Override
        public void onUserOffline(String uid, int reason) {
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onUserOffline(uid, reason);
            }
            if (RtcEngineImpl.this.m_remote_render_list.containsKey(uid)) {
                if (((VideoCanvas)RtcEngineImpl.this.m_remote_render_list.get(uid)).getView() != null) {
                    ((VideoCanvas)RtcEngineImpl.this.m_remote_render_list.get(uid)).getView().release();
                }
                RtcEngineImpl.this.m_remote_render_list.remove(uid);
            }
        }

        @Override
        public void onFirstRemoteVideoDecoded(String uid, int width, int height, int elapsed) {
            super.onFirstRemoteVideoDecoded(uid, width, height, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstRemoteVideoDecoded(uid, width, height, elapsed);
            }
        }

        @Override
        public void onFirstRemoteVideoFrame(String uid, int width, int height, int elapsed) {
            super.onFirstRemoteVideoFrame(uid, width, height, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstRemoteVideoFrame(uid, width, height, elapsed);
            }
        }

        @Override
        public void onNetworkQuality(String uid, int txQuality, int rxQuality) {
            super.onNetworkQuality(uid, txQuality, rxQuality);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onNetworkQuality(uid, txQuality, rxQuality);
            }
        }

        @Override
        public void onConnectionStateChanged(int state, int reason) {
            super.onConnectionStateChanged(state, reason);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onConnectionStateChanged(state, reason);
            }
        }

        @Override
        public void onRemoteVideoStateChanged(String uid, int state, int reason, int elapsed) {
            super.onRemoteVideoStateChanged(uid, state, reason, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRemoteVideoStateChanged(uid, state, reason, elapsed);
            }
        }

        @Override
        public void onAudioPublishStateChanged(String channel, int oldState, int newState, int elapseSinceLastState) {
            super.onAudioPublishStateChanged(channel, oldState, newState, elapseSinceLastState);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onAudioPublishStateChanged(channel, oldState, newState, elapseSinceLastState);
            }
        }

        @Override
        public void onVideoPublishStateChanged(String channel, int oldState, int newState, int elapseSinceLastState) {
            super.onVideoPublishStateChanged(channel, oldState, newState, elapseSinceLastState);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onVideoPublishStateChanged(channel, oldState, newState, elapseSinceLastState);
            }
        }

        @Override
        public void onAudioSubscribeStateChanged(String channel, String uid, int oldState, int newState, int elapseSinceLastState) {
            super.onAudioSubscribeStateChanged(channel, uid, oldState, newState, elapseSinceLastState);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onAudioSubscribeStateChanged(channel, uid, oldState, newState, elapseSinceLastState);
            }
        }

        @Override
        public void onVideoSubscribeStateChanged(String channel, String uid, int oldState, int newState, int elapseSinceLastState) {
            super.onVideoSubscribeStateChanged(channel, uid, oldState, newState, elapseSinceLastState);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onVideoSubscribeStateChanged(channel, uid, oldState, newState, elapseSinceLastState);
            }
        }

        @Override
        public void onRemoteAudioStats(IRtcEngineEventHandler.RemoteAudioStats stats) {
            super.onRemoteAudioStats(stats);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRemoteAudioStats(stats);
            }
        }

        @Override
        public void onFirstRemoteAudioDecoded(String uid, int elapsed) {
            super.onFirstRemoteAudioDecoded(uid, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstRemoteAudioDecoded(uid, elapsed);
            }
        }

        @Override
        public void onRemoteVideoStats(IRtcEngineEventHandler.RemoteVideoStats stats) {
            super.onRemoteVideoStats(stats);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRemoteVideoStats(stats);
            }
        }

        @Override
        public void onVideoSizeChanged(String uid, int width, int height, int rotation) {
            super.onVideoSizeChanged(uid, width, height, rotation);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onVideoSizeChanged(uid, width, height, rotation);
            }
        }

        @Override
        public void onFirstRemoteAudioFrame(String uid, int elapsed) {
            super.onFirstRemoteAudioFrame(uid, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFirstRemoteAudioFrame(uid, elapsed);
            }
        }

        @Override
        public void onRemoteAudioStateChanged(String uid, int state, int reason, int elapsed) {
            super.onRemoteAudioStateChanged(uid, state, reason, elapsed);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRemoteAudioStateChanged(uid, state, reason, elapsed);
            }
        }

        @Override
        public void onClientRoleChanged(int oldRole, int newRole) {
            super.onClientRoleChanged(oldRole, newRole);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onClientRoleChanged(oldRole, newRole);
            }
        }

        @Override
        public void onLocalAudioStateChanged(int state, int error) {
            super.onLocalAudioStateChanged(state, error);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLocalAudioStateChanged(state, error);
            }
        }

        @Override
        public void onAudioRouteChanged(int routing) {
            super.onAudioRouteChanged(routing);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onAudioRouteChanged(routing);
            }
        }

        @Override
        public void onAudioVolumeIndication(IRtcEngineEventHandler.AudioVolumeInfo[] speakers, int totalVolume) {
            super.onAudioVolumeIndication(speakers, totalVolume);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onAudioVolumeIndication(speakers, totalVolume);
            }
        }

        @Override
        public void onAudioEffectFinished(int soundId) {
            super.onAudioEffectFinished(soundId);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onAudioEffectFinished(soundId);
            }
        }

        @Override
        public void onAudioMixingFinished() {
            super.onAudioMixingFinished();
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onAudioMixingFinished();
            }
        }

        @Override
        public void onLastmileQuality(int quality) {
            super.onLastmileQuality(quality);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLastmileQuality(quality);
            }
        }

        @Override
        public void onLastmileProbeResult(IRtcEngineEventHandler.LastmileProbeResult result) {
            super.onLastmileProbeResult(result);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLastmileProbeResult(result);
            }
        }

        @Override
        public void onAudioMixingStateChanged(int state, int errorCode) {
            super.onAudioMixingStateChanged(state, errorCode);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onAudioMixingStateChanged(state, errorCode);
            }
        }

        @Override
        public void onFacePositionChanged(int imageWidth, int imageHeight, IRtcEngineEventHandler.ARFacePositionInfo[] faces) {
            super.onFacePositionChanged(imageWidth, imageHeight, faces);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onFacePositionChanged(imageWidth, imageHeight, faces);
            }
        }

        @Override
        public void onStreamInjectedStatus(String url, String uid, int status) {
            super.onStreamInjectedStatus(url, uid, status);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onStreamInjectedStatus(url, uid, status);
            }
        }

        @Override
        public void onChannelMediaRelayEvent(int code) {
            super.onChannelMediaRelayEvent(code);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onChannelMediaRelayEvent(code);
            }
        }

        @Override
        public void onChannelMediaRelayStateChanged(int state, int code) {
            super.onChannelMediaRelayStateChanged(state, code);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onChannelMediaRelayStateChanged(state, code);
            }
        }

        @Override
        public void onLocalPublishFallbackToAudioOnly(boolean isFallbackOrRecover) {
            super.onLocalPublishFallbackToAudioOnly(isFallbackOrRecover);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onLocalPublishFallbackToAudioOnly(isFallbackOrRecover);
            }
        }

        @Override
        public void onRemoteSubscribeFallbackToAudioOnly(String uid, boolean isFallbackOrRecover) {
            super.onRemoteSubscribeFallbackToAudioOnly(uid, isFallbackOrRecover);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRemoteSubscribeFallbackToAudioOnly(uid, isFallbackOrRecover);
            }
        }

        @Override
        public void onRtmpStreamingStateChanged(String url, int state, int errCode) {
            super.onRtmpStreamingStateChanged(url, state, errCode);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onRtmpStreamingStateChanged(url, state, errCode);
            }
        }

        @Override
        public void onStreamPublished(String url, int error) {
            super.onStreamPublished(url, error);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onStreamPublished(url, error);
            }
        }

        @Override
        public void onStreamUnpublished(String url) {
            super.onStreamUnpublished(url);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onStreamUnpublished(url);
            }
        }

        @Override
        public void onTranscodingUpdated() {
            super.onTranscodingUpdated();
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onTranscodingUpdated();
            }
        }

        @Override
        public void onStreamMessage(String uid, int streamId, byte[] data) {
            super.onStreamMessage(uid, streamId, data);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onStreamMessage(uid, streamId, data);
            }
        }

        @Override
        public void onStreamMessageError(String uid, int streamId, int error, int missed, int cached) {
            super.onStreamMessageError(uid, streamId, error, missed, cached);
            if (RtcEngineImpl.this.handler != null) {
                RtcEngineImpl.this.handler.onStreamMessageError(uid, streamId, error, missed, cached);
            }
        }
    };

    public EglBase getEglBase() {
        return this.mEglBase;
    }

    public Context getContext() {
        return (Context)this.mContext.get();
    }

    public RtcEngineImpl(Context context, String appId, IRtcEngineEventHandler handler) {
        this.mContext = new WeakReference<Context>(context);
        this.appId = appId;
        this.handler = handler;
        this.mEglBase = EglBase.create();
        this.initCameraManager();
        this.arDeviceUtil = new ARDeviceUtil((Context)this.mContext.get(), this);
        this.fNativeAppId = this.nativeCreate(this.mContext.get(), this.mEglBase.getEglBaseContext(), appId, ((Context)this.mContext.get()).getPackageName(), this.engineEventHandler, this.mVideoCapturer);
        this.arAudioManager = ARAudioManager.create(context.getApplicationContext());
        this.arAudioManager.start(new ARAudioManager.AudioManagerEvents(){

            @Override
            public void onAudioDeviceChanged(ARAudioManager.AudioDevice selectedAudioDevice, Set<ARAudioManager.AudioDevice> availableAudioDevices) {
                RtcEngineImpl.this.curAudioDevice = selectedAudioDevice;
                switch (selectedAudioDevice) {
                    case SPEAKER_PHONE: {
                        RtcEngineImpl.this.engineEventHandler.onAudioRouteChanged(3);
                        RtcEngineImpl.this.nativeSetHead(false);
                        break;
                    }
                    case WIRED_HEADSET: {
                        RtcEngineImpl.this.engineEventHandler.onAudioRouteChanged(0);
                        RtcEngineImpl.this.setInEarMonitoring(RtcEngineImpl.this.isOpenEarMonitoring);
                        RtcEngineImpl.this.nativeSetHead(true);
                        break;
                    }
                    case BLUETOOTH: {
                        RtcEngineImpl.this.engineEventHandler.onAudioRouteChanged(5);
                        RtcEngineImpl.this.nativeSetHead(false);
                        break;
                    }
                    case EARPIECE: {
                        RtcEngineImpl.this.engineEventHandler.onAudioRouteChanged(1);
                        RtcEngineImpl.this.nativeSetHead(false);
                    }
                }
            }
        });
        this.setLogFile(this.initializeLogFile(context));
    }

    public String initializeLogFile(Context context) {
        File folder;
        if (Build.VERSION.SDK_INT >= 29) {
            folder = new File(context.getExternalFilesDir(""), "");
        } else {
            String path = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + context.getPackageName() + File.separator;
            folder = new File(path);
            if (!folder.exists() && !folder.mkdir()) {
                folder = null;
            }
        }
        if (folder != null && !folder.exists() && !folder.mkdir()) {
            return "";
        }
        return new File(folder.getAbsolutePath()).getAbsolutePath();
    }

    public void reinitialize(Context context, String appId, IRtcEngineEventHandler handler) {
        this.addHandler(handler);
    }

    public void addHandler(IRtcEngineEventHandler handler) {
        this.mRtcHandlers.put(handler, 0);
    }

    public static void loadNativeLibrary() {
        System.loadLibrary("arrtc");
        System.loadLibrary("videv");
    }

    public static synchronized boolean initializeNativeLibs() {
        if (!sLibLoaded) {
            RtcEngineImpl.loadNativeLibrary();
            sLibLoaded = true;
        }
        return sLibLoaded;
    }

    public void removeHandler(IRtcEngineEventHandler handler) {
        if (this.mRtcHandlers.containsKey(handler)) {
            this.mRtcHandlers.remove(handler);
        }
    }

    @Override
    public double getEffectsVolume() {
        return this.nativeGetEffectsVolume();
    }

    @Override
    public int setEffectsVolume(double volume) {
        return this.nativeSetEffectsVolume(volume);
    }

    @Override
    public int setVolumeOfEffect(int soundId, double volume) {
        return this.nativeSetVolumeOfEffect(soundId, volume);
    }

    @Override
    public int playEffect(int soundId, String filePath, int loopCount, double pitch, double pan, double gain, boolean publish) {
        return this.nativePlayEffect(soundId, filePath, loopCount, pitch, pan, gain, publish);
    }

    @Override
    public int stopEffect(int soundId) {
        return this.nativeStopEffect(soundId);
    }

    @Override
    public int stopAllEffects() {
        return this.nativeStopAllEffects();
    }

    @Override
    public int preloadEffect(int soundId, String filePath) {
        return this.nativePreloadEffect(soundId, filePath);
    }

    @Override
    public int unloadEffect(int soundId) {
        return this.nativeUnloadEffect(soundId);
    }

    @Override
    public int pauseEffect(int soundId) {
        return this.nativePauseEffect(soundId);
    }

    @Override
    public int pauseAllEffects() {
        return this.nativePauseAllEffects();
    }

    @Override
    public int resumeEffect(int soundId) {
        return this.nativeResumeEffect(soundId);
    }

    @Override
    public int resumeAllEffects() {
        return this.nativeResumeAllEffects();
    }

    @Override
    public void onBackGround(boolean back) {
    }

    private void getNetWorkStatus() {
        ConnectivityManager connectivityManager = (ConnectivityManager)((Context)this.mContext.get()).getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo != null) {
            if (networkInfo.getState() == NetworkInfo.State.CONNECTED) {
                this.isNoNet = false;
                ARNetUtil.NetworkType networkType = ARNetUtil.getNetworkType();
                if (this.mCurNetWorkType == null) {
                    this.mCurNetWorkType = networkType;
                    if (this.handler != null) {
                        this.handler.onNetworkTypeChanged(this.mCurNetWorkType.type);
                    }
                    this.notifyNetChanged();
                }
                if (!networkType.name().equals(this.mCurNetWorkType.name())) {
                    this.mCurNetWorkType = networkType;
                    if (this.handler != null) {
                        this.handler.onNetworkTypeChanged(this.mCurNetWorkType.type);
                    }
                    this.notifyNetChanged();
                }
            }
        } else {
            this.mCurNetWorkType = ARNetUtil.NetworkType.NETWORK_NO;
            if (!this.isNoNet) {
                this.isNoNet = true;
                if (this.handler != null) {
                    this.handler.onNetworkTypeChanged(this.mCurNetWorkType.type);
                }
                this.notifyNetChanged();
            }
        }
    }

    private void notifyNetChanged() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("Cmd", (Object)"LocalNetChanged");
            jsonObject.put("netType", this.mCurNetWorkType.type);
            this.nativeSetParameters(jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    @MainThread
    public int release() {
        if (this.arAudioManager != null) {
            this.arAudioManager.stop();
            this.arAudioManager = null;
        }
        if (this.m_local_video_canvas != null && this.m_local_video_canvas.getView() != null) {
            this.m_local_video_canvas.getView().release();
            this.m_local_video_canvas.view = null;
            this.m_local_video_canvas = null;
        }
        if (this.mEglBase != null) {
            this.mEglBase.release();
        }
        this.handler = null;
        for (Map.Entry entry : this.m_remote_render_list.entrySet()) {
            if (((VideoCanvas)entry.getValue()).getView() == null) continue;
            ((VideoCanvas)entry.getValue()).getView().release();
        }
        this.m_remote_render_list.clear();
        this.netChangeBroadcastReceiver.unregister((Context)this.mContext.get());
        return 0;
    }

    public void doDestroy() {
        ARMainHandler.getInstance().post(new Runnable(){

            @Override
            public void run() {
                RtcEngineImpl.this.release();
            }
        });
        this.nativeRelease();
        this.fNativeAppId = 0L;
        this.mVideoCapturer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int joinChannel(String token, String channelName, String optionalInfo, String optionalUid) {
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            return 101;
        }
        if (this.appId.length() > 32) {
            return 101;
        }
        if (TextUtils.isEmpty((CharSequence)channelName)) {
            return 102;
        }
        if (channelName.length() > 64) {
            return 102;
        }
        if (optionalUid.length() > 64) {
            return 103;
        }
        if (null == token) {
            token = "";
        }
        if (null == optionalInfo) {
            optionalInfo = "";
        }
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        this.netChangeBroadcastReceiver.register((Context)this.mContext.get(), intentFilter);
        int ret = this.nativeJoinChannel(token, channelName, optionalInfo, optionalUid);
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel == null) {
                this.mDefaultRtcChannel = new RtcChannelImpl();
            }
            if (ret == 0) {
                // empty if block
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int leaveChannel() {
        for (Map.Entry entry : this.m_remote_render_list.entrySet()) {
            if (((VideoCanvas)entry.getValue()).getView() == null) continue;
            ((VideoCanvas)entry.getValue()).getView().release();
        }
        this.m_remote_render_list.clear();
        this.netChangeBroadcastReceiver.unregister((Context)this.mContext.get());
        this.mCurNetWorkType = ARNetUtil.NetworkType.NETWORK_NO;
        b_audio_is_music_ = false;
        RtcEngineImpl rtcEngineImpl = this;
        synchronized (rtcEngineImpl) {
            if (this.mDefaultRtcChannel != null) {
                this.mDefaultRtcChannel = null;
            }
        }
        return this.nativeLeaveChannle();
    }

    @Override
    public int setChannelProfile(int profile) {
        this.channelProfile = profile;
        return this.nativeSetChannelProfile(profile);
    }

    @Override
    public int setClientRole(int role) {
        this.role = role;
        return this.nativeSetClientRole(role);
    }

    @Override
    public int switchChannel(String token, String channelName) {
        if (TextUtils.isEmpty((CharSequence)channelName)) {
            return 102;
        }
        if (channelName.length() > 64) {
            return 102;
        }
        return this.nativeSwitchChannel(token, channelName);
    }

    @Override
    public int enableDualStreamMode(boolean enabled) {
        return this.nativeEnableDualStreamMode(enabled);
    }

    @Override
    public int setRemoteVideoStreamType(String uid, int streamType) {
        return this.nativeSetRemoteVideoStreamType(uid, streamType);
    }

    @Override
    public int setRemoteDefaultVideoStreamType(int streamType) {
        return this.nativeSetRemoteDefaultVideoStreamType(streamType);
    }

    @Override
    public int createDataStream(boolean reliable, boolean ordered) {
        return this.nativeCreateDataStream(reliable, ordered);
    }

    @Override
    public int sendStreamMessage(int streamId, byte[] message) {
        return this.nativeSendStreamMessage(message, streamId);
    }

    @Override
    public int enableAudio() {
        return this.nativeEnableAudio();
    }

    @Override
    public int disableAudio() {
        return this.nativeDisableAudio();
    }

    @Override
    public int setAudioProfile(int profile, int scenario) {
        switch (profile) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                b_audio_is_music_ = true;
                break;
            }
            default: {
                b_audio_is_music_ = false;
            }
        }
        return this.nativeSetAudioProfile(profile, scenario);
    }

    @Override
    public int adjustRecordingSignalVolume(int volume) {
        if (volume < 0 || volume > 400) {
            return -1;
        }
        return this.nativeAdjustRecordingSignalVolume(volume);
    }

    @Override
    public int adjustUserPlaybackSignalVolume(String uid, int volume) {
        if (volume < 0 || volume > 400) {
            return -1;
        }
        return this.nativeAdjustUserPlaybackSignalVolume(uid, volume);
    }

    @Override
    public int adjustPlaybackSignalVolume(int volume) {
        if (volume < 0 || volume > 400) {
            return -1;
        }
        return this.nativeAdjustPlaybackSignalVolume(volume);
    }

    @Override
    public int enableLocalAudio(boolean enabled) {
        return this.nativeEnableLocalAudio(enabled);
    }

    @Override
    public int muteLocalAudioStream(boolean muted) {
        return this.nativeMuteLocalAudioStream(muted);
    }

    @Override
    public int muteRemoteAudioStream(String uid, boolean muted) {
        return this.nativeMuteRemoteAudioStream(uid, muted);
    }

    @Override
    public int muteAllRemoteAudioStreams(boolean muted) {
        return this.nativeMuteAllRemoteAudioStreams(muted);
    }

    @Override
    public int setDefaultMuteAllRemoteAudioStreams(boolean muted) {
        return this.nativeSetDefaultMuteAllRemoteAudioStreams(muted);
    }

    @Override
    public int enableInEarMonitoring(boolean enabled) {
        this.isOpenEarMonitoring = enabled;
        return this.setInEarMonitoring(enabled);
    }

    private int setInEarMonitoring(boolean enabled) {
        if (enabled) {
            if (this.curAudioDevice == ARAudioManager.AudioDevice.WIRED_HEADSET && !this.isOpeningEarMonitoring) {
                this.isOpeningEarMonitoring = true;
                return this.nativeEnableInEarMonitoring(enabled);
            }
        } else if (this.isOpeningEarMonitoring) {
            this.isOpeningEarMonitoring = false;
            return this.nativeEnableInEarMonitoring(enabled);
        }
        return 0;
    }

    @Override
    public int setInEarMonitoringVolume(int volume) {
        if (volume > 0 && volume <= 100) {
            return this.nativeSetInEarMonitoringVolume(volume);
        }
        return 0;
    }

    @Override
    public int startAudioRecording(String filePath, int sampleRate, int quality) {
        return TextUtils.isEmpty((CharSequence)filePath) ? -2 : this.nativeStartAudioRecording(filePath, sampleRate, quality);
    }

    @Override
    public int stopAudioRecording() {
        return this.nativeStopAudioRecording();
    }

    private void initCameraManager() {
        this.mCameraId = 0;
        String cameraDeviceName = CameraEnumerationAndroid.getDeviceName(this.mCameraId);
        String frontCameraDeviceName = CameraEnumerationAndroid.getNameOfFrontFacingDevice();
        String backCameraDeviceName = CameraEnumerationAndroid.getNameOfBackFacingDevice();
        int numberOfCameras = CameraEnumerationAndroid.getDeviceCount();
        if (numberOfCameras >= 1 && frontCameraDeviceName != null) {
            cameraDeviceName = frontCameraDeviceName;
            this.mCameraId = 1;
        } else if (numberOfCameras >= 1 && this.mCameraId == 0 && backCameraDeviceName != null) {
            cameraDeviceName = backCameraDeviceName;
            this.mCameraId = 0;
        } else {
            this.mCameraId = -1;
            Log.e((String)"AR_Log", (String)"no camera!");
        }
        this.mVideoCapturer = VideoCapturerAndroid.create(cameraDeviceName, new CameraVideoCapturer.CameraEventsHandler(){

            @Override
            public void onCameraError(String errorDescription) {
                Log.e((String)"AR_Log", (String)("onCameraError error:" + errorDescription));
            }

            @Override
            public void onCameraDisconnected() {
                Log.d((String)"AR_Log", (String)"onCameraDisconnected");
            }

            @Override
            public void onCameraFreezed(String errorDescription) {
                Log.d((String)"AR_Log", (String)("onCameraFreezed error:" + errorDescription));
            }

            @Override
            public void onCameraOpening(String cameraName) {
                RtcEngineImpl.this.isCameraOpen = true;
                Log.d((String)"AR_Log", (String)("onCameraOpening name:" + cameraName));
            }

            @Override
            public void onFirstFrameAvailable() {
                RtcEngineImpl.this.isCameraOpen = true;
                Log.d((String)"AR_Log", (String)"onFirstFrameAvailable");
            }

            @Override
            public void onCameraClosed() {
                RtcEngineImpl.this.isCameraOpen = false;
                Log.d((String)"AR_Log", (String)"onCameraClosed");
            }
        });
        if (this.mVideoCapturer != null) {
            this.mVideoCapturer.setRtcEngineEventHandler(this.handler);
            this.mVideoCapturer.enableFaceDetection(this.enableFaceDetection);
        }
    }

    @Override
    public int enableVideo() {
        return this.nativeEnableVideo();
    }

    @Override
    public int disableVideo() {
        ConcurrentHashMap map = this.m_remote_render_list;
        for (String key : map.keySet()) {
            if (map.get(key) == null) continue;
            ((VideoCanvas)map.get(key)).getView().release();
        }
        this.m_remote_render_list.clear();
        return this.nativeDisableVideo();
    }

    @Override
    public int setVideoEncoderConfiguration(VideoEncoderConfiguration config) {
        return this.nativeSetVideoEncoderConfiguration(config.dimensions.width, config.dimensions.height, config.frameRate, config.minFrameRate, config.bitrate, config.minBitrate, config.orientationMode.getValue(), config.degradationPrefer.getValue(), config.mirrorMode);
    }

    @Override
    public int setCameraCapturerConfiguration(CameraCapturerConfiguration config) {
        if (config != null) {
            this.cameraCapturerConfiguration = config;
            if (this.mVideoCapturer != null) {
                String frontCameraDeviceName = CameraEnumerationAndroid.getNameOfFrontFacingDevice();
                String backCameraDeviceName = CameraEnumerationAndroid.getNameOfBackFacingDevice();
                int numberOfCameras = CameraEnumerationAndroid.getDeviceCount();
                if (this.cameraCapturerConfiguration.cameraDirection.getValue() == 0) {
                    if (numberOfCameras >= 1 && backCameraDeviceName != null) {
                        this.mCameraId = 0;
                    }
                } else if (numberOfCameras >= 1 && frontCameraDeviceName != null) {
                    this.mCameraId = 1;
                }
                this.mVideoCapturer.setCameraCapturerConfiguration(this.cameraCapturerConfiguration);
            }
            return 0;
        }
        return -1;
    }

    @Override
    public void setAudioMode(boolean isDef) {
        if (this.arAudioManager != null) {
            this.arAudioManager.setMode(isDef);
        }
    }

    @Override
    public int setupRemoteVideo(VideoCanvas remoteCanvas) {
        if (TextUtils.isEmpty((CharSequence)remoteCanvas.uid)) {
            return -1;
        }
        if (remoteCanvas != null) {
            if (remoteCanvas.view != null) {
                if (this.m_remote_render_list.containsKey(remoteCanvas.uid)) {
                    if (((VideoCanvas)this.m_remote_render_list.get(remoteCanvas.uid)).getView() != null) {
                        ((VideoCanvas)this.m_remote_render_list.get(remoteCanvas.uid)).getView().release();
                    }
                    this.m_remote_render_list.remove(remoteCanvas.uid);
                }
                remoteCanvas.getView().setScalingType(remoteCanvas.renderMode == 1 ? RendererCommon.ScalingType.SCALE_ASPECT_FILL : RendererCommon.ScalingType.SCALE_ASPECT_FIT);
                remoteCanvas.getView().setMirror(remoteCanvas.mirrorMode == 1);
                if (!this.m_remote_render_list.containsKey(remoteCanvas.uid) && !TextUtils.isEmpty((CharSequence)remoteCanvas.uid)) {
                    this.m_remote_render_list.put(remoteCanvas.uid, remoteCanvas);
                    VideoRenderer videoRenderer = new VideoRenderer((VideoRenderer.Callbacks)remoteCanvas.view);
                    return this.nativeSetupVideoRemote(videoRenderer.GetRenderPointer(), remoteCanvas.mirrorMode, remoteCanvas.uid);
                }
            }
        } else {
            return -1;
        }
        return 0;
    }

    @Override
    public int setRemoteRenderMode(String uid, int renderMode, int mirrorMode) {
        if (TextUtils.isEmpty((CharSequence)uid)) {
            return -1;
        }
        if (this.m_remote_render_list.containsKey(uid)) {
            VideoCanvas videoCanvas = (VideoCanvas)this.m_remote_render_list.get(uid);
            videoCanvas.getView().setScalingType(renderMode == 1 ? RendererCommon.ScalingType.SCALE_ASPECT_FILL : RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            videoCanvas.renderMode = renderMode;
            if (videoCanvas.mirrorMode != mirrorMode) {
                videoCanvas.getView().setMirror(mirrorMode == 1);
                videoCanvas.mirrorMode = mirrorMode;
            }
        }
        return 0;
    }

    @Override
    public int setupLocalVideo(VideoCanvas local) {
        if (this.mVideoSourceType == 3) {
            return -1;
        }
        if (local != null) {
            if (local.view != null) {
                local.getView().setMirror(local.mirrorMode == 0 ? this.isFrontCamera() : local.mirrorMode == 1);
                this.m_localRenderMirrorMode = local.mirrorMode;
                local.getView().setScalingType(local.renderMode == 1 ? RendererCommon.ScalingType.SCALE_ASPECT_FILL : RendererCommon.ScalingType.SCALE_ASPECT_FIT);
                VideoRenderer videoRenderer = new VideoRenderer(local.getView());
                this.m_local_video_canvas = local;
                if (this.mVideoCapturer != null) {
                    this.mVideoCapturer.setLocalSurface(local.view);
                }
                return this.nativeSetupJavaVideoLocal(videoRenderer.GetRenderPointer(), local.renderMode, local.mirrorMode, local.uid);
            }
            return -1;
        }
        return -1;
    }

    @Override
    public int setLocalRenderMode(int renderMode, int mirrorMode) {
        if (this.m_local_video_canvas != null && this.m_local_video_canvas.getView() != null) {
            this.m_localRenderMode = renderMode;
            this.m_local_video_canvas.getView().setScalingType(renderMode == 1 ? RendererCommon.ScalingType.SCALE_ASPECT_FILL : RendererCommon.ScalingType.SCALE_ASPECT_FIT);
            if (this.m_localRenderMirrorMode != mirrorMode) {
                this.m_localRenderMirrorMode = mirrorMode;
                this.m_local_video_canvas.getView().setMirror(mirrorMode == 0 ? this.isFrontCamera() : this.isFrontCamera() && mirrorMode == 1);
            }
        }
        return 0;
    }

    @Override
    public int startPreview() {
        return this.mVideoSourceType == 3 ? -4 : this.nativeStartPreview();
    }

    @Override
    public int stopPreview() {
        return this.nativeStopPreview();
    }

    @Override
    public int enableLocalVideo(boolean enabled) {
        return this.nativeEnableLocalVideo(enabled);
    }

    @Override
    public int muteLocalVideoStream(boolean muted) {
        return this.nativeMuteLocalVideoStream(muted);
    }

    @Override
    public int muteRemoteVideoStream(String uid, boolean muted) {
        return this.nativeMuteRemoteVideoStream(uid, muted);
    }

    @Override
    public int muteAllRemoteVideoStreams(boolean muted) {
        return this.nativeMuteAllRemoteVideoStreams(muted);
    }

    @Override
    public int setDefaultMuteAllRemoteVideoStreams(boolean muted) {
        return this.nativeSetDefaultMuteAllRemoteVideoStreams(muted);
    }

    @Override
    public int switchCamera() {
        if (this.mVideoSourceType != 1) {
            return -1;
        }
        if (this.isCameraOpen && this.mVideoCapturer != null && CameraEnumerationAndroid.getDeviceCount() > 1) {
            final CountDownLatch controller = new CountDownLatch(1);
            this.mCameraId = (this.mCameraId + 1) % CameraEnumerationAndroid.getDeviceCount();
            this.mVideoCapturer.switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                @Override
                public void onCameraSwitchDone(boolean isFrontCamera) {
                    if (RtcEngineImpl.this.m_local_video_canvas != null && RtcEngineImpl.this.m_local_video_canvas.getView() != null) {
                        RtcEngineImpl.this.m_local_video_canvas.getView().setMirror(RtcEngineImpl.this.m_localRenderMirrorMode == 0 ? isFrontCamera : isFrontCamera && RtcEngineImpl.this.m_localRenderMirrorMode == 1);
                    }
                    controller.countDown();
                }

                @Override
                public void onCameraSwitchError(String errorDescription) {
                    controller.countDown();
                }
            });
            try {
                controller.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return 0;
    }

    @Override
    public boolean isCameraZoomSupported() {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.isZoomSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraTorchSupported() {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.isTorchSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraFocusSupported() {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.isFocusSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.isExposureSupported();
        }
        return false;
    }

    @Override
    public boolean isCameraAutoFocusFaceModeSupported() {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.isAutoFaceFocusSupported();
        }
        return false;
    }

    @Override
    public int setCameraZoomFactor(float factor) {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.setZoom(factor);
        }
        return 0;
    }

    @Override
    public float getCameraMaxZoomFactor() {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.getMaxZoom();
        }
        return 0.0f;
    }

    @Override
    public int setCameraFocusPositionInPreview(float positionX, float positionY) {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.setFocus(positionX, positionY);
        }
        return 0;
    }

    @Override
    public int setCameraExposurePosition(float positionXinView, float positionYinView) {
        if (this.mVideoCapturer != null) {
            return this.mVideoCapturer.setExposure(positionXinView, positionYinView);
        }
        return 0;
    }

    @Override
    public int setCameraTorchOn(boolean isOn) {
        try {
            if (this.mVideoCapturer != null) {
                this.mVideoCapturer.setTorchMode(isOn);
            }
        }
        catch (Exception e) {
            Log.e((String)"AR_Log", (String)"not support Torch");
        }
        return 0;
    }

    @Override
    public int setCameraAutoFocusFaceModeEnabled(boolean enabled) {
        if (this.mVideoCapturer != null) {
            this.mVideoCapturer.setCameraAutoFocusFaceModeEnabled(enabled);
        }
        return 0;
    }

    private boolean isFrontCamera() {
        return this.mCameraId == 1;
    }

    @Override
    public int renewToken(String token) {
        return this.nativeReNewToken(token);
    }

    @Override
    public int setDefaultAudioRoutetoSpeakerphone(boolean defaultToSpeaker) {
        if (defaultToSpeaker) {
            if (this.arAudioManager != null) {
                this.arAudioManager.setDefaultAudioDevice(ARAudioManager.AudioDevice.SPEAKER_PHONE);
            } else {
                this.arAudioManager.setDefaultAudioDevice(ARAudioManager.AudioDevice.EARPIECE);
            }
        }
        return 0;
    }

    @Override
    public int setEnableSpeakerphone(boolean enabled) {
        if (this.arAudioManager != null) {
            if (enabled) {
                this.arAudioManager.setDefaultAudioDevice(ARAudioManager.AudioDevice.SPEAKER_PHONE);
            } else {
                this.arAudioManager.setDefaultAudioDevice(ARAudioManager.AudioDevice.EARPIECE);
            }
        }
        return 0;
    }

    @Override
    public boolean isSpeakerphoneEnabled() {
        if (this.arAudioManager != null) {
            return this.arAudioManager.getSelectedAudioDevice() == ARAudioManager.AudioDevice.SPEAKER_PHONE;
        }
        Log.d((String)"AR_Log", (String)"Audiomanager is null");
        return false;
    }

    @Override
    public int enableAudioVolumeIndication(int interval, int smooth, boolean report_vad) {
        return this.nativeEnableAudioVolumeIndication(interval, smooth, report_vad);
    }

    @Override
    public int setLogFile(String filePath) {
        if (!this.haveFilePerm()) {
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            return -1;
        }
        return this.nativeSetLogFile(filePath);
    }

    @Override
    public int setLogFilter(int filter) {
        return this.nativesetLogFilter(filter);
    }

    @Override
    public int setLogFileSize(int fileSizeInKBytes) {
        return this.nativesetLogFileSize(fileSizeInKBytes);
    }

    @Override
    public int getConnectionState() {
        return this.nativeGetConnectionState();
    }

    @Override
    public int setParameters(String parameters) {
        return this.nativeSetParameters(parameters);
    }

    @Override
    public String getErrorDescription(int error) {
        return this.nativeGetErrorDescription(error);
    }

    @Override
    public String getCallId() {
        return this.nativeGetCallId();
    }

    @Override
    public int enableFaceDetection(boolean enable) {
        this.enableFaceDetection = enable;
        if (this.mVideoCapturer != null) {
            this.mVideoCapturer.enableFaceDetection(enable);
        }
        return 0;
    }

    @Override
    public int setLocalVoiceReverbPreset(int preset) {
        return 0;
    }

    @Override
    public int setAudioEffectPreset(int preset) {
        return 0;
    }

    @Override
    public int setVoiceBeautifierPreset(int preset) {
        this.nativeSetVoiceBeautifierPreset(preset);
        return 0;
    }

    @Override
    public int startAudioMixing(String filePath, boolean loopback, boolean replace, int cycle) {
        return this.nativeStartAudioMixing(filePath, loopback, replace, cycle);
    }

    @Override
    public int stopAudioMixing() {
        return this.nativeStopAudioMixing();
    }

    @Override
    public int pauseAudioMixing() {
        return this.nativePauseAudioMixing();
    }

    @Override
    public int resumeAudioMixing() {
        return this.nativeResumeAudioMixing();
    }

    @Override
    public int adjustAudioMixingVolume(int volume) {
        return this.nativeAdjustAudioMixingVolume(volume);
    }

    @Override
    public int adjustAudioMixingPlayoutVolume(int volume) {
        return this.nativeAdjustAudioMixingPlayoutVolume(volume);
    }

    @Override
    public int adjustAudioMixingPublishVolume(int volume) {
        return this.nativeAdjustAudioMixingPublishVolume(volume);
    }

    @Override
    public int getAudioMixingPlayoutVolume() {
        return this.nativeGetAudioMixingPlayoutVolume();
    }

    @Override
    public int getAudioMixingPublishVolume() {
        return this.nativeGetAudioMixingPublishVolume();
    }

    @Override
    public IAudioEffectManager getAudioEffectManager() {
        return this;
    }

    @Override
    public void setExternalVideoSource(boolean enable, boolean useTexture, boolean pushMode) {
        this.mVideoSourceType = enable ? 3 : 1;
        this.nativeSetExternalVideoSource(enable, useTexture, pushMode);
    }

    @Override
    public boolean pushExternalVideoFrame(ARVideoFrame videoFrame) {
        if (videoFrame != null) {
            if (this.mVideoSourceType != 3) {
                return false;
            }
            this.nativePushExternalVideoFrame(videoFrame);
            return true;
        }
        return false;
    }

    @Override
    public int setExternalAudioSink(boolean enabled, int sampleRate, int channels) {
        if (channels != 1 && channels != 2) {
            return -1;
        }
        if (sampleRate != 8000 && sampleRate != 16000 && sampleRate != 32000 && sampleRate != 44100 && sampleRate != 48000) {
            return -2;
        }
        this.mExAudioSinkChannels = channels;
        this.mExAudioSinkSampleRate = sampleRate;
        return this.nativeSetExternalAudioSink(enabled, sampleRate, channels);
    }

    @Override
    public int pullPlaybackAudioFrame(byte[] data, int lengthInByte) {
        return this.mExAudioSinkChannels != 1 && this.mExAudioSinkChannels != 2 ? -1 : this.nativePullAudioFrame(data, lengthInByte, this.mExAudioSinkSampleRate, this.mExAudioSinkChannels);
    }

    @Override
    public boolean isTextureEncodeSupported() {
        return false;
    }

    @Override
    public int setVideoSource(IVideoSource source) {
        if (null == source) {
            this.mVideoSourceType = 0;
            return -1;
        }
        this.mVideoSourceType = 2;
        this.nativeAddVideoCapturer(source);
        return 0;
    }

    @Override
    public int setExternalAudioSource(boolean enabled, int sampleRate, int channels) {
        this.mExAudioSampleRate = sampleRate;
        this.mExAudioChannels = channels;
        return this.nativeSetExternalAudioSource(enabled, sampleRate, channels);
    }

    @Override
    public int pushExternalAudioFrame(byte[] data, long timestamp) {
        return this.nativePushExternalAudioFrame(data, timestamp, this.mExAudioSampleRate, this.mExAudioChannels);
    }

    @Override
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        return this.nativeRegisterAudioFrameObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtcChannel createRtcChannel(String channelId) {
        if (!TextUtils.isEmpty((CharSequence)channelId)) {
            RtcEngineImpl rtcEngineImpl = this;
            synchronized (rtcEngineImpl) {
                RtcChannelImpl item;
                if (this.mDefaultRtcChannel != null && this.mDefaultRtcChannel.channelId().equals(channelId)) {
                    return this.mDefaultRtcChannel;
                }
                Iterator channelIterator = this.mRtcChannels.iterator();
                do {
                    if (channelIterator.hasNext()) continue;
                    long rtcChannelHandle = this.nativeCreateRtcChannel(channelId);
                    if (rtcChannelHandle != 0L) {
                        RtcChannelImpl rtcChannel = new RtcChannelImpl();
                        rtcChannel.initialize(this, rtcChannelHandle);
                        this.mRtcChannels.add(rtcChannel);
                        return rtcChannel;
                    }
                    return null;
                } while ((item = (RtcChannelImpl)channelIterator.next()).channelId() == null || !item.channelId().equals(channelId) || !item.isInitialized());
                return item;
            }
        }
        return null;
    }

    @Override
    public int startEchoTest(int intervalInSeconds) {
        return this.nativeStartEchoTest(intervalInSeconds);
    }

    @Override
    public int stopEchoTest() {
        return this.nativeStopEchoTest();
    }

    @Override
    public int enableLastmileTest() {
        return this.nativeEnableLastmileTest();
    }

    @Override
    public int disableLastmileTest() {
        return this.nativeDisableLastmileTest();
    }

    @Override
    public int startLastmileProbeTest(LastmileProbeConfig config) {
        return this.nativeStartLastmileProbeTest(config.probeUplink, config.probeDownlink, config.expectedUplinkBitrate, config.expectedDownlinkBitrate);
    }

    @Override
    public int stopLastmileProbeTest() {
        return this.nativeStopLastmileProbeTest();
    }

    @Override
    public int addInjectStreamUrl(String url, LiveInjectStreamConfig config) {
        if (url != null && config != null) {
            return this.nativeAddInjectStreamUrl(url, config);
        }
        return -2;
    }

    @Override
    public int removeInjectStreamUrl(String url) {
        return url == null ? -2 : this.nativeRemoveInjectStreamUrl(url);
    }

    @Override
    public int addPublishStreamUrl(String var1, boolean var2) {
        return this.nativeAddPublishStreamUrl(var1, var2);
    }

    @Override
    public int removePublishStreamUrl(String var1) {
        return this.nativeRemovePublishStreamUrl(var1);
    }

    @Override
    public int setLiveTranscoding(LiveTranscoding liveTranscoding) {
        return this.nativeSetLiveTranscoding(liveTranscoding, liveTranscoding.getUserArray(), liveTranscoding.watermark, liveTranscoding.backgroundImage);
    }

    @Override
    public int startChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() != 0 && channelMediaRelayConfiguration.getSrcChannelMediaInfo() != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() < 4) {
            HashSet<ChannelMediaInfo> channelMediaInfoSet = new HashSet<ChannelMediaInfo>();
            for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
                if (!TextUtils.isEmpty((CharSequence)entry.getValue().channelName) && !TextUtils.isEmpty((CharSequence)entry.getValue().uid)) {
                    channelMediaInfoSet.add(entry.getValue());
                    continue;
                }
                return -2;
            }
            return this.nativeStartChannelMediaRelay(channelMediaRelayConfiguration.getSrcChannelMediaInfo(), channelMediaInfoSet.toArray());
        }
        return -2;
    }

    @Override
    public int stopChannelMediaRelay() {
        return this.nativeStopChannelMediaRelay();
    }

    @Override
    public int updateChannelMediaRelay(ChannelMediaRelayConfiguration channelMediaRelayConfiguration) {
        if (channelMediaRelayConfiguration != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() != 0 && channelMediaRelayConfiguration.getSrcChannelMediaInfo() != null && channelMediaRelayConfiguration.getDestChannelMediaInfos().size() < 4) {
            HashSet<ChannelMediaInfo> channelMediaInfoSet = new HashSet<ChannelMediaInfo>();
            for (Map.Entry<String, ChannelMediaInfo> entry : channelMediaRelayConfiguration.getDestChannelMediaInfos().entrySet()) {
                if (!TextUtils.isEmpty((CharSequence)entry.getValue().channelName) && !TextUtils.isEmpty((CharSequence)entry.getValue().uid)) {
                    channelMediaInfoSet.add(entry.getValue());
                    continue;
                }
                return -2;
            }
            return this.nativeUpdateChannelMediaRelay(channelMediaRelayConfiguration.getSrcChannelMediaInfo(), channelMediaInfoSet.toArray());
        }
        return -2;
    }

    @Override
    public int setRemoteUserPriority(String uid, int userPriority) {
        return this.nativeSetRemoteUserPriority(uid, userPriority);
    }

    @Override
    public int setLocalPublishFallbackOption(int option) {
        return this.nativeSetLocalPublishFallbackOption(option);
    }

    @Override
    public int setRemoteSubscribeFallbackOption(int option) {
        return this.nativeSetRemoteSubscribeFallbackOption(option);
    }

    @Override
    public int setLocalVideoRenderer(IVideoSink render) {
        this.nativeSetLocalVideoRenderer(render);
        return 0;
    }

    @Override
    public int setRemoteVideoRenderer(String uid, IVideoSink render) {
        this.nativeSetRemoteVideoRenderer(uid, render);
        return 0;
    }

    @Override
    public int setLocalVoiceEqualization(int bandFrequency, int bandGain) {
        this.nativeSetLocalVoiceEqualization(bandFrequency, bandGain);
        return 0;
    }

    @Override
    public int enableEncryption(boolean enabled, EncryptionConfig config) {
        return this.nativeEnableEncryption(enabled, config.encryptionMode.getValue(), config.encryptionKey);
    }

    @Override
    public void setAudioAiNoise(boolean enable) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroyRtcChannel(String channelId) {
        if (channelId != null && channelId.length() > 0) {
            RtcEngineImpl rtcEngineImpl = this;
            synchronized (rtcEngineImpl) {
                RtcChannelImpl item;
                if (this.mDefaultRtcChannel != null && this.mDefaultRtcChannel.channelId().equals(channelId)) {
                    return -5;
                }
                Iterator var3 = this.mRtcChannels.iterator();
                do {
                    if (var3.hasNext()) continue;
                    return 0;
                } while ((item = (RtcChannelImpl)var3.next()).channelId() == null || !item.channelId().equals(channelId));
                int ret = this.nativeRtcChannelRelease(item.getNativeHandle());
                this.mRtcChannels.remove(item);
                return ret;
            }
        }
        return -102;
    }

    @Override
    public long getNativehanlde() {
        return this.nativeGetNativehanlde();
    }

    private boolean haveRECPerm() {
        return ((Context)this.mContext.get()).checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0;
    }

    private boolean haveCameraPerm() {
        return ((Context)this.mContext.get()).checkCallingOrSelfPermission("android.permission.CAMERA") == 0;
    }

    private boolean haveFilePerm() {
        return ((Context)this.mContext.get()).checkCallingOrSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0 && ((Context)this.mContext.get()).checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
    }

    private native int nativeStartPreview();

    private native int nativeStopPreview();

    private native int nativeSetVideoEncoderConfiguration(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native long nativeCreate(Object var1, Object var2, String var3, String var4, Object var5, Object var6);

    private native int nativeSetupJavaVideoLocal(long var1, int var3, int var4, String var5);

    private native int nativeSetupVideoRemote(long var1, int var3, String var4);

    private native int nativeJoinChannel(String var1, String var2, String var3, String var4);

    private native int nativeSwitchChannel(String var1, String var2);

    private native int nativeLeaveChannle();

    private native int nativeEnableDualStreamMode(boolean var1);

    private native int nativeSetRemoteVideoStreamType(String var1, int var2);

    private native int nativeSetChannelProfile(int var1);

    private native int nativeSetClientRole(int var1);

    private native int nativeEnableAudio();

    private native int nativeEnableLocalAudio(boolean var1);

    private native int nativeDisableAudio();

    private native int nativeMuteLocalAudioStream(boolean var1);

    private native int nativeEnableVideo();

    private native int nativeEnableLocalVideo(boolean var1);

    private native int nativeDisableVideo();

    private native int nativeMuteLocalVideoStream(boolean var1);

    private native int nativeSetRemoteDefaultVideoStreamType(int var1);

    private native int nativeMuteRemoteAudioStream(String var1, boolean var2);

    private native int nativeMuteAllRemoteAudioStreams(boolean var1);

    private native int nativeSetDefaultMuteAllRemoteAudioStreams(boolean var1);

    private native int nativeSetDefaultMuteAllRemoteVideoStreams(boolean var1);

    private native int nativeMuteRemoteVideoStream(String var1, boolean var2);

    private native int nativeMuteAllRemoteVideoStreams(boolean var1);

    private native int nativeSetAudioProfile(int var1, int var2);

    private native int nativeAdjustRecordingSignalVolume(int var1);

    private native int nativeAdjustPlaybackSignalVolume(int var1);

    private native int nativeAdjustUserPlaybackSignalVolume(String var1, int var2);

    private native int nativeGetConnectionState();

    private native void nativeRelease();

    private native int nativeSetParameters(String var1);

    private native String nativeGetErrorDescription(int var1);

    private native int nativeEnableAudioVolumeIndication(int var1, int var2, boolean var3);

    private native int nativeEnableInEarMonitoring(boolean var1);

    private native int nativeSetInEarMonitoringVolume(int var1);

    private native int nativeSetLogFile(String var1);

    private native int nativesetLogFilter(int var1);

    private native int nativesetLogFileSize(int var1);

    private native String nativeGetCallId();

    private native int nativeSetVolumeOfEffect(int var1, double var2);

    private native int nativeSetEffectsVolume(double var1);

    private native double nativeGetEffectsVolume();

    private native int nativePlayEffect(int var1, String var2, int var3, double var4, double var6, double var8, boolean var10);

    private native int nativeStopEffect(int var1);

    private native int nativeStopAllEffects();

    private native int nativePreloadEffect(int var1, String var2);

    private native int nativeResumeAllEffects();

    private native int nativeResumeEffect(int var1);

    private native int nativePauseAllEffects();

    private native int nativePauseEffect(int var1);

    private native int nativeUnloadEffect(int var1);

    private native int nativeStartAudioMixing(String var1, boolean var2, boolean var3, int var4);

    private native int nativeStopAudioMixing();

    private native int nativePauseAudioMixing();

    private native int nativeResumeAudioMixing();

    private native int nativeAdjustAudioMixingVolume(int var1);

    private native int nativeAdjustAudioMixingPlayoutVolume(int var1);

    private native int nativeAdjustAudioMixingPublishVolume(int var1);

    private native int nativeGetAudioMixingPlayoutVolume();

    private native int nativeGetAudioMixingPublishVolume();

    private native int nativeSetVoiceBeautifierPreset(int var1);

    private native int nativeReNewToken(String var1);

    private native int nativeSetExternalVideoSource(boolean var1, boolean var2, boolean var3);

    private native int nativeAddVideoCapturer(IVideoSource var1);

    private native int nativePushExternalVideoFrame(ARVideoFrame var1);

    private native int nativeSetExternalAudioSink(boolean var1, int var2, int var3);

    private native int nativePullAudioFrame(byte[] var1, int var2, int var3, int var4);

    private native int nativeSetExternalAudioSource(boolean var1, int var2, int var3);

    private native int nativePushExternalAudioFrame(byte[] var1, long var2, int var4, int var5);

    private native int nativeRegisterAudioFrameObserver(IAudioFrameObserver var1);

    private native long nativeGetNativehanlde();

    private native long nativeGetDefaultRtcChannel();

    private native long nativeCreateRtcChannel(String var1);

    private native int nativeRtcChannelRelease(long var1);

    private native int nativeStartAudioRecording(String var1, int var2, int var3);

    private native int nativeStopAudioRecording();

    private native int nativeStartEchoTest(int var1);

    private native int nativeStopEchoTest();

    private native int nativeEnableLastmileTest();

    private native int nativeDisableLastmileTest();

    private native int nativeStopLastmileProbeTest();

    private native int nativeStartLastmileProbeTest(boolean var1, boolean var2, int var3, int var4);

    private native int nativeAddInjectStreamUrl(String var1, LiveInjectStreamConfig var2);

    private native int nativeRemoveInjectStreamUrl(String var1);

    public native int nativeSetLiveTranscoding(LiveTranscoding var1, LiveTranscoding.TranscodingUser[] var2, LiveTranscoding.RtcImage var3, LiveTranscoding.RtcImage var4);

    public native int nativeAddPublishStreamUrl(String var1, boolean var2);

    public native int nativeRemovePublishStreamUrl(String var1);

    private native int nativeStartChannelMediaRelay(ChannelMediaInfo var1, Object[] var2);

    private native int nativeStopChannelMediaRelay();

    private native int nativeUpdateChannelMediaRelay(ChannelMediaInfo var1, Object[] var2);

    private native int nativeSetRemoteUserPriority(String var1, int var2);

    private native int nativeSetLocalPublishFallbackOption(int var1);

    private native int nativeSetRemoteSubscribeFallbackOption(int var1);

    private native int nativeCreateDataStream(boolean var1, boolean var2);

    private native int nativeSendStreamMessage(byte[] var1, int var2);

    private native int nativeSetLocalVideoRenderer(IVideoSink var1);

    private native int nativeSetRemoteVideoRenderer(String var1, IVideoSink var2);

    private native void nativeSetHead(boolean var1);

    private native int nativeSetLocalVoiceEqualization(int var1, int var2);

    private native int nativeEnableEncryption(boolean var1, int var2, String var3);

    private native void nativeSetAudioAiNoise(boolean var1);

    public static boolean checkIfInUIThread(String name) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            Log.i((String)"AR_Log", (String)(name + " in UI Thread"));
            return true;
        }
        Log.i((String)"AR_Log", (String)(name + " not in UI Thread"));
        return false;
    }

    public static boolean isMusicMode() {
        return b_audio_is_music_;
    }

    private int getMemApp() {
        return this.arDeviceUtil.getProcessMemUsage();
    }

    private double getMemSysPercent() {
        return this.arDeviceUtil.getSysUsedPercentValue();
    }

    private double getMemAppPercent() {
        return this.arDeviceUtil.getProcessPercentValue();
    }

    private double getCpuAppPercent() {
        if (Build.VERSION.SDK_INT >= 23) {
            return 0.0;
        }
        return this.arDeviceUtil.getProcessCpuRate();
    }

    private double getCpuSysPrecent() {
        if (Build.VERSION.SDK_INT >= 23) {
            return 0.0;
        }
        return this.arDeviceUtil.getCpuUsage();
    }

    private String getCpuName() {
        return this.arDeviceUtil.getCpuName();
    }

    private String getImei() {
        if (Build.VERSION.SDK_INT >= 23) {
            return "unknown";
        }
        try {
            TelephonyManager teleMgr = (TelephonyManager)this.getContext().getSystemService("phone");
            if (TextUtils.isEmpty((CharSequence)teleMgr.getDeviceId())) {
                return "unknown";
            }
            return teleMgr.getDeviceId();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    private int getNetType() {
        if (this.mCurNetWorkType.type == -1) {
            this.mCurNetWorkType = ARNetUtil.NetworkType.NETWORK_NO;
        }
        return this.mCurNetWorkType.type;
    }

    private String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    private boolean isLowLatencyOutputSupported() {
        return this.getContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    public boolean isLowLatencyInputSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.isLowLatencyOutputSupported();
    }

    private boolean isHWAecSupport() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    public String getNetOperator() {
        TelephonyManager telephonyManager = (TelephonyManager)((Context)this.mContext.get()).getSystemService("phone");
        return telephonyManager.getSimOperatorName();
    }

    public class ConnectionChangeBroadcastReceiver
    extends BroadcastReceiver {
        public boolean isRegistered;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Intent register(Context context, IntentFilter filter) {
            try {
                Intent intent = !this.isRegistered ? context.registerReceiver((BroadcastReceiver)this, filter) : null;
                return intent;
            }
            finally {
                this.isRegistered = true;
            }
        }

        public boolean unregister(Context context) {
            return this.isRegistered && this.unregisterInternal(context);
        }

        private boolean unregisterInternal(Context context) {
            context.unregisterReceiver((BroadcastReceiver)this);
            this.isRegistered = false;
            return true;
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                RtcEngineImpl.this.getNetWorkStatus();
            }
        }
    }
}

