/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.view.Surface;
import android.view.SurfaceHolder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;
import org.ar.rtc.gl.AREglBase;

public class AREglBase10
extends AREglBase {
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private final EGL10 egl;
    private EGLContext eglContext;
    private EGLConfig eglConfig;
    private EGLDisplay eglDisplay;
    private EGLSurface eglSurface = EGL10.EGL_NO_SURFACE;

    public AREglBase10(Context var1, int[] var2) {
        this.egl = (EGL10)EGLContext.getEGL();
        this.eglDisplay = this.getEglDisplay();
        this.eglConfig = this.getEglConfig(this.eglDisplay, var2);
        this.eglContext = this.createEglContext(var1, this.eglDisplay, this.eglConfig);
    }

    @Override
    public void createSurface(Surface var1) {
        class FakeSurfaceHolder
        implements SurfaceHolder {
            private final Surface surface;

            FakeSurfaceHolder(Surface var2) {
                this.surface = var2;
            }

            public void addCallback(SurfaceHolder.Callback var1) {
            }

            public void removeCallback(SurfaceHolder.Callback var1) {
            }

            public boolean isCreating() {
                return false;
            }

            @Deprecated
            public void setType(int var1) {
            }

            public void setFixedSize(int var1, int var2) {
            }

            public void setSizeFromLayout() {
            }

            public void setFormat(int var1) {
            }

            public void setKeepScreenOn(boolean var1) {
            }

            public Canvas lockCanvas() {
                return null;
            }

            public Canvas lockCanvas(Rect var1) {
                return null;
            }

            public void unlockCanvasAndPost(Canvas var1) {
            }

            public Rect getSurfaceFrame() {
                return null;
            }

            public Surface getSurface() {
                return this.surface;
            }
        }
        this.createSurfaceInternal(new FakeSurfaceHolder(var1));
    }

    @Override
    public void createSurface(SurfaceTexture var1) {
        this.createSurfaceInternal(var1);
    }

    private void createSurfaceInternal(Object var1) {
        if (!(var1 instanceof SurfaceHolder) && !(var1 instanceof SurfaceTexture)) {
            throw new IllegalStateException("Input must be either a SurfaceHolder or SurfaceTexture");
        }
        this.checkIsNotReleased();
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] var2 = new int[]{12344};
        this.eglSurface = this.egl.eglCreateWindowSurface(this.eglDisplay, this.eglConfig, var1, var2);
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create window surface: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
    }

    @Override
    public void createDummyPbufferSurface() {
        this.createPbufferSurface(1, 1);
    }

    @Override
    public void createPbufferSurface(int var1, int var2) {
        this.checkIsNotReleased();
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Already has an EGLSurface");
        }
        int[] var3 = new int[]{12375, var1, 12374, var2, 12344};
        this.eglSurface = this.egl.eglCreatePbufferSurface(this.eglDisplay, this.eglConfig, var3);
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("Failed to create pixel buffer surface with size " + var1 + "x" + var2 + ": 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
    }

    @Override
    public AREglBase.Context getEglBaseContext() {
        return new Context(this.eglContext);
    }

    @Override
    public boolean hasSurface() {
        return this.eglSurface != EGL10.EGL_NO_SURFACE;
    }

    @Override
    public int surfaceWidth() {
        int[] var1 = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12375, var1);
        return var1[0];
    }

    @Override
    public int surfaceHeight() {
        int[] var1 = new int[1];
        this.egl.eglQuerySurface(this.eglDisplay, this.eglSurface, 12374, var1);
        return var1[0];
    }

    @Override
    public void releaseSurface() {
        if (this.eglSurface != EGL10.EGL_NO_SURFACE) {
            this.egl.eglDestroySurface(this.eglDisplay, this.eglSurface);
            this.eglSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    private void checkIsNotReleased() {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY || this.eglContext == EGL10.EGL_NO_CONTEXT || this.eglConfig == null) {
            throw new RuntimeException("This object has been released");
        }
    }

    @Override
    public void release() {
        this.checkIsNotReleased();
        this.releaseSurface();
        this.detachCurrent();
        this.egl.eglDestroyContext(this.eglDisplay, this.eglContext);
        this.egl.eglTerminate(this.eglDisplay);
        this.eglContext = EGL10.EGL_NO_CONTEXT;
        this.eglDisplay = EGL10.EGL_NO_DISPLAY;
        this.eglConfig = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeCurrent() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't make current");
        }
        Object object = AREglBase.lock;
        synchronized (object) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, this.eglSurface, this.eglSurface, this.eglContext)) {
                throw new RuntimeException("eglMakeCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachCurrent() {
        Object object = AREglBase.lock;
        synchronized (object) {
            if (!this.egl.eglMakeCurrent(this.eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT)) {
                throw new RuntimeException("eglDetachCurrent failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void swapBuffers() {
        this.checkIsNotReleased();
        if (this.eglSurface == EGL10.EGL_NO_SURFACE) {
            throw new RuntimeException("No EGLSurface - can't swap buffers");
        }
        Object object = AREglBase.lock;
        synchronized (object) {
            this.egl.eglSwapBuffers(this.eglDisplay, this.eglSurface);
        }
    }

    @Override
    public void swapBuffers(long var1) {
        this.swapBuffers();
    }

    private EGLDisplay getEglDisplay() {
        EGLDisplay var1 = this.egl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (var1 == EGL10.EGL_NO_DISPLAY) {
            throw new RuntimeException("Unable to get EGL10 display: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        int[] var2 = new int[2];
        if (!this.egl.eglInitialize(var1, var2)) {
            throw new RuntimeException("Unable to initialize EGL10: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        return var1;
    }

    private EGLConfig getEglConfig(EGLDisplay var1, int[] var2) {
        EGLConfig[] var3 = new EGLConfig[1];
        int[] var4 = new int[1];
        if (!this.egl.eglChooseConfig(var1, var2, var3, var3.length, var4)) {
            throw new RuntimeException("eglChooseConfig failed: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        if (var4[0] <= 0) {
            throw new RuntimeException("Unable to find any matching EGL config");
        }
        EGLConfig var5 = var3[0];
        if (var5 == null) {
            throw new RuntimeException("eglChooseConfig returned null");
        }
        return var5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EGLContext createEglContext(Context var1, EGLDisplay var2, EGLConfig var3) {
        if (var1 != null && var1.eglContext == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Invalid sharedContext");
        }
        int[] var4 = new int[]{12440, 2, 12344};
        EGLContext var5 = var1 == null ? EGL10.EGL_NO_CONTEXT : var1.eglContext;
        EGLContext var6 = null;
        Object object = AREglBase.lock;
        synchronized (object) {
            var6 = this.egl.eglCreateContext(var2, var3, var5, var4);
            int var8 = this.egl.eglGetError();
            if (var8 != 12288) {
                int[] var9 = new int[]{12440, 3, 12344};
                var6 = this.egl.eglCreateContext(var2, var3, var5, var9);
            }
        }
        if (var6 == EGL10.EGL_NO_CONTEXT) {
            throw new RuntimeException("Failed to create EGL context: 0x" + Integer.toHexString(this.egl.eglGetError()));
        }
        return var6;
    }

    public static class Context
    implements AREglBase.Context {
        private final EGLContext eglContext;

        @Override
        public long getNativeEglContext() {
            return 0L;
        }

        public Context(EGLContext var1) {
            this.eglContext = var1;
        }
    }
}

