/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import android.view.Surface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.ar.rtc.gl.AREglBase;
import org.ar.rtc.gl.ARRendererCommon;
import org.ar.rtc.gl.ARVideoFrameDrawer;
import org.ar.rtc.gl.VideoFrame;
import org.ar.rtc.utils.ThreadUtils;

public class AREglRenderer {
    private static final String TAG = "EglRenderer";
    private static final long LOG_INTERVAL_SEC = 4L;
    private static final int MAX_SURFACE_CLEAR_COUNT = 3;
    private final String name;
    private final Object handlerLock = new Object();
    private Handler renderThreadHandler;
    private final ArrayList<FrameListenerAndParams> frameListeners = new ArrayList();
    private final Object fpsReductionLock = new Object();
    private long nextFrameTimeNs;
    private long minRenderPeriodNs;
    private AREglBase AREglBase;
    private final ARVideoFrameDrawer frameDrawer = new ARVideoFrameDrawer();
    private ARRendererCommon.GlDrawer drawer;
    private final Matrix drawMatrix = new Matrix();
    private final Object frameLock = new Object();
    private VideoFrame pendingFrame;
    private final Object layoutLock = new Object();
    private float layoutAspectRatio;
    private boolean mirror;
    private final Object statisticsLock = new Object();
    private int framesReceived;
    private int framesDropped;
    private int framesRendered;
    private long statisticsStartTimeNs;
    private long renderTimeNs;
    private long renderSwapBufferTimeNs;
    private final Runnable logStatisticsRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AREglRenderer.this.logStatistics();
            Object object = AREglRenderer.this.handlerLock;
            synchronized (object) {
                if (AREglRenderer.this.renderThreadHandler != null) {
                    AREglRenderer.this.renderThreadHandler.removeCallbacks(AREglRenderer.this.logStatisticsRunnable);
                    AREglRenderer.this.renderThreadHandler.postDelayed(AREglRenderer.this.logStatisticsRunnable, TimeUnit.SECONDS.toMillis(4L));
                }
            }
        }
    };
    private final EglSurfaceCreation eglSurfaceCreationRunnable = new EglSurfaceCreation();

    public AREglRenderer(String var1) {
        this.name = var1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(final AREglBase.Context var1, final int[] var2, ARRendererCommon.GlDrawer var3) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                throw new IllegalStateException(this.name + "Already initialized");
            }
            this.logD("Initializing EglRenderer");
            this.drawer = var3;
            HandlerThread var5 = new HandlerThread(this.name + TAG);
            var5.start();
            this.renderThreadHandler = new Handler(var5.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    if (var1 == null) {
                        AREglRenderer.this.logD("EglBase.create context");
                        AREglRenderer.this.AREglBase;
                        AREglRenderer.this.AREglBase = org.ar.rtc.gl.AREglBase.create(var1, var2);
                    } else {
                        AREglRenderer.this.logD("EglBase.create shared context");
                        AREglRenderer.this.AREglBase;
                        AREglRenderer.this.AREglBase = org.ar.rtc.gl.AREglBase.create(var1, var2);
                    }
                }
            });
            this.renderThreadHandler.post((Runnable)this.eglSurfaceCreationRunnable);
            long var6 = System.nanoTime();
            this.resetStatistics(var6);
        }
    }

    public AREglBase.Context getEglContext() {
        return this.AREglBase.getEglBaseContext();
    }

    public void createEglSurface(Surface var1) {
        this.createEglSurfaceInternal(var1);
    }

    public void createEglSurface(SurfaceTexture var1) {
        this.createEglSurfaceInternal(var1);
    }

    private void createEglSurfaceInternal(Object var1) {
        this.eglSurfaceCreationRunnable.setSurface(var1);
        this.postToRenderThread(this.eglSurfaceCreationRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        this.logD("Releasing.");
        final CountDownLatch var1 = new CountDownLatch(1);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler == null) {
                this.logD("Already released");
                return;
            }
            this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    if (AREglRenderer.this.drawer != null) {
                        AREglRenderer.this.drawer.release();
                        AREglRenderer.this.drawer = null;
                    }
                    AREglRenderer.this.frameDrawer.release();
                    if (AREglRenderer.this.AREglBase != null) {
                        AREglRenderer.this.logD("eglBase detach and release.");
                        AREglRenderer.this.AREglBase.detachCurrent();
                        AREglRenderer.this.AREglBase.release();
                        AREglRenderer.this.AREglBase = null;
                    }
                    var1.countDown();
                }
            });
            final Looper var3 = this.renderThreadHandler.getLooper();
            this.renderThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    AREglRenderer.this.logD("Quitting render thread.");
                    var3.quit();
                }
            });
            this.renderThreadHandler = null;
        }
        ThreadUtils.awaitUninterruptibly(var1);
        object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame != null) {
                this.pendingFrame.release();
                this.pendingFrame = null;
            }
        }
        this.logD("Releasing done.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetStatistics(long var1) {
        Object object = this.statisticsLock;
        synchronized (object) {
            this.statisticsStartTimeNs = var1;
            this.framesReceived = 0;
            this.framesDropped = 0;
            this.framesRendered = 0;
            this.renderTimeNs = 0L;
            this.renderSwapBufferTimeNs = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace() {
        Object object = this.handlerLock;
        synchronized (object) {
            StackTraceElement[] var3;
            Thread var2;
            Thread thread = var2 = this.renderThreadHandler == null ? null : this.renderThreadHandler.getLooper().getThread();
            if (var2 != null && (var3 = var2.getStackTrace()).length > 0) {
                this.logD("EglRenderer stack trace:");
                StackTraceElement[] var4 = var3;
                int var5 = var3.length;
                for (int var6 = 0; var6 < var5; ++var6) {
                    StackTraceElement var7 = var4[var6];
                    this.logD(var7.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean var1) {
        this.logD("setMirror: " + var1);
        Object object = this.layoutLock;
        synchronized (object) {
            this.mirror = var1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutAspectRatio(float var1) {
        this.logD("setLayoutAspectRatio: " + var1);
        Object object = this.layoutLock;
        synchronized (object) {
            this.layoutAspectRatio = var1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float var1) {
        this.logD("setFpsReduction: " + var1);
        Object object = this.fpsReductionLock;
        synchronized (object) {
            long var3 = this.minRenderPeriodNs;
            this.minRenderPeriodNs = var1 <= 0.0f ? Long.MAX_VALUE : (long)((float)TimeUnit.SECONDS.toNanos(1L) / var1);
            if (this.minRenderPeriodNs != var3) {
                this.nextFrameTimeNs = System.nanoTime();
            }
        }
    }

    public void disableFpsReduction() {
        this.setFpsReduction(Float.POSITIVE_INFINITY);
    }

    public void pauseVideo() {
        this.setFpsReduction(0.0f);
    }

    public void addFrameListener(FrameListener var1, float var2) {
        this.addFrameListener(var1, var2, null, false);
    }

    public void addFrameListener(FrameListener var1, float var2, ARRendererCommon.GlDrawer var3) {
        this.addFrameListener(var1, var2, var3, false);
    }

    public void addFrameListener(final FrameListener var1, final float var2, final ARRendererCommon.GlDrawer var3, final boolean var4) {
        this.postToRenderThread(new Runnable(){

            @Override
            public void run() {
                ARRendererCommon.GlDrawer var1x = var3 == null ? AREglRenderer.this.drawer : var3;
                AREglRenderer.this.frameListeners.add(new FrameListenerAndParams(var1, var2, var1x, var4));
            }
        });
    }

    public void removeFrameListener(final FrameListener var1) {
        if (Thread.currentThread() == this.renderThreadHandler.getLooper().getThread()) {
            throw new RuntimeException("removeFrameListener must not be called on the render thread.");
        }
        final CountDownLatch var2 = new CountDownLatch(1);
        this.postToRenderThread(new Runnable(){

            @Override
            public void run() {
                var2.countDown();
                Iterator var1x = AREglRenderer.this.frameListeners.iterator();
                while (var1x.hasNext()) {
                    if (((FrameListenerAndParams)var1x.next()).listener != var1) continue;
                    var1x.remove();
                }
            }
        });
        ThreadUtils.awaitUninterruptibly(var2);
    }

    public void renderFrame(VideoFrame var1) {
        this.onFrame(var1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFrame(VideoFrame var1) {
        boolean var2;
        Object object = this.statisticsLock;
        synchronized (object) {
            ++this.framesReceived;
        }
        Object object2 = this.handlerLock;
        synchronized (object2) {
            if (this.renderThreadHandler == null) {
                this.logD("Dropping frame - Not initialized or already released.");
                return;
            }
            Object object3 = this.frameLock;
            synchronized (object3) {
                boolean bl = var2 = this.pendingFrame != null;
                if (var2) {
                    this.pendingFrame.release();
                }
                this.pendingFrame = var1;
                this.pendingFrame.retain();
            }
            ThreadUtils.invokeAtFrontUninterruptibly(this.renderThreadHandler, new Runnable(){

                @Override
                public void run() {
                    AREglRenderer.this.renderFrameOnRenderThread();
                }
            });
        }
        if (var2) {
            object2 = this.statisticsLock;
            synchronized (object2) {
                ++this.framesDropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEglSurface(final Runnable var1) {
        this.eglSurfaceCreationRunnable.setSurface(null);
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.removeCallbacks((Runnable)this.eglSurfaceCreationRunnable);
                this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                    @Override
                    public void run() {
                        if (AREglRenderer.this.AREglBase != null) {
                            AREglRenderer.this.AREglBase.detachCurrent();
                            AREglRenderer.this.AREglBase.releaseSurface();
                        }
                        var1.run();
                    }
                });
                return;
            }
        }
        var1.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postToRenderThread(Runnable var1) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.post(var1);
            }
        }
    }

    private void clearSurfaceOnRenderThread(float var1, float var2, float var3, float var4) {
        if (this.AREglBase != null && this.AREglBase.hasSurface()) {
            this.logD("clearSurface");
            GLES20.glClearColor((float)var1, (float)var2, (float)var3, (float)var4);
            GLES20.glClear((int)16384);
            this.AREglBase.swapBuffers();
        }
    }

    public void clearImage() {
        this.clearImage(0.0f, 0.0f, 0.0f, 0.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearImage(final float var1, final float var2, final float var3, final float var4) {
        Object object = this.handlerLock;
        synchronized (object) {
            if (this.renderThreadHandler != null) {
                this.renderThreadHandler.postAtFrontOfQueue(new Runnable(){

                    @Override
                    public void run() {
                        AREglRenderer.this.clearSurfaceOnRenderThread(var1, var2, var3, var4);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFrameOnRenderThread() {
        VideoFrame var1;
        Object object = this.frameLock;
        synchronized (object) {
            if (this.pendingFrame == null) {
                return;
            }
            var1 = this.pendingFrame;
            this.pendingFrame = null;
        }
        if (this.AREglBase != null && this.AREglBase.hasSurface()) {
            float var8;
            float var7;
            float var6;
            boolean var2;
            Object object2 = this.fpsReductionLock;
            synchronized (object2) {
                if (this.minRenderPeriodNs == Long.MAX_VALUE) {
                    var2 = false;
                } else if (this.minRenderPeriodNs <= 0L) {
                    var2 = true;
                } else {
                    long var4 = System.nanoTime();
                    if (var4 < this.nextFrameTimeNs) {
                        this.logD("Skipping frame rendering - fps reduction is active.");
                        var2 = false;
                    } else {
                        this.nextFrameTimeNs += this.minRenderPeriodNs;
                        this.nextFrameTimeNs = Math.max(this.nextFrameTimeNs, var4);
                        var2 = true;
                    }
                }
            }
            long var3 = System.nanoTime();
            float var5 = (float)var1.getRotatedWidth() / (float)var1.getRotatedHeight();
            Object object3 = this.layoutLock;
            synchronized (object3) {
                var6 = this.layoutAspectRatio != 0.0f ? this.layoutAspectRatio : var5;
            }
            if (var5 > var6) {
                var7 = var6 / var5;
                var8 = 1.0f;
            } else {
                var7 = 1.0f;
                var8 = var5 / var6;
            }
            this.drawMatrix.reset();
            this.drawMatrix.preTranslate(0.5f, 0.5f);
            if (this.mirror) {
                this.drawMatrix.preScale(-1.0f, 1.0f);
            }
            this.drawMatrix.preScale(var7, var8);
            this.drawMatrix.preTranslate(-0.5f, -0.5f);
            if (var2) {
                GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                GLES20.glClear((int)16384);
                this.frameDrawer.drawFrame(var1, this.drawer, this.drawMatrix, 0, 0, this.AREglBase.surfaceWidth(), this.AREglBase.surfaceHeight());
                long var9 = System.nanoTime();
                this.AREglBase.swapBuffers();
                long var11 = System.nanoTime();
                Object object4 = this.statisticsLock;
                synchronized (object4) {
                    ++this.framesRendered;
                    this.renderTimeNs += var11 - var3;
                    this.renderSwapBufferTimeNs += var11 - var9;
                }
            }
            var1.release();
        } else {
            this.logD("Dropping frame - No surface");
            var1.release();
        }
    }

    private String averageTimeAsString(long var1, int var3) {
        return var3 <= 0 ? "NA" : TimeUnit.NANOSECONDS.toMicros(var1 / (long)var3) + " us";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStatistics() {
        long var1 = System.nanoTime();
        Object object = this.statisticsLock;
        synchronized (object) {
            long var4 = var1 - this.statisticsStartTimeNs;
            if (var4 > 0L) {
                float var6 = (float)((long)this.framesRendered * TimeUnit.SECONDS.toNanos(1L)) / (float)var4;
                this.logD("Duration: " + TimeUnit.NANOSECONDS.toMillis(var4) + " ms. Frames received: " + this.framesReceived + ". Dropped: " + this.framesDropped + ". Rendered: " + this.framesRendered + ". Render fps: " + String.format(Locale.US, "%.1f", Float.valueOf(var6)) + ". Average render time: " + this.averageTimeAsString(this.renderTimeNs, this.framesRendered) + ". Average swapBuffer time: " + this.averageTimeAsString(this.renderSwapBufferTimeNs, this.framesRendered) + ".");
                this.resetStatistics(var1);
            }
        }
    }

    private void logD(String var1) {
        Log.d((String)TAG, (String)(this.name + var1));
    }

    public static interface FrameListener {
        public void onFrame(Bitmap var1);
    }

    private static class FrameListenerAndParams {
        public final FrameListener listener;
        public final float scale;
        public final ARRendererCommon.GlDrawer drawer;
        public final boolean applyFpsReduction;

        public FrameListenerAndParams(FrameListener var1, float var2, ARRendererCommon.GlDrawer var3, boolean var4) {
            this.listener = var1;
            this.scale = var2;
            this.drawer = var3;
            this.applyFpsReduction = var4;
        }
    }

    private class EglSurfaceCreation
    implements Runnable {
        private Object surface;

        private EglSurfaceCreation() {
        }

        public synchronized void setSurface(Object var1) {
            this.surface = var1;
        }

        @Override
        public synchronized void run() {
            if (this.surface != null && AREglRenderer.this.AREglBase != null && !AREglRenderer.this.AREglBase.hasSurface()) {
                if (this.surface instanceof Surface) {
                    AREglRenderer.this.AREglBase.createSurface((Surface)this.surface);
                } else {
                    if (!(this.surface instanceof SurfaceTexture)) {
                        throw new IllegalStateException("Invalid surface: " + this.surface);
                    }
                    AREglRenderer.this.AREglBase.createSurface((SurfaceTexture)this.surface);
                }
                AREglRenderer.this.AREglBase.makeCurrent();
                GLES20.glPixelStorei((int)3317, (int)1);
            }
        }
    }
}

