/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.opengl.GLES20;
import android.util.Log;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import org.webrtc.GlUtil;

public class ARGlShader {
    private static final String TAG = "GlShader";
    private int program;

    private static int compileShader(int var0, String var1) {
        int var2 = GLES20.glCreateShader((int)var0);
        if (var2 == 0) {
            throw new RuntimeException("glCreateShader() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glShaderSource((int)var2, (String)var1);
        GLES20.glCompileShader((int)var2);
        int[] var3 = new int[]{0};
        GLES20.glGetShaderiv((int)var2, (int)35713, (int[])var3, (int)0);
        if (var3[0] != 1) {
            Log.e((String)TAG, (String)("Could not compile shader " + var0 + ":" + GLES20.glGetShaderInfoLog((int)var2)));
            throw new RuntimeException(GLES20.glGetShaderInfoLog((int)var2));
        }
        GlUtil.checkNoGLES2Error("compileShader");
        return var2;
    }

    public ARGlShader(String var1, String var2) {
        int var3 = ARGlShader.compileShader(35633, var1);
        int var4 = ARGlShader.compileShader(35632, var2);
        this.program = GLES20.glCreateProgram();
        if (this.program == 0) {
            throw new RuntimeException("glCreateProgram() failed. GLES20 error: " + GLES20.glGetError());
        }
        GLES20.glAttachShader((int)this.program, (int)var3);
        GLES20.glAttachShader((int)this.program, (int)var4);
        GLES20.glLinkProgram((int)this.program);
        int[] var5 = new int[]{0};
        GLES20.glGetProgramiv((int)this.program, (int)35714, (int[])var5, (int)0);
        if (var5[0] != 1) {
            Log.e((String)TAG, (String)("Could not link program: " + GLES20.glGetProgramInfoLog((int)this.program)));
            throw new RuntimeException(GLES20.glGetProgramInfoLog((int)this.program));
        }
        GLES20.glDeleteShader((int)var3);
        GLES20.glDeleteShader((int)var4);
        GlUtil.checkNoGLES2Error("Creating GlShader");
    }

    public int getAttribLocation(String var1) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int var2 = GLES20.glGetAttribLocation((int)this.program, (String)var1);
        if (var2 < 0) {
            throw new RuntimeException("Could not locate '" + var1 + "' in program");
        }
        return var2;
    }

    public void setVertexAttribArray(String var1, int var2, FloatBuffer var3) {
        this.setVertexAttribArray(var1, var2, 0, var3);
    }

    public void setVertexAttribArray(String var1, int var2, int var3, FloatBuffer var4) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int var5 = this.getAttribLocation(var1);
        GLES20.glEnableVertexAttribArray((int)var5);
        GLES20.glVertexAttribPointer((int)var5, (int)var2, (int)5126, (boolean)false, (int)var3, (Buffer)var4);
        GlUtil.checkNoGLES2Error("setVertexAttribArray");
    }

    public int getUniformLocation(String var1) {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        int var2 = GLES20.glGetUniformLocation((int)this.program, (String)var1);
        if (var2 < 0) {
            throw new RuntimeException("Could not locate uniform '" + var1 + "' in program");
        }
        return var2;
    }

    public void useProgram() {
        if (this.program == -1) {
            throw new RuntimeException("The program has been released");
        }
        GLES20.glUseProgram((int)this.program);
        GlUtil.checkNoGLES2Error("glUseProgram");
    }

    public void release() {
        Log.d((String)TAG, (String)"Deleting shader.");
        if (this.program != -1) {
            GLES20.glDeleteProgram((int)this.program);
            this.program = -1;
        }
    }
}

