/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.graphics.Matrix;
import org.ar.rtc.gl.VideoFrame;
import org.ar.rtc.mediaio.ARSurfaceTextureHelper;

public class ARTextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private final Matrix transformMatrix;
    private final ARSurfaceTextureHelper ARSurfaceTextureHelper;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;

    public ARTextureBufferImpl(int var1, int var2, VideoFrame.TextureBuffer.Type var3, int var4, Matrix var5, ARSurfaceTextureHelper var6, Runnable var7) {
        this.width = var1;
        this.height = var2;
        this.type = var3;
        this.id = var4;
        this.transformMatrix = var5;
        this.ARSurfaceTextureHelper = var6;
        this.releaseCallback = var7;
        this.refCount = 1;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return this.ARSurfaceTextureHelper.textureToYuv(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6) {
        this.retain();
        Matrix var7 = new Matrix(this.transformMatrix);
        var7.postScale((float)var3 / (float)this.width, (float)var4 / (float)this.height);
        var7.postTranslate((float)var1 / (float)this.width, (float)var2 / (float)this.height);
        return new ARTextureBufferImpl(var5, var6, this.type, this.id, var7, this.ARSurfaceTextureHelper, new Runnable(){

            @Override
            public void run() {
                ARTextureBufferImpl.this.release();
            }
        });
    }
}

