/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.gl;

import android.graphics.Matrix;
import java.nio.ByteBuffer;
import org.ar.rtc.gl.ARJavaI420Buffer;

public class VideoFrame {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;

    public VideoFrame(Buffer var1, int var2, long var3) {
        if (var1 == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (var2 % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = var1;
        this.rotation = var2;
        this.timestampNs = var3;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public int getRotation() {
        return this.rotation;
    }

    public long getTimestampNs() {
        return this.timestampNs;
    }

    public int getRotatedWidth() {
        return this.rotation % 180 == 0 ? this.buffer.getWidth() : this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        return this.rotation % 180 == 0 ? this.buffer.getHeight() : this.buffer.getWidth();
    }

    public void retain() {
        this.buffer.retain();
    }

    public void release() {
        this.buffer.release();
    }

    public static Buffer cropAndScaleI420(final I420Buffer var0, int var1, int var2, int var3, int var4, int var5, int var6) {
        if (var3 == var5 && var4 == var6) {
            ByteBuffer var10 = var0.getDataY();
            ByteBuffer var8 = var0.getDataU();
            ByteBuffer var9 = var0.getDataV();
            var10.position(var1 + var2 * var0.getStrideY());
            var8.position(var1 / 2 + var2 / 2 * var0.getStrideU());
            var9.position(var1 / 2 + var2 / 2 * var0.getStrideV());
            var0.retain();
            return ARJavaI420Buffer.wrap(var0.getWidth(), var0.getHeight(), var10.slice(), var0.getStrideY(), var8.slice(), var0.getStrideU(), var9.slice(), var0.getStrideV(), new Runnable(){

                @Override
                public void run() {
                    var0.release();
                }
            });
        }
        ARJavaI420Buffer var7 = ARJavaI420Buffer.allocate(var5, var6);
        VideoFrame.nativeCropAndScaleI420(var0.getDataY(), var0.getStrideY(), var0.getDataU(), var0.getStrideU(), var0.getDataV(), var0.getStrideV(), var1, var2, var3, var4, var7.getDataY(), var7.getStrideY(), var7.getDataU(), var7.getStrideU(), var7.getDataV(), var7.getStrideV(), var5, var6);
        return var7;
    }

    private static native void nativeCropAndScaleI420(ByteBuffer var0, int var1, ByteBuffer var2, int var3, ByteBuffer var4, int var5, int var6, int var7, int var8, int var9, ByteBuffer var10, int var11, ByteBuffer var12, int var13, ByteBuffer var14, int var15, int var16, int var17);

    public static interface Buffer {
        public int getWidth();

        public int getHeight();

        public I420Buffer toI420();

        public void retain();

        public void release();

        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface I420Buffer
    extends Buffer {
        public ByteBuffer getDataY();

        public ByteBuffer getDataU();

        public ByteBuffer getDataV();

        public int getStrideY();

        public int getStrideU();

        public int getStrideV();
    }

    public static interface TextureBuffer
    extends Buffer {
        public Type getType();

        public int getTextureId();

        public Matrix getTransformMatrix();

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            private Type(int var3) {
                this.glTarget = var3;
            }

            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }
}

