/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.mediaio;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import java.nio.ByteBuffer;
import org.ar.rtc.gl.AREglBase;
import org.ar.rtc.gl.ARRendererCommon;
import org.ar.rtc.mediaio.BaseVideoRenderer;
import org.ar.rtc.mediaio.IVideoSink;
import org.ar.rtc.mediaio.MediaIO;
import org.ar.rtc.utils.ThreadUtils;

public class ARSurfaceView
extends SurfaceView
implements IVideoSink,
SurfaceHolder.Callback {
    private static final String TAG = ARSurfaceView.class.getSimpleName();
    private BaseVideoRenderer mRender = new BaseVideoRenderer(TAG);
    private AREglBase.Context mEglContext;
    private int[] mConfigAttributes;
    private ARRendererCommon.GlDrawer mDrawer;

    public ARSurfaceView(Context context) {
        super(context);
        this.mRender.setRenderView(this, this);
    }

    public ARSurfaceView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRender.setRenderView(this, this);
    }

    public void init(AREglBase.Context sharedContext) {
        this.mEglContext = sharedContext;
    }

    public void init(AREglBase.Context sharedContext, int[] configAttributes, ARRendererCommon.GlDrawer drawer) {
        this.mEglContext = sharedContext;
        this.mConfigAttributes = configAttributes;
        this.mDrawer = drawer;
    }

    @Override
    public long getEGLContextHandle() {
        return this.mRender.getEGLContextHandle();
    }

    public void setBufferType(MediaIO.BufferType type) {
        this.mRender.setBufferType(type);
    }

    public void setPixelFormat(MediaIO.PixelFormat pixelFormat) {
        this.mRender.setPixelFormat(pixelFormat);
    }

    public void setMirror(boolean mirror) {
        this.mRender.getEglRender().setMirror(mirror);
    }

    @Override
    public boolean onInitialize() {
        if (this.mConfigAttributes != null && this.mDrawer != null) {
            this.mRender.init(this.mEglContext, this.mConfigAttributes, this.mDrawer);
        } else {
            this.mRender.init(this.mEglContext);
        }
        return true;
    }

    @Override
    public boolean onStart() {
        return this.mRender.start();
    }

    @Override
    public void onStop() {
        this.mRender.stop();
    }

    @Override
    public void onDispose() {
        this.mRender.release();
    }

    @Override
    public void consumeByteBufferFrame(ByteBuffer buffer, int format, int width, int height, int rotation, long ts) {
        this.mRender.consume(buffer, format, width, height, rotation, ts);
    }

    @Override
    public void consumeByteArrayFrame(byte[] data, int pixelFormat, int width, int height, int rotation, long ts) {
        this.mRender.consume(data, pixelFormat, width, height, rotation, ts);
    }

    @Override
    public void consumeTextureFrame(int texId, int pixelFormat, int width, int height, int rotation, long ts, float[] matrix) {
        this.mRender.consume(texId, pixelFormat, width, height, rotation, ts, matrix);
    }

    @Override
    public int getBufferType() {
        int var1 = this.mRender.getBufferType();
        if (var1 == -1) {
            throw new IllegalArgumentException("Buffer type is not set");
        }
        return var1;
    }

    @Override
    public int getPixelFormat() {
        int var1 = this.mRender.getPixelFormat();
        if (var1 == -1) {
            throw new IllegalArgumentException("Pixel format is not set");
        }
        return var1;
    }

    public void surfaceCreated(SurfaceHolder holder) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        Log.i((String)TAG, (String)("surfaceChanged: format: " + format + " size: " + width + "x" + height));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        ThreadUtils.checkIsOnMainThread();
        this.mRender.getEglRender().setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
    }
}

