/*
 * Decompiled with CFR 0.152.
 */
package org.ar.rtc.utils;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class YUVUtils {
    public static void swapYU12toYUV420SP(byte[] yu12bytes, byte[] i420bytes, int height, int yStride) {
        int startPos;
        System.arraycopy(yu12bytes, 0, i420bytes, 0, yStride * height);
        int yv_start_pos_u = startPos = yStride * height;
        int yv_start_pos_v = startPos + startPos / 4;
        for (int i = 0; i < startPos / 4; ++i) {
            i420bytes[startPos + 2 * i + 0] = yu12bytes[yv_start_pos_v + i];
            i420bytes[startPos + 2 * i + 1] = yu12bytes[yv_start_pos_u + i];
        }
    }

    public static Bitmap i420ToBitmap(int width, int height, int rotation, int bufferLength, byte[] buffer, int yStride) {
        byte[] NV21 = new byte[bufferLength];
        YUVUtils.swapYU12toYUV420SP(buffer, NV21, height, yStride);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int[] strides = new int[]{yStride, yStride};
        YuvImage image = new YuvImage(NV21, 17, width, height, strides);
        image.compressToJpeg(new Rect(0, 0, image.getWidth(), image.getHeight()), 100, (OutputStream)baos);
        Matrix matrix = new Matrix();
        matrix.postRotate((float)rotation);
        byte[] bytes = baos.toByteArray();
        try {
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)bytes.length);
    }
}

