/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.recorder;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.AsyncTask;
import android.util.SparseArray;
import java.lang.reflect.Field;
import java.util.ArrayList;

class Utils {
    static SparseArray<String> sAACProfiles = new SparseArray();
    static SparseArray<String> sAVCProfiles = new SparseArray();
    static SparseArray<String> sAVCLevels = new SparseArray();
    static SparseArray<String> sColorFormats = new SparseArray();

    Utils() {
    }

    static void findEncodersByTypeAsync(String mimeType, Callback callback) {
        new EncoderFinder(callback).execute(new String[]{mimeType});
    }

    static MediaCodecInfo[] findEncodersByType(String mimeType) {
        MediaCodecList codecList = new MediaCodecList(1);
        ArrayList<MediaCodecInfo> infos = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo info : codecList.getCodecInfos()) {
            if (!info.isEncoder()) continue;
            try {
                MediaCodecInfo.CodecCapabilities cap = info.getCapabilitiesForType(mimeType);
                if (cap == null) {
                }
            }
            catch (IllegalArgumentException e) {}
            continue;
            infos.add(info);
        }
        return infos.toArray(new MediaCodecInfo[infos.size()]);
    }

    static String avcProfileLevelToString(MediaCodecInfo.CodecProfileLevel avcProfileLevel) {
        if (sAVCProfiles.size() == 0 || sAVCLevels.size() == 0) {
            Utils.initProfileLevels();
        }
        String profile = null;
        String level = null;
        int i = sAVCProfiles.indexOfKey(avcProfileLevel.profile);
        if (i >= 0) {
            profile = (String)sAVCProfiles.valueAt(i);
        }
        if ((i = sAVCLevels.indexOfKey(avcProfileLevel.level)) >= 0) {
            level = (String)sAVCLevels.valueAt(i);
        }
        if (profile == null) {
            profile = String.valueOf(avcProfileLevel.profile);
        }
        if (level == null) {
            level = String.valueOf(avcProfileLevel.level);
        }
        return profile + '-' + level;
    }

    static String[] aacProfiles() {
        if (sAACProfiles.size() == 0) {
            Utils.initProfileLevels();
        }
        String[] profiles = new String[sAACProfiles.size()];
        for (int i = 0; i < sAACProfiles.size(); ++i) {
            profiles[i] = (String)sAACProfiles.valueAt(i);
        }
        return profiles;
    }

    static MediaCodecInfo.CodecProfileLevel toProfileLevel(String str) {
        if (sAVCProfiles.size() == 0 || sAVCLevels.size() == 0 || sAACProfiles.size() == 0) {
            Utils.initProfileLevels();
        }
        String profile = str;
        String level = null;
        int i = str.indexOf(45);
        if (i > 0) {
            profile = str.substring(0, i);
            level = str.substring(i + 1);
        }
        MediaCodecInfo.CodecProfileLevel res = new MediaCodecInfo.CodecProfileLevel();
        if (profile.startsWith("AVC")) {
            res.profile = Utils.keyOfValue(sAVCProfiles, profile);
        } else if (profile.startsWith("AAC")) {
            res.profile = Utils.keyOfValue(sAACProfiles, profile);
        } else {
            try {
                res.profile = Integer.parseInt(profile);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (level != null) {
            if (level.startsWith("AVC")) {
                res.level = Utils.keyOfValue(sAVCLevels, level);
            } else {
                try {
                    res.level = Integer.parseInt(level);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return res.profile > 0 && res.level >= 0 ? res : null;
    }

    private static <T> int keyOfValue(SparseArray<T> array, T value) {
        int size = array.size();
        for (int i = 0; i < size; ++i) {
            Object t = array.valueAt(i);
            if (t != value && !t.equals(value)) continue;
            return array.keyAt(i);
        }
        return -1;
    }

    private static void initProfileLevels() {
        Field[] fields;
        for (Field f : fields = MediaCodecInfo.CodecProfileLevel.class.getFields()) {
            SparseArray<String> target;
            if ((f.getModifiers() & 0x18) == 0) continue;
            String name = f.getName();
            if (name.startsWith("AVCProfile")) {
                target = sAVCProfiles;
            } else if (name.startsWith("AVCLevel")) {
                target = sAVCLevels;
            } else {
                if (!name.startsWith("AACObject")) continue;
                target = sAACProfiles;
            }
            try {
                target.put(f.getInt(null), (Object)name);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    static String toHumanReadable(int colorFormat) {
        int i;
        if (sColorFormats.size() == 0) {
            Utils.initColorFormatFields();
        }
        if ((i = sColorFormats.indexOfKey(colorFormat)) >= 0) {
            return (String)sColorFormats.valueAt(i);
        }
        return "0x" + Integer.toHexString(colorFormat);
    }

    static int toColorFormat(String str) {
        int color;
        if (sColorFormats.size() == 0) {
            Utils.initColorFormatFields();
        }
        if ((color = Utils.keyOfValue(sColorFormats, str)) > 0) {
            return color;
        }
        if (str.startsWith("0x")) {
            return Integer.parseInt(str.substring(2), 16);
        }
        return 0;
    }

    private static void initColorFormatFields() {
        Field[] fields;
        for (Field f : fields = MediaCodecInfo.CodecCapabilities.class.getFields()) {
            String name;
            if ((f.getModifiers() & 0x18) == 0 || !(name = f.getName()).startsWith("COLOR_")) continue;
            try {
                int value = f.getInt(null);
                sColorFormats.put(value, (Object)name);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    static final class EncoderFinder
    extends AsyncTask<String, Void, MediaCodecInfo[]> {
        private Callback func;

        EncoderFinder(Callback func) {
            this.func = func;
        }

        protected MediaCodecInfo[] doInBackground(String ... mimeTypes) {
            return Utils.findEncodersByType(mimeTypes[0]);
        }

        protected void onPostExecute(MediaCodecInfo[] mediaCodecInfos) {
            this.func.onResult(mediaCodecInfos);
        }
    }

    static interface Callback {
        public void onResult(MediaCodecInfo[] var1);
    }
}

