/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.recorder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import java.util.Objects;
import org.webrtc.recorder.BaseEncoder;
import org.webrtc.recorder.VideoEncodeConfig;

class VideoEncoder
extends BaseEncoder {
    private static final boolean VERBOSE = false;
    private VideoEncodeConfig mConfig;
    private Surface mSurface;

    VideoEncoder(VideoEncodeConfig config) {
        super(config.codecName);
        this.mConfig = config;
    }

    @Override
    protected void onEncoderConfigured(MediaCodec encoder) {
        this.mSurface = encoder.createInputSurface();
    }

    @Override
    protected MediaFormat createMediaFormat() {
        return this.mConfig.toFormat();
    }

    @RequiresApi(api=19)
    Surface getInputSurface() {
        return Objects.requireNonNull(this.mSurface, "doesn't prepare()");
    }

    @Override
    public void release() {
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        super.release();
    }
}

