/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k;

import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.kubernetes.config.Annotation;
import io.ap4k.kubernetes.config.ApplicationConfiguration;
import io.ap4k.kubernetes.config.AwsElasticBlockStoreVolume;
import io.ap4k.kubernetes.config.AzureDiskVolume;
import io.ap4k.kubernetes.config.AzureFileVolume;
import io.ap4k.kubernetes.config.ConfigMapVolume;
import io.ap4k.kubernetes.config.Container;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.config.Label;
import io.ap4k.kubernetes.config.Mount;
import io.ap4k.kubernetes.config.PersistentVolumeClaimVolume;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.config.SecretVolume;
import io.ap4k.kubernetes.decorator.AddAnnotationDecorator;
import io.ap4k.kubernetes.decorator.AddAwsElasticBlockStoreVolumeDecorator;
import io.ap4k.kubernetes.decorator.AddAzureDiskVolumeDecorator;
import io.ap4k.kubernetes.decorator.AddAzureFileVolumeDecorator;
import io.ap4k.kubernetes.decorator.AddConfigMapVolumeDecorator;
import io.ap4k.kubernetes.decorator.AddEnvVarDecorator;
import io.ap4k.kubernetes.decorator.AddInitContainerDecorator;
import io.ap4k.kubernetes.decorator.AddLabelDecorator;
import io.ap4k.kubernetes.decorator.AddLivenessProbeDecorator;
import io.ap4k.kubernetes.decorator.AddMountDecorator;
import io.ap4k.kubernetes.decorator.AddPortDecorator;
import io.ap4k.kubernetes.decorator.AddPvcVolumeDecorator;
import io.ap4k.kubernetes.decorator.AddReadinessProbeDecorator;
import io.ap4k.kubernetes.decorator.AddSecretVolumeDecorator;
import io.ap4k.kubernetes.decorator.AddServiceDecorator;
import io.ap4k.kubernetes.decorator.AddSidecarDecorator;
import io.ap4k.kubernetes.decorator.ApplyArgsDecorator;
import io.ap4k.kubernetes.decorator.ApplyCommandDecorator;
import io.ap4k.kubernetes.decorator.ApplyImagePullPolicyDecorator;
import io.ap4k.kubernetes.decorator.ApplyReplicasDecorator;
import io.ap4k.kubernetes.decorator.ApplyServiceAccountDecorator;
import io.ap4k.utils.Labels;
import java.util.Arrays;

public abstract class AbstractKubernetesHandler<C extends KubernetesConfig>
implements Handler<C> {
    protected final Resources resources;

    public AbstractKubernetesHandler(Resources resources) {
        this.resources = resources;
    }

    @Override
    public abstract void handle(C var1);

    protected void setApplicationInfo(C config) {
        this.resources.setGroup(((ApplicationConfiguration)config).getGroup());
        this.resources.setName(((ApplicationConfiguration)config).getName());
        this.resources.setVersion(((ApplicationConfiguration)config).getVersion());
        this.resources.setLabels(Labels.createLabels(config));
        Arrays.asList(((KubernetesConfig)config).getLabels()).forEach(l -> this.resources.addLabel((Label)l));
    }

    protected void addDecorators(String group, C config) {
        this.resources.decorate(new ApplyServiceAccountDecorator(((KubernetesConfig)config).getServiceAccount()));
        this.resources.decorate(group, new ApplyImagePullPolicyDecorator(((KubernetesConfig)config).getImagePullPolicy()));
        this.resources.decorate(group, new ApplyReplicasDecorator(((ApplicationConfiguration)config).getName(), ((KubernetesConfig)config).getReplicas()));
        for (Container container : ((KubernetesConfig)config).getInitContainers()) {
            this.resources.decorate(group, new AddInitContainerDecorator(((ApplicationConfiguration)config).getName(), container));
        }
        for (Container container : ((KubernetesConfig)config).getSidecars()) {
            this.resources.decorate(group, new AddSidecarDecorator(((ApplicationConfiguration)config).getName(), container));
        }
        for (Label label : ((KubernetesConfig)config).getLabels()) {
            this.resources.decorate(group, new AddLabelDecorator(label));
        }
        for (Annotation annotation : ((KubernetesConfig)config).getAnnotations()) {
            this.resources.decorate(group, new AddAnnotationDecorator(annotation));
        }
        for (Env env : ((KubernetesConfig)config).getEnvVars()) {
            this.resources.decorate(group, new AddEnvVarDecorator(((ApplicationConfiguration)config).getName(), ((ApplicationConfiguration)config).getName(), env));
        }
        for (Port port : ((KubernetesConfig)config).getPorts()) {
            this.resources.decorate(group, new AddPortDecorator(((ApplicationConfiguration)config).getName(), ((ApplicationConfiguration)config).getName(), port));
        }
        for (Mount mount : ((KubernetesConfig)config).getMounts()) {
            this.resources.decorate(group, new AddMountDecorator(mount));
        }
        for (SecretVolume secretVolume : ((KubernetesConfig)config).getSecretVolumes()) {
            this.resources.decorate(group, new AddSecretVolumeDecorator(secretVolume));
        }
        for (ConfigMapVolume configMapVolume : ((KubernetesConfig)config).getConfigMapVolumes()) {
            this.resources.decorate(group, new AddConfigMapVolumeDecorator(configMapVolume));
        }
        for (PersistentVolumeClaimVolume persistentVolumeClaimVolume : ((KubernetesConfig)config).getPvcVolumes()) {
            this.resources.decorate(group, new AddPvcVolumeDecorator(persistentVolumeClaimVolume));
        }
        for (AzureFileVolume azureFileVolume : ((KubernetesConfig)config).getAzureFileVolumes()) {
            this.resources.decorate(group, new AddAzureFileVolumeDecorator(azureFileVolume));
        }
        for (AzureDiskVolume azureDiskVolume : ((KubernetesConfig)config).getAzureDiskVolumes()) {
            this.resources.decorate(group, new AddAzureDiskVolumeDecorator(azureDiskVolume));
        }
        for (AwsElasticBlockStoreVolume awsElasticBlockStoreVolume : ((KubernetesConfig)config).getAwsElasticBlockStoreVolumes()) {
            this.resources.decorate(group, new AddAwsElasticBlockStoreVolumeDecorator(awsElasticBlockStoreVolume));
        }
        if (((KubernetesConfig)config).getPorts().length > 0) {
            this.resources.decorate(group, new AddServiceDecorator((KubernetesConfig)config, this.resources.getLabels()));
        }
        if (((KubernetesConfig)config).getCommand().length > 0) {
            this.resources.decorate(group, new ApplyCommandDecorator(((ApplicationConfiguration)config).getName(), ((ApplicationConfiguration)config).getName(), ((KubernetesConfig)config).getCommand()));
        }
        if (((KubernetesConfig)config).getArguments().length > 0) {
            this.resources.decorate(group, new ApplyArgsDecorator(((ApplicationConfiguration)config).getName(), ((ApplicationConfiguration)config).getName(), ((KubernetesConfig)config).getArguments()));
        }
        this.resources.decorate(group, new AddLivenessProbeDecorator(((ApplicationConfiguration)config).getName(), ((ApplicationConfiguration)config).getName(), ((KubernetesConfig)config).getLivenessProbe()));
        this.resources.decorate(group, new AddReadinessProbeDecorator(((ApplicationConfiguration)config).getName(), ((ApplicationConfiguration)config).getName(), ((KubernetesConfig)config).getReadinessProbe()));
    }
}

