/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k;

import io.ap4k.config.ConfigurationSupplier;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.kubernetes.config.Configurator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Configurators {
    private final Set<ConfigurationSupplier<? extends Configuration>> suppliers = new LinkedHashSet<ConfigurationSupplier<? extends Configuration>>();
    private final Set<Configurator> configurators = new HashSet<Configurator>();

    public void add(ConfigurationSupplier supplier) {
        this.suppliers.add(supplier);
    }

    public void add(Configurator configurator) {
        this.configurators.add(configurator);
    }

    public Stream<? extends Configuration> stream() {
        return this.suppliers.stream().map(s -> (Configuration)s.configure(this.configurators).get());
    }

    public Set<? extends Configuration> toSet() {
        return this.stream().collect(Collectors.toSet());
    }

    public <C extends Configuration> Optional<C> get(Class<C> type) {
        return this.stream().filter(i -> type.isAssignableFrom(i.getClass())).map(i -> i).findFirst();
    }
}

