/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k;

import io.ap4k.Coordinates;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.Doneable;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.KubernetesListBuilder;
import io.ap4k.kubernetes.config.Label;
import io.ap4k.kubernetes.decorator.Decorator;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;

public class Resources
implements Coordinates {
    private static final String DEFAULT_GROUP = "kubernetes";
    private final Map<String, KubernetesListBuilder> groups = new LinkedHashMap<String, KubernetesListBuilder>();
    private final KubernetesListBuilder global = new KubernetesListBuilder();
    private final Set<Decorator> globalDecorators = new HashSet<Decorator>();
    private final Map<String, Set<Decorator>> groupDecorators = new HashMap<String, Set<Decorator>>();
    private final Map<String, Set<Decorator>> customDecorators = new HashMap<String, Set<Decorator>>();
    private final Map<String, KubernetesListBuilder> customGroups = new HashMap<String, KubernetesListBuilder>();
    private final AtomicReference<String> group = new AtomicReference();
    private final AtomicReference<String> name = new AtomicReference();
    private final AtomicReference<String> version = new AtomicReference();
    private final Map<String, String> labels = new HashMap<String, String>();

    public Map<String, KubernetesListBuilder> groups() {
        return this.groups;
    }

    public void decorate(Decorator decorator) {
        this.globalDecorators.add(decorator);
    }

    public void decorate(String group, Decorator decorator) {
        if (!this.groupDecorators.containsKey(group)) {
            this.groupDecorators.put(group, new TreeSet());
        }
        this.groupDecorators.get(group).add(decorator);
    }

    public void decorate(Doneable<? extends Decorator> decorator) {
        this.globalDecorators.add((Decorator)decorator.done());
    }

    public void add(HasMetadata metadata) {
        this.global.addToItems(new HasMetadata[]{metadata});
    }

    public void add(String group, HasMetadata metadata) {
        if (!this.groups.containsKey(group)) {
            this.groups.put(group, new KubernetesListBuilder());
        }
        this.groups.get(group).addToItems(new HasMetadata[]{metadata});
    }

    public void decorateCustom(String group, Decorator decorator) {
        if (!this.customDecorators.containsKey(group)) {
            this.customDecorators.put(group, new TreeSet());
        }
        this.customDecorators.get(group).add(decorator);
    }

    public void addCustom(String group, HasMetadata metadata) {
        if (!this.customGroups.containsKey(group)) {
            this.customGroups.put(group, new KubernetesListBuilder());
        }
        this.customGroups.get(group).addToItems(new HasMetadata[]{metadata});
    }

    protected Map<String, KubernetesList> generate() {
        List allGlobals = this.global.buildItems();
        if (this.groups.isEmpty()) {
            this.groups.put(DEFAULT_GROUP, new KubernetesListBuilder());
        }
        HashMap<String, KubernetesListBuilder> groups = new HashMap<String, KubernetesListBuilder>(this.groups);
        HashMap<String, KubernetesList> resources = new HashMap<String, KubernetesList>();
        for (Map.Entry entry : groups.entrySet()) {
            ((KubernetesListBuilder)entry.getValue()).addAllToItems((Collection)allGlobals);
        }
        this.groupDecorators.forEach((group, decorators) -> {
            if (groups.containsKey(group)) {
                TreeSet<Decorator> union = new TreeSet<Decorator>();
                union.addAll((Collection<Decorator>)decorators);
                union.addAll(this.globalDecorators);
                for (Decorator d : union) {
                    ((KubernetesListBuilder)groups.get(group)).accept((Visitor)d);
                }
            }
        });
        groups.forEach((g, b) -> resources.put((String)g, b.build()));
        for (Map.Entry<Object, Object> entry : this.customDecorators.entrySet()) {
            String group2 = (String)entry.getKey();
            Set groupDecorators = (Set)entry.getValue();
            for (Decorator decorator : groupDecorators) {
                this.customGroups.get(group2).accept((Visitor)decorator);
            }
            resources.put(group2, this.customGroups.get(group2).build());
        }
        return resources;
    }

    @Override
    public String getGroup() {
        return this.group.get();
    }

    public void setGroup(String group) {
        this.group.compareAndSet(null, group);
    }

    @Override
    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        this.name.compareAndSet(null, name);
    }

    @Override
    public String getVersion() {
        return this.version.get();
    }

    public void setVersion(String version) {
        this.version.compareAndSet(null, version);
    }

    public void addLabel(Label label) {
        this.labels.put(label.getKey(), label.getValue());
    }

    public void setLabels(Map<String, String> labels) {
        labels.entrySet().stream().map(e -> new Label((String)e.getKey(), (String)e.getValue())).forEach(l -> this.addLabel((Label)l));
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }
}

