/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k;

import io.ap4k.Configurators;
import io.ap4k.Handler;
import io.ap4k.Resources;
import io.ap4k.SessionListener;
import io.ap4k.SessionWriter;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public class Session {
    private static Session INSTANCE;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicBoolean generated = new AtomicBoolean();
    private final Set<Handler> handlers = new LinkedHashSet<Handler>();
    private final Configurators configurators = new Configurators();
    private final Resources resources = new Resources();
    private final Map<String, KubernetesList> generatedResources = new HashMap<String, KubernetesList>();
    private final AtomicReference<SessionWriter> writer = new AtomicReference();
    private final Set<SessionListener> listeners = new LinkedHashSet<SessionListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Session getSession() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        Class<Session> clazz = Session.class;
        synchronized (Session.class) {
            if (INSTANCE == null) {
                INSTANCE = new Session();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void clearSession() {
        INSTANCE = null;
    }

    public Configurators configurators() {
        return this.configurators;
    }

    public Resources resources() {
        return this.resources;
    }

    public Set<Handler> handlers() {
        return this.handlers;
    }

    public Map<String, KubernetesList> getGeneratedResources() {
        return this.generatedResources;
    }

    public void setWriter(SessionWriter resourceWriter) {
        this.writer.set(resourceWriter);
    }

    public boolean hasWriter() {
        return this.writer.get() != null;
    }

    public void addListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    public Map<String, String> close() {
        if (this.closed.compareAndSet(false, true)) {
            this.generate();
            SessionWriter w = this.writer.get();
            if (w == null) {
                throw new IllegalStateException("No writer has been specified!");
            }
            Map<String, String> result = w.write(this);
            this.listeners.forEach(SessionListener::onClosed);
            return result;
        }
        return new HashMap<String, String>();
    }

    private Map<String, KubernetesList> generate() {
        if (this.generated.compareAndSet(false, true)) {
            this.closed.set(true);
            this.handlers.forEach(g -> this.configurators.stream().forEach(c -> {
                if (g.canHandle(c.getClass())) {
                    g.handle(c);
                }
            }));
            this.generatedResources.putAll(this.resources.generate());
        }
        return Collections.unmodifiableMap(this.generatedResources);
    }
}

