/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.config;

import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.AzureDiskVolume;
import io.ap4k.kubernetes.config.AzureDiskVolumeFluent;
import io.ap4k.kubernetes.config.AzureDiskVolumeFluentImpl;
import io.ap4k.kubernetes.config.EditableAzureDiskVolume;

public class AzureDiskVolumeBuilder
extends AzureDiskVolumeFluentImpl<AzureDiskVolumeBuilder>
implements VisitableBuilder<AzureDiskVolume, AzureDiskVolumeBuilder> {
    AzureDiskVolumeFluent<?> fluent;
    Boolean validationEnabled;

    public AzureDiskVolumeBuilder() {
        this(true);
    }

    public AzureDiskVolumeBuilder(Boolean validationEnabled) {
        this(new AzureDiskVolume(), validationEnabled);
    }

    public AzureDiskVolumeBuilder(AzureDiskVolumeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public AzureDiskVolumeBuilder(AzureDiskVolumeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AzureDiskVolume(), validationEnabled);
    }

    public AzureDiskVolumeBuilder(AzureDiskVolumeFluent<?> fluent, AzureDiskVolume instance) {
        this(fluent, instance, true);
    }

    public AzureDiskVolumeBuilder(AzureDiskVolumeFluent<?> fluent, AzureDiskVolume instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withVolumeName(instance.getVolumeName());
        fluent.withDiskName(instance.getDiskName());
        fluent.withDiskURI(instance.getDiskURI());
        fluent.withKind(instance.getKind());
        fluent.withCachingMode(instance.getCachingMode());
        fluent.withFsType(instance.getFsType());
        fluent.withReadOnly(instance.isReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public AzureDiskVolumeBuilder(AzureDiskVolume instance) {
        this(instance, (Boolean)true);
    }

    public AzureDiskVolumeBuilder(AzureDiskVolume instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withVolumeName(instance.getVolumeName());
        this.withDiskName(instance.getDiskName());
        this.withDiskURI(instance.getDiskURI());
        this.withKind(instance.getKind());
        this.withCachingMode(instance.getCachingMode());
        this.withFsType(instance.getFsType());
        this.withReadOnly(instance.isReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public EditableAzureDiskVolume build() {
        EditableAzureDiskVolume buildable = new EditableAzureDiskVolume(this.fluent.getVolumeName(), this.fluent.getDiskName(), this.fluent.getDiskURI(), this.fluent.getKind(), this.fluent.getCachingMode(), this.fluent.getFsType(), this.fluent.isReadOnly());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureDiskVolumeBuilder that = (AzureDiskVolumeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

