/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.config;

import java.util.Objects;

public class ConfigKey<T> {
    private final String name;
    private final Class<T> type;
    private final T defaultValue;

    public ConfigKey(String name, Class<T> type) {
        this(name, type, null);
    }

    public ConfigKey(String name, Class<T> type, T defaultValue) {
        this.name = name;
        this.type = type;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getType() {
        return this.type;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigKey configKey = (ConfigKey)o;
        return Objects.equals(this.name, configKey.name) && Objects.equals(this.type, configKey.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }
}

