/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.config;

import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.annotation.ImagePullPolicy;
import io.ap4k.kubernetes.config.Container;
import io.ap4k.kubernetes.config.ContainerFluent;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.EnvBuilder;
import io.ap4k.kubernetes.config.EnvFluentImpl;
import io.ap4k.kubernetes.config.Mount;
import io.ap4k.kubernetes.config.MountBuilder;
import io.ap4k.kubernetes.config.MountFluentImpl;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.config.PortBuilder;
import io.ap4k.kubernetes.config.PortFluentImpl;
import io.ap4k.kubernetes.config.Probe;
import io.ap4k.kubernetes.config.ProbeBuilder;
import io.ap4k.kubernetes.config.ProbeFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerFluentImpl<A extends ContainerFluent<A>>
extends BaseFluent<A>
implements ContainerFluent<A> {
    private String image;
    private String name = "";
    private List<EnvBuilder> envVars = new ArrayList<EnvBuilder>();
    private String workingDir = "";
    private List<String> command = new ArrayList<String>();
    private List<String> arguments = new ArrayList<String>();
    private List<PortBuilder> ports = new ArrayList<PortBuilder>();
    private List<MountBuilder> mounts = new ArrayList<MountBuilder>();
    private ImagePullPolicy imagePullPolicy = ImagePullPolicy.IfNotPresent;
    private ProbeBuilder livenessProbe = null;
    private ProbeBuilder readinessProbe = null;

    public ContainerFluentImpl() {
    }

    public ContainerFluentImpl(Container instance) {
        this.withImage(instance.getImage());
        this.withName(instance.getName());
        this.withEnvVars(instance.getEnvVars());
        this.withWorkingDir(instance.getWorkingDir());
        this.withCommand(instance.getCommand());
        this.withArguments(instance.getArguments());
        this.withPorts(instance.getPorts());
        this.withMounts(instance.getMounts());
        this.withImagePullPolicy(instance.getImagePullPolicy());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public A withNewImage(String arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuilder arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public A withNewImage(StringBuffer arg1) {
        return this.withImage(new String(arg1));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public A withNewName(String arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuilder arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withNewName(StringBuffer arg1) {
        return this.withName(new String(arg1));
    }

    @Override
    public A withEnvVars(Env ... envVars) {
        if (this.envVars != null) {
            this.envVars.clear();
        }
        if (envVars != null) {
            for (Env item : envVars) {
                this.addToEnvVars(item);
            }
        }
        return (A)this;
    }

    @Override
    public Env[] getEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env[] buildEnvVars() {
        int size = this.envVars != null ? this.envVars.size() : 0;
        Env[] result = new Env[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.envVars) {
            result[index++] = (Env)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Env buildEnvVar(int index) {
        return this.envVars.get(index).build();
    }

    @Override
    public Env buildFirstEnvVar() {
        return this.envVars.get(0).build();
    }

    @Override
    public Env buildLastEnvVar() {
        return this.envVars.get(this.envVars.size() - 1).build();
    }

    @Override
    public Env buildMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        for (EnvBuilder item : this.envVars) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.envVars.add(index >= 0 ? index : this.envVars.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEnvVars(int index, Env item) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        EnvBuilder builder = new EnvBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.envVars.size()) {
            this.envVars.add(builder);
        } else {
            this.envVars.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEnvVars(Env ... items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnvVars(Collection<Env> items) {
        if (this.envVars == null) {
            this.envVars = new ArrayList<EnvBuilder>();
        }
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.add(builder);
            this.envVars.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnvVars(Env ... items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnvVars(Collection<Env> items) {
        for (Env item : items) {
            EnvBuilder builder = new EnvBuilder(item);
            this._visitables.remove(builder);
            if (this.envVars == null) continue;
            this.envVars.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnvVars() {
        return this.envVars != null && !this.envVars.isEmpty();
    }

    @Override
    public A addNewEnvVar(String name, String value, String secret, String configmap, String field) {
        return this.addToEnvVars(new Env(name, value, secret, configmap, field));
    }

    @Override
    public ContainerFluent.EnvVarsNested<A> addNewEnvVar() {
        return new EnvVarsNestedImpl();
    }

    @Override
    public ContainerFluent.EnvVarsNested<A> addNewEnvVarLike(Env item) {
        return new EnvVarsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.EnvVarsNested<A> setNewEnvVarLike(int index, Env item) {
        return new EnvVarsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.EnvVarsNested<A> editEnvVar(int index) {
        if (this.envVars.size() <= index) {
            throw new RuntimeException("Can't edit envVars. Index exceeds size.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public ContainerFluent.EnvVarsNested<A> editFirstEnvVar() {
        if (this.envVars.size() == 0) {
            throw new RuntimeException("Can't edit first envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(0, this.buildEnvVar(0));
    }

    @Override
    public ContainerFluent.EnvVarsNested<A> editLastEnvVar() {
        int index = this.envVars.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envVars. The list is empty.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public ContainerFluent.EnvVarsNested<A> editMatchingEnvVar(Predicate<EnvBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envVars.size(); ++i) {
            if (!predicate.apply((Object)this.envVars.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envVars. No match found.");
        }
        return this.setNewEnvVarLike(index, this.buildEnvVar(index));
    }

    @Override
    public String getWorkingDir() {
        return this.workingDir;
    }

    @Override
    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)this;
    }

    @Override
    public Boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    @Override
    public A withNewWorkingDir(String arg1) {
        return this.withWorkingDir(new String(arg1));
    }

    @Override
    public A withNewWorkingDir(StringBuilder arg1) {
        return this.withWorkingDir(new String(arg1));
    }

    @Override
    public A withNewWorkingDir(StringBuffer arg1) {
        return this.withWorkingDir(new String(arg1));
    }

    @Override
    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getCommand() {
        int size = this.command != null ? this.command.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.command) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A addNewCommand(String arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A addNewCommand(StringBuilder arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A addNewCommand(StringBuffer arg1) {
        return this.addToCommand(new String(arg1));
    }

    @Override
    public A withArguments(String ... arguments) {
        if (this.arguments != null) {
            this.arguments.clear();
        }
        if (arguments != null) {
            for (String item : arguments) {
                this.addToArguments(item);
            }
        }
        return (A)this;
    }

    @Override
    public String[] getArguments() {
        int size = this.arguments != null ? this.arguments.size() : 0;
        String[] result = new String[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (String item : this.arguments) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToArguments(int index, String item) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        this.arguments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToArguments(String ... items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToArguments(Collection<String> items) {
        if (this.arguments == null) {
            this.arguments = new ArrayList<String>();
        }
        for (String item : items) {
            this.arguments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromArguments(String ... items) {
        for (String item : items) {
            if (this.arguments == null) continue;
            this.arguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromArguments(Collection<String> items) {
        for (String item : items) {
            if (this.arguments == null) continue;
            this.arguments.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasArguments() {
        return this.arguments != null && !this.arguments.isEmpty();
    }

    @Override
    public A addNewArgument(String arg1) {
        return this.addToArguments(new String(arg1));
    }

    @Override
    public A addNewArgument(StringBuilder arg1) {
        return this.addToArguments(new String(arg1));
    }

    @Override
    public A addNewArgument(StringBuffer arg1) {
        return this.addToArguments(new String(arg1));
    }

    @Override
    public A withPorts(Port ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (Port item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Port[] getPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Port[] buildPorts() {
        int size = this.ports != null ? this.ports.size() : 0;
        Port[] result = new Port[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.ports) {
            result[index++] = (Port)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Port buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public Port buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public Port buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
        for (PortBuilder item : this.ports) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, Port item) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        PortBuilder builder = new PortBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(Port ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<Port> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<PortBuilder>();
        }
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(Port ... items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<Port> items) {
        for (Port item : items) {
            PortBuilder builder = new PortBuilder(item);
            this._visitables.remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public ContainerFluent.PortsNested<A> addNewPortLike(Port item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> setNewPortLike(int index, Port item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public ContainerFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public ContainerFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.apply((Object)this.ports.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A withMounts(Mount ... mounts) {
        if (this.mounts != null) {
            this.mounts.clear();
        }
        if (mounts != null) {
            for (Mount item : mounts) {
                this.addToMounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Mount[] getMounts() {
        int size = this.mounts != null ? this.mounts.size() : 0;
        Mount[] result = new Mount[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.mounts) {
            result[index++] = (Mount)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Mount[] buildMounts() {
        int size = this.mounts != null ? this.mounts.size() : 0;
        Mount[] result = new Mount[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (VisitableBuilder visitableBuilder : this.mounts) {
            result[index++] = (Mount)visitableBuilder.build();
        }
        return result;
    }

    @Override
    public Mount buildMount(int index) {
        return this.mounts.get(index).build();
    }

    @Override
    public Mount buildFirstMount() {
        return this.mounts.get(0).build();
    }

    @Override
    public Mount buildLastMount() {
        return this.mounts.get(this.mounts.size() - 1).build();
    }

    @Override
    public Mount buildMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMount(Predicate<MountBuilder> predicate) {
        for (MountBuilder item : this.mounts) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A addToMounts(int index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<MountBuilder>();
        }
        MountBuilder builder = new MountBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.mounts.add(index >= 0 ? index : this.mounts.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMounts(int index, Mount item) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<MountBuilder>();
        }
        MountBuilder builder = new MountBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.mounts.size()) {
            this.mounts.add(builder);
        } else {
            this.mounts.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMounts(Mount ... items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<MountBuilder>();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMounts(Collection<Mount> items) {
        if (this.mounts == null) {
            this.mounts = new ArrayList<MountBuilder>();
        }
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.add(builder);
            this.mounts.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMounts(Mount ... items) {
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.remove(builder);
            if (this.mounts == null) continue;
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMounts(Collection<Mount> items) {
        for (Mount item : items) {
            MountBuilder builder = new MountBuilder(item);
            this._visitables.remove(builder);
            if (this.mounts == null) continue;
            this.mounts.remove(builder);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMounts() {
        return this.mounts != null && !this.mounts.isEmpty();
    }

    @Override
    public A addNewMount(String name, String path, String subPath, boolean readOnly) {
        return this.addToMounts(new Mount(name, path, subPath, readOnly));
    }

    @Override
    public ContainerFluent.MountsNested<A> addNewMount() {
        return new MountsNestedImpl();
    }

    @Override
    public ContainerFluent.MountsNested<A> addNewMountLike(Mount item) {
        return new MountsNestedImpl(-1, item);
    }

    @Override
    public ContainerFluent.MountsNested<A> setNewMountLike(int index, Mount item) {
        return new MountsNestedImpl(index, item);
    }

    @Override
    public ContainerFluent.MountsNested<A> editMount(int index) {
        if (this.mounts.size() <= index) {
            throw new RuntimeException("Can't edit mounts. Index exceeds size.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public ContainerFluent.MountsNested<A> editFirstMount() {
        if (this.mounts.size() == 0) {
            throw new RuntimeException("Can't edit first mounts. The list is empty.");
        }
        return this.setNewMountLike(0, this.buildMount(0));
    }

    @Override
    public ContainerFluent.MountsNested<A> editLastMount() {
        int index = this.mounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mounts. The list is empty.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public ContainerFluent.MountsNested<A> editMatchingMount(Predicate<MountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mounts.size(); ++i) {
            if (!predicate.apply((Object)this.mounts.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mounts. No match found.");
        }
        return this.setNewMountLike(index, this.buildMount(index));
    }

    @Override
    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    @Override
    public A withImagePullPolicy(ImagePullPolicy imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    @Override
    @Deprecated
    public Probe getLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    @Override
    public A withLivenessProbe(Probe livenessProbe) {
        this._visitables.remove(this.livenessProbe);
        if (livenessProbe != null) {
            this.livenessProbe = new ProbeBuilder(livenessProbe);
            this._visitables.add(this.livenessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> withNewLivenessProbeLike(Probe item) {
        return new LivenessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe());
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ContainerFluent.LivenessProbeNested<A> editOrNewLivenessProbeLike(Probe item) {
        return this.withNewLivenessProbeLike(this.getLivenessProbe() != null ? this.getLivenessProbe() : item);
    }

    @Override
    @Deprecated
    public Probe getReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    @Override
    public A withReadinessProbe(Probe readinessProbe) {
        this._visitables.remove(this.readinessProbe);
        if (readinessProbe != null) {
            this.readinessProbe = new ProbeBuilder(readinessProbe);
            this._visitables.add(this.readinessProbe);
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNestedImpl();
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> withNewReadinessProbeLike(Probe item) {
        return new ReadinessProbeNestedImpl(item);
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe());
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : new ProbeBuilder().build());
    }

    @Override
    public ContainerFluent.ReadinessProbeNested<A> editOrNewReadinessProbeLike(Probe item) {
        return this.withNewReadinessProbeLike(this.getReadinessProbe() != null ? this.getReadinessProbe() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerFluentImpl that = (ContainerFluentImpl)o;
        if (this.image != null ? !this.image.equals(that.image) : that.image != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.envVars != null ? !this.envVars.equals(that.envVars) : that.envVars != null) {
            return false;
        }
        if (this.workingDir != null ? !this.workingDir.equals(that.workingDir) : that.workingDir != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.arguments != null ? !this.arguments.equals(that.arguments) : that.arguments != null) {
            return false;
        }
        if (this.ports != null ? !this.ports.equals(that.ports) : that.ports != null) {
            return false;
        }
        if (this.mounts != null ? !this.mounts.equals(that.mounts) : that.mounts != null) {
            return false;
        }
        if (this.imagePullPolicy != null ? !this.imagePullPolicy.equals((Object)that.imagePullPolicy) : that.imagePullPolicy != null) {
            return false;
        }
        if (this.livenessProbe != null ? !this.livenessProbe.equals(that.livenessProbe) : that.livenessProbe != null) {
            return false;
        }
        return !(this.readinessProbe != null ? !this.readinessProbe.equals(that.readinessProbe) : that.readinessProbe != null);
    }

    public class ReadinessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.ReadinessProbeNested<N>>
    implements ContainerFluent.ReadinessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        ReadinessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        ReadinessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withReadinessProbe(this.builder.build());
        }

        @Override
        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class LivenessProbeNestedImpl<N>
    extends ProbeFluentImpl<ContainerFluent.LivenessProbeNested<N>>
    implements ContainerFluent.LivenessProbeNested<N>,
    Nested<N> {
        private final ProbeBuilder builder;

        LivenessProbeNestedImpl(Probe item) {
            this.builder = new ProbeBuilder(this, item);
        }

        LivenessProbeNestedImpl() {
            this.builder = new ProbeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.withLivenessProbe(this.builder.build());
        }

        @Override
        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class MountsNestedImpl<N>
    extends MountFluentImpl<ContainerFluent.MountsNested<N>>
    implements ContainerFluent.MountsNested<N>,
    Nested<N> {
        private final MountBuilder builder;
        private final int index;

        MountsNestedImpl(int index, Mount item) {
            this.index = index;
            this.builder = new MountBuilder(this, item);
        }

        MountsNestedImpl() {
            this.index = -1;
            this.builder = new MountBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToMounts(this.index, this.builder.build());
        }

        @Override
        public N endMount() {
            return this.and();
        }
    }

    public class PortsNestedImpl<N>
    extends PortFluentImpl<ContainerFluent.PortsNested<N>>
    implements ContainerFluent.PortsNested<N>,
    Nested<N> {
        private final PortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, Port item) {
            this.index = index;
            this.builder = new PortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new PortBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class EnvVarsNestedImpl<N>
    extends EnvFluentImpl<ContainerFluent.EnvVarsNested<N>>
    implements ContainerFluent.EnvVarsNested<N>,
    Nested<N> {
        private final EnvBuilder builder;
        private final int index;

        EnvVarsNestedImpl(int index, Env item) {
            this.index = index;
            this.builder = new EnvBuilder(this, item);
        }

        EnvVarsNestedImpl() {
            this.index = -1;
            this.builder = new EnvBuilder(this);
        }

        @Override
        public N and() {
            return (N)ContainerFluentImpl.this.setToEnvVars(this.index, this.builder.build());
        }

        @Override
        public N endEnvVar() {
            return this.and();
        }
    }
}

