/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.config;

import io.ap4k.kubernetes.annotation.ImagePullPolicy;
import io.ap4k.kubernetes.annotation.ServiceType;
import io.ap4k.kubernetes.config.Annotation;
import io.ap4k.kubernetes.config.ApplicationConfiguration;
import io.ap4k.kubernetes.config.AwsElasticBlockStoreVolume;
import io.ap4k.kubernetes.config.AzureDiskVolume;
import io.ap4k.kubernetes.config.AzureFileVolume;
import io.ap4k.kubernetes.config.ConfigKey;
import io.ap4k.kubernetes.config.ConfigMapVolume;
import io.ap4k.kubernetes.config.Container;
import io.ap4k.kubernetes.config.Env;
import io.ap4k.kubernetes.config.GitRepoVolume;
import io.ap4k.kubernetes.config.Label;
import io.ap4k.kubernetes.config.Mount;
import io.ap4k.kubernetes.config.PersistentVolumeClaimVolume;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.config.Probe;
import io.ap4k.kubernetes.config.SecretVolume;
import io.ap4k.project.Project;
import java.util.Map;

public class KubernetesConfig
extends ApplicationConfiguration {
    private Container[] initContainers = new Container[0];
    private Label[] labels = new Label[0];
    private Annotation[] annotations = new Annotation[0];
    private Env[] envVars = new Env[0];
    private String workingDir = "";
    private String[] command = new String[0];
    private String[] arguments = new String[0];
    private int replicas = 1;
    private String serviceAccount = "";
    private String host = "";
    private Port[] ports = new Port[0];
    private ServiceType serviceType = ServiceType.ClusterIP;
    private PersistentVolumeClaimVolume[] pvcVolumes = new PersistentVolumeClaimVolume[0];
    private SecretVolume[] secretVolumes = new SecretVolume[0];
    private ConfigMapVolume[] configMapVolumes = new ConfigMapVolume[0];
    private GitRepoVolume[] gitRepoVolumes = new GitRepoVolume[0];
    private AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes = new AwsElasticBlockStoreVolume[0];
    private AzureDiskVolume[] azureDiskVolumes = new AzureDiskVolume[0];
    private AzureFileVolume[] azureFileVolumes = new AzureFileVolume[0];
    private Mount[] mounts = new Mount[0];
    private ImagePullPolicy imagePullPolicy = ImagePullPolicy.IfNotPresent;
    private Probe livenessProbe = null;
    private Probe readinessProbe = null;
    private Container[] sidecars = new Container[0];
    private boolean autoDeployEnabled = false;

    public KubernetesConfig() {
    }

    public KubernetesConfig(Project project, Map<ConfigKey, Object> attributes, String group, String name, String version, Container[] initContainers, Label[] labels, Annotation[] annotations, Env[] envVars, String workingDir, String[] command, String[] arguments, int replicas, String serviceAccount, String host, Port[] ports, ServiceType serviceType, PersistentVolumeClaimVolume[] pvcVolumes, SecretVolume[] secretVolumes, ConfigMapVolume[] configMapVolumes, GitRepoVolume[] gitRepoVolumes, AwsElasticBlockStoreVolume[] awsElasticBlockStoreVolumes, AzureDiskVolume[] azureDiskVolumes, AzureFileVolume[] azureFileVolumes, Mount[] mounts, ImagePullPolicy imagePullPolicy, Probe livenessProbe, Probe readinessProbe, Container[] sidecars, boolean autoDeployEnabled) {
        super(project, attributes, group, name, version);
        this.initContainers = initContainers != null ? initContainers : new Container[]{};
        this.labels = labels != null ? labels : new Label[]{};
        this.annotations = annotations != null ? annotations : new Annotation[]{};
        this.envVars = envVars != null ? envVars : new Env[]{};
        this.workingDir = workingDir != null ? workingDir : "";
        this.command = command != null ? command : new String[]{};
        this.arguments = arguments != null ? arguments : new String[]{};
        this.replicas = replicas;
        this.serviceAccount = serviceAccount != null ? serviceAccount : "";
        this.host = host != null ? host : "";
        this.ports = ports != null ? ports : new Port[]{};
        this.serviceType = serviceType != null ? serviceType : ServiceType.ClusterIP;
        this.pvcVolumes = pvcVolumes != null ? pvcVolumes : new PersistentVolumeClaimVolume[]{};
        this.secretVolumes = secretVolumes != null ? secretVolumes : new SecretVolume[]{};
        this.configMapVolumes = configMapVolumes != null ? configMapVolumes : new ConfigMapVolume[]{};
        this.gitRepoVolumes = gitRepoVolumes != null ? gitRepoVolumes : new GitRepoVolume[]{};
        this.awsElasticBlockStoreVolumes = awsElasticBlockStoreVolumes != null ? awsElasticBlockStoreVolumes : new AwsElasticBlockStoreVolume[]{};
        this.azureDiskVolumes = azureDiskVolumes != null ? azureDiskVolumes : new AzureDiskVolume[]{};
        this.azureFileVolumes = azureFileVolumes != null ? azureFileVolumes : new AzureFileVolume[]{};
        this.mounts = mounts != null ? mounts : new Mount[]{};
        this.imagePullPolicy = imagePullPolicy != null ? imagePullPolicy : ImagePullPolicy.IfNotPresent;
        this.livenessProbe = livenessProbe != null ? livenessProbe : null;
        this.readinessProbe = readinessProbe != null ? readinessProbe : null;
        this.sidecars = sidecars != null ? sidecars : new Container[]{};
        this.autoDeployEnabled = autoDeployEnabled;
    }

    public Container[] getInitContainers() {
        return this.initContainers;
    }

    public Label[] getLabels() {
        return this.labels;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Env[] getEnvVars() {
        return this.envVars;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public String[] getCommand() {
        return this.command;
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getReplicas() {
        return this.replicas;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public String getHost() {
        return this.host;
    }

    public Port[] getPorts() {
        return this.ports;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public PersistentVolumeClaimVolume[] getPvcVolumes() {
        return this.pvcVolumes;
    }

    public SecretVolume[] getSecretVolumes() {
        return this.secretVolumes;
    }

    public ConfigMapVolume[] getConfigMapVolumes() {
        return this.configMapVolumes;
    }

    public GitRepoVolume[] getGitRepoVolumes() {
        return this.gitRepoVolumes;
    }

    public AwsElasticBlockStoreVolume[] getAwsElasticBlockStoreVolumes() {
        return this.awsElasticBlockStoreVolumes;
    }

    public AzureDiskVolume[] getAzureDiskVolumes() {
        return this.azureDiskVolumes;
    }

    public AzureFileVolume[] getAzureFileVolumes() {
        return this.azureFileVolumes;
    }

    public Mount[] getMounts() {
        return this.mounts;
    }

    public ImagePullPolicy getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public Probe getLivenessProbe() {
        return this.livenessProbe;
    }

    public Probe getReadinessProbe() {
        return this.readinessProbe;
    }

    public Container[] getSidecars() {
        return this.sidecars;
    }

    public boolean isAutoDeployEnabled() {
        return this.autoDeployEnabled;
    }
}

