/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.config;

import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.kubernetes.config.EditableProbe;
import io.ap4k.kubernetes.config.Probe;
import io.ap4k.kubernetes.config.ProbeFluent;
import io.ap4k.kubernetes.config.ProbeFluentImpl;

public class ProbeBuilder
extends ProbeFluentImpl<ProbeBuilder>
implements VisitableBuilder<Probe, ProbeBuilder> {
    ProbeFluent<?> fluent;
    Boolean validationEnabled;

    public ProbeBuilder() {
        this(true);
    }

    public ProbeBuilder(Boolean validationEnabled) {
        this(new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Probe(), validationEnabled);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance) {
        this(fluent, instance, true);
    }

    public ProbeBuilder(ProbeFluent<?> fluent, Probe instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withHttpAction(instance.getHttpAction());
        fluent.withExecAction(instance.getExecAction());
        fluent.withTcpSocketAction(instance.getTcpSocketAction());
        fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        fluent.withPeriodSeconds(instance.getPeriodSeconds());
        fluent.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public ProbeBuilder(Probe instance) {
        this(instance, (Boolean)true);
    }

    public ProbeBuilder(Probe instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withHttpAction(instance.getHttpAction());
        this.withExecAction(instance.getExecAction());
        this.withTcpSocketAction(instance.getTcpSocketAction());
        this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
        this.withPeriodSeconds(instance.getPeriodSeconds());
        this.withTimeoutSeconds(instance.getTimeoutSeconds());
        this.validationEnabled = validationEnabled;
    }

    public EditableProbe build() {
        EditableProbe buildable = new EditableProbe(this.fluent.getHttpAction(), this.fluent.getExecAction(), this.fluent.getTcpSocketAction(), this.fluent.getInitialDelaySeconds(), this.fluent.getPeriodSeconds(), this.fluent.getTimeoutSeconds());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProbeBuilder that = (ProbeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

