/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.configurator;

import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.Configurator;
import io.ap4k.kubernetes.config.KubernetesConfigFluent;
import io.ap4k.kubernetes.config.Port;
import java.util.Objects;

@Description(value="adds a port to all containers.")
public class AddPort
extends Configurator<KubernetesConfigFluent> {
    private final Port port;

    public AddPort(Port port) {
        this.port = port;
    }

    public void visit(KubernetesConfigFluent config) {
        if (!this.hasPort(config)) {
            config.addToPorts(this.port);
        }
    }

    private boolean hasPort(KubernetesConfigFluent config) {
        for (Port p : config.getPorts()) {
            if (p.getContainerPort() != this.port.getContainerPort()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AddPort addPort = (AddPort)((Object)o);
        return Objects.equals(this.port, addPort.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }
}

