/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.configurator;

import io.ap4k.deps.kubernetes.api.builder.Predicate;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.Configurator;
import io.ap4k.kubernetes.config.KubernetesConfigFluent;
import io.ap4k.kubernetes.config.PortBuilder;

@Description(value="Sets the path for the matching port.")
public class SetPortPath
extends Configurator<KubernetesConfigFluent<?>> {
    private final Predicate<PortBuilder> predicate = p -> p.getName().equals(name);
    private final String path;

    public SetPortPath(String name, String path) {
        this.path = path;
    }

    public void visit(KubernetesConfigFluent<?> config) {
        if (config.hasMatchingPort(this.predicate).booleanValue()) {
            config.editMatchingPort(this.predicate).withPath(this.path);
        }
    }
}

