/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.deps.kubernetes.api.model.ExecAction;
import io.ap4k.deps.kubernetes.api.model.HTTPGetAction;
import io.ap4k.deps.kubernetes.api.model.IntOrString;
import io.ap4k.deps.kubernetes.api.model.ProbeBuilder;
import io.ap4k.deps.kubernetes.api.model.TCPSocketAction;
import io.ap4k.kubernetes.config.Probe;
import io.ap4k.kubernetes.decorator.ApplicationContainerDecorator;
import io.ap4k.utils.Strings;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;

public abstract class AbstractAddProbeDecorator
extends ApplicationContainerDecorator<ContainerFluent<?>> {
    protected final Probe probe;

    public AbstractAddProbeDecorator(String containerName, Probe probe) {
        super(null, containerName);
        this.probe = probe;
    }

    public AbstractAddProbeDecorator(String deploymentName, String containerName, Probe probe) {
        super(deploymentName, containerName);
        this.probe = probe;
    }

    protected io.ap4k.deps.kubernetes.api.model.Probe convert(Probe probe) {
        return ((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)((ProbeBuilder)new ProbeBuilder().withExec(this.execAction(probe))).withHttpGet(this.httpGetAction(probe))).withTcpSocket(this.tcpSocketAction(probe))).withInitialDelaySeconds(Integer.valueOf(probe.getInitialDelaySeconds()))).withPeriodSeconds(Integer.valueOf(probe.getPeriodSeconds()))).withTimeoutSeconds(Integer.valueOf(probe.getTimeoutSeconds()))).build();
    }

    protected ExecAction execAction(Probe probe) {
        if (Strings.isNullOrEmpty(probe.getExecAction())) {
            return null;
        }
        return new ExecAction(Arrays.asList(probe.getExecAction().split(" ")));
    }

    protected HTTPGetAction httpGetAction(Probe probe) {
        if (Strings.isNullOrEmpty(probe.getHttpAction())) {
            return null;
        }
        try {
            URI uri = new URI(probe.getHttpAction());
            return new HTTPGetAction(null, Collections.emptyList(), uri.getPath(), new IntOrString(Integer.valueOf(uri.getPort())), uri.getScheme().toUpperCase());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    protected TCPSocketAction tcpSocketAction(Probe probe) {
        if (Strings.isNullOrEmpty(probe.getTcpSocketAction())) {
            return null;
        }
        String[] parts = probe.getTcpSocketAction().split(":");
        if (parts.length != 2) {
            throw new RuntimeException("Invalid format for tcp socket action! Expected: <host>:<port>. Found:" + probe.getTcpSocketAction() + ".");
        }
        return new TCPSocketAction(parts[0], new IntOrString(parts[1]));
    }
}

