/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.ContainerBuilder;
import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.annotation.Protocol;
import io.ap4k.kubernetes.config.Port;
import io.ap4k.kubernetes.decorator.ApplicationContainerDecorator;
import java.util.Objects;

@Description(value="Add port to to the specified container(s).")
public class AddPortDecorator
extends ApplicationContainerDecorator<ContainerBuilder> {
    private final Port port;

    public AddPortDecorator(Port port) {
        this(ANY, ANY, port);
    }

    public AddPortDecorator(String deployment, String container, Port port) {
        super(deployment, container);
        this.port = port;
    }

    @Override
    public void andThenVisit(ContainerBuilder container) {
        if (container.buildPorts().stream().anyMatch(p -> p.getName().equals(this.port.getName()))) {
            ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.editMatchingPort(p -> p.getName().equals(this.port.getName())).withHostPort(this.port.getHostPort() > 0 ? Integer.valueOf(this.port.getHostPort()) : null)).withContainerPort(Integer.valueOf(this.port.getContainerPort()))).withProtocol(this.port.getProtocol() != null ? this.port.getProtocol().name() : Protocol.TCP.name())).endPort();
        } else {
            ((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)((ContainerFluent.PortsNested)container.addNewPort().withName(this.port.getName())).withHostPort(this.port.getHostPort() > 0 ? Integer.valueOf(this.port.getHostPort()) : null)).withContainerPort(Integer.valueOf(this.port.getContainerPort()))).withProtocol(this.port.getProtocol() != null ? this.port.getProtocol().name() : Protocol.TCP.name())).endPort();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddPortDecorator addPortDecorator = (AddPortDecorator)o;
        return Objects.equals(this.port, addPortDecorator.port);
    }

    public int hashCode() {
        return Objects.hash(this.port);
    }
}

