/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.config.Probe;
import io.ap4k.kubernetes.decorator.AbstractAddProbeDecorator;
import io.ap4k.utils.Strings;

@Description(value="Add a readiness probe to all containers.")
public class AddReadinessProbeDecorator
extends AbstractAddProbeDecorator {
    public AddReadinessProbeDecorator(String containerName, Probe probe) {
        super(containerName, probe);
    }

    public AddReadinessProbeDecorator(String deploymentName, String containerName, Probe probe) {
        super(deploymentName, containerName, probe);
    }

    @Override
    public void andThenVisit(ContainerFluent<?> container) {
        if (this.probe == null) {
            return;
        }
        if (Strings.isNullOrEmpty(this.probe.getExecAction()) && Strings.isNullOrEmpty(this.probe.getHttpAction()) && Strings.isNullOrEmpty(this.probe.getTcpSocketAction())) {
            return;
        }
        ((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)((ContainerFluent.ReadinessProbeNested)container.withNewReadinessProbe().withExec(this.execAction(this.probe))).withHttpGet(this.httpGetAction(this.probe))).withTcpSocket(this.tcpSocketAction(this.probe))).withInitialDelaySeconds(Integer.valueOf(this.probe.getInitialDelaySeconds()))).withPeriodSeconds(Integer.valueOf(this.probe.getPeriodSeconds()))).withTimeoutSeconds(Integer.valueOf(this.probe.getTimeoutSeconds()))).endReadinessProbe();
    }
}

