/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.builder.Builder;
import io.ap4k.deps.kubernetes.api.builder.TypedVisitor;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;
import io.ap4k.deps.kubernetes.api.builder.Visitor;
import io.ap4k.deps.kubernetes.api.model.ContainerBuilder;
import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.deps.kubernetes.api.model.ObjectMeta;
import io.ap4k.kubernetes.decorator.Decorator;
import io.ap4k.utils.Generics;
import io.ap4k.utils.Metadata;
import io.ap4k.utils.Strings;
import java.util.Optional;

public abstract class ApplicationContainerDecorator<T>
extends Decorator<VisitableBuilder> {
    public static final String ANY = null;
    private final String deploymentName;
    private final String containerName;
    private final DeploymentVisitor deploymentVisitor = new DeploymentVisitor();
    private final ContainerVisitor containerVisitor = new ContainerVisitor();

    public ApplicationContainerDecorator() {
        this(null, null);
    }

    public ApplicationContainerDecorator(String containerName) {
        this(null, containerName);
    }

    public ApplicationContainerDecorator(String deploymentName, String containerName) {
        this.deploymentName = deploymentName;
        this.containerName = containerName;
    }

    public void visit(VisitableBuilder builder) {
        Optional<ObjectMeta> objectMeta = Metadata.getMetadata((Builder)builder);
        if (!objectMeta.isPresent()) {
            return;
        }
        if (Strings.isNullOrEmpty(this.deploymentName) || objectMeta.map(m -> m.getName()).filter(s -> s.equals(this.deploymentName)).isPresent()) {
            builder.accept((Visitor)this.deploymentVisitor);
        }
    }

    protected boolean isApplicable(ContainerFluent<?> container) {
        return Strings.isNullOrEmpty(this.containerName) || this.containerName.equals(container.getName());
    }

    public abstract void andThenVisit(T var1);

    private class ContainerVisitor
    extends TypedVisitor<T> {
        private ContainerVisitor() {
        }

        public void visit(T item) {
            ApplicationContainerDecorator.this.andThenVisit(item);
        }

        public Class<T> getType() {
            return Generics.getTypeArguments(ApplicationContainerDecorator.class, ApplicationContainerDecorator.this.getClass()).get(0);
        }
    }

    private class DeploymentVisitor
    extends TypedVisitor<ContainerBuilder> {
        private DeploymentVisitor() {
        }

        public void visit(ContainerBuilder container) {
            if (!ApplicationContainerDecorator.this.isApplicable((ContainerFluent<?>)container)) {
                return;
            }
            container.accept((Visitor)ApplicationContainerDecorator.this.containerVisitor);
        }
    }
}

