/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.decorator.ApplicationContainerDecorator;

@Description(value="A decorator that applies the command args to the application container.")
public class ApplyArgsDecorator
extends ApplicationContainerDecorator<ContainerFluent> {
    private final String[] argument;

    public ApplyArgsDecorator(String containerName, String ... argument) {
        super(null, containerName);
        this.argument = argument;
    }

    public ApplyArgsDecorator(String deploymentName, String containerName, String ... argument) {
        super(deploymentName, containerName);
        this.argument = argument;
    }

    @Override
    public void andThenVisit(ContainerFluent container) {
        if (this.isApplicable(container) && this.argument != null && this.argument.length > 0) {
            container.withArgs(this.argument);
        }
    }
}

