/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.ContainerFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.decorator.ApplicationContainerDecorator;

@Description(value="A decorator that applies the command to the application container.")
public class ApplyCommandDecorator
extends ApplicationContainerDecorator<ContainerFluent> {
    private final String[] command;

    public ApplyCommandDecorator(String containerName, String ... command) {
        super(null, containerName);
        this.command = command;
    }

    public ApplyCommandDecorator(String deployment, String container, String ... command) {
        super(deployment, container);
        this.command = command;
    }

    @Override
    public void andThenVisit(ContainerFluent container) {
        if (this.isApplicable(container) && this.command != null && this.command.length > 0) {
            container.withCommand(this.command);
        }
    }
}

