/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.kubernetes.decorator;

import io.ap4k.deps.kubernetes.api.model.apps.DeploymentSpecFluent;
import io.ap4k.doc.Description;
import io.ap4k.kubernetes.decorator.ApplicationResourceDecorator;

@Description(value="Apply the number of replicas to the DeploymentSpec.")
public class ApplyReplicasDecorator
extends ApplicationResourceDecorator<DeploymentSpecFluent> {
    private final int replicas;

    public ApplyReplicasDecorator(int replicas) {
        this(ANY, replicas);
    }

    public ApplyReplicasDecorator(String deploymentName, int replicas) {
        super(deploymentName);
        this.replicas = replicas;
    }

    @Override
    public void andThenVisit(DeploymentSpecFluent deploymentSpec) {
        if (this.replicas > 0) {
            deploymentSpec.withReplicas(Integer.valueOf(this.replicas));
        }
    }
}

