/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.processor;

import io.ap4k.Ap4kException;
import io.ap4k.Session;
import io.ap4k.WithProject;
import io.ap4k.deps.kubernetes.api.model.HasMetadata;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.deps.kubernetes.api.model.KubernetesResource;
import io.ap4k.processor.AptWriter;
import io.ap4k.project.AptProjectFactory;
import io.ap4k.utils.Serialization;
import io.ap4k.utils.Urls;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public abstract class AbstractAnnotationProcessor
extends AbstractProcessor
implements WithProject {
    protected static final String PACKAGE = "";
    protected static final String PROJECT = "META-INF/ap4k/.project.%s";
    protected static final String JSON = "json";
    protected static final String YML = "yml";
    protected static final String TMP = "tmp";
    protected static final String DOT = ".";

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        Session session;
        super.init(processingEnv);
        if (!this.projectExists()) {
            this.setProject(AptProjectFactory.create(processingEnv));
        }
        if (!(session = Session.getSession()).hasWriter()) {
            session.setWriter(new AptWriter(processingEnv));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<HasMetadata> read(String path) {
        try {
            FileObject fileObject = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, PACKAGE, path);
            try (InputStream is = fileObject.openInputStream();){
                KubernetesResource resource = Serialization.unmarshal(is, KubernetesResource.class);
                if (resource instanceof KubernetesList) {
                    List list = ((KubernetesList)resource).getItems();
                    return list;
                }
                if (resource instanceof HasMetadata) {
                    List<HasMetadata> list = Arrays.asList((HasMetadata)resource);
                    return list;
                }
                List<HasMetadata> list = Collections.emptyList();
                return list;
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, path + " JSON not found.");
            return null;
        }
    }

    public Path getOutputDirectory() {
        try {
            FileObject project = this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, PACKAGE, String.format(PROJECT, TMP));
            return Paths.get(Urls.toFile(project.toUri().toURL()).getParentFile().getAbsolutePath(), new String[0]);
        }
        catch (IOException e) {
            throw Ap4kException.launderThrowable(e);
        }
    }
}

