/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.processor;

import io.ap4k.Session;
import io.ap4k.SessionWriter;
import io.ap4k.WithProject;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.project.Project;
import io.ap4k.utils.Serialization;
import java.io.IOException;
import java.io.Writer;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

public class AptWriter
implements SessionWriter,
WithProject {
    protected static final String PACKAGE = "";
    protected static final String FILENAME = "%s.%s";
    protected static final String CONFIG = ".config/%s.%s";
    protected static final String PROJECT = "META-INF/ap4k/.project.%s";
    protected static final String[] STRIP = new String[]{"^Editable", "Config$"};
    protected static final String JSON = "json";
    protected static final String YML = "yml";
    protected static final String TMP = "tmp";
    protected static final String DOT = ".";
    private final ProcessingEnvironment processingEnv;

    public AptWriter(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    @Override
    public Map<String, String> write(Session session) {
        session.close();
        Map<String, KubernetesList> resources = session.getGeneratedResources();
        Set<? extends Configuration> configurations = session.configurators().toSet();
        resources.forEach((g, l) -> this.write((String)g, (KubernetesList)l));
        configurations.forEach(c -> this.write((Configuration)c));
        this.write(this.getProject());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map.Entry<String, String> write(Configuration config) {
        try {
            String s;
            String name = config.getClass().getSimpleName();
            String[] stringArray = STRIP;
            int n = stringArray.length;
            for (int n2 = 0; n2 < n; name = name.replaceAll(s, PACKAGE), ++n2) {
                s = stringArray[n2];
            }
            name = name.toLowerCase();
            FileObject yml = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, PACKAGE, this.getProject().getAp4kOutputDir() + "/" + String.format(CONFIG, name, YML), new Element[0]);
            try (Writer writer = yml.openWriter();){
                String value = Serialization.asYaml(config);
                writer.write(value);
                AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(yml.toString(), value);
                return simpleEntry;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing resources");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map.Entry<String, String> write(Project project) {
        try {
            FileObject yml = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, PACKAGE, String.format(PROJECT, YML), new Element[0]);
            try (Writer writer = yml.openWriter();){
                String value = Serialization.asYaml(project);
                writer.write(value);
                AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(yml.toString(), value);
                return simpleEntry;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing resources");
        }
    }

    @Override
    public Map<String, String> write(String group, KubernetesList list) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            FileObject json = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, PACKAGE, this.getProject().getAp4kOutputDir() + "/" + String.format(FILENAME, group, JSON), new Element[0]);
            try (Writer writer = json.openWriter();){
                String jsonValue = Serialization.asJson(list);
                writer.write(jsonValue);
                result.put(json.getName(), jsonValue);
            }
            FileObject yml = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, PACKAGE, this.getProject().getAp4kOutputDir() + "/" + String.format(FILENAME, group, YML), new Element[0]);
            try (Writer writer = yml.openWriter();){
                String yamlValue = Serialization.asYaml(list);
                writer.write(yamlValue);
                result.put(yml.getName(), yamlValue);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing resources");
        }
        return null;
    }
}

