/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.processor;

import io.ap4k.SessionWriter;
import io.ap4k.WithProject;
import io.ap4k.deps.kubernetes.api.model.KubernetesList;
import io.ap4k.kubernetes.config.Configuration;
import io.ap4k.project.Project;
import io.ap4k.utils.Serialization;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;

public class SimpleFileWriter
implements SessionWriter,
WithProject {
    private final Path outputdir;
    private final boolean doWrite;

    public SimpleFileWriter(Path outputdir) {
        this(outputdir, true);
    }

    public SimpleFileWriter(Path outputdir, boolean doWrite) {
        this.outputdir = outputdir;
        this.doWrite = doWrite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map.Entry<String, String> write(Configuration config) {
        try {
            String s;
            String name = config.getClass().getSimpleName();
            String[] stringArray = STRIP;
            int n = stringArray.length;
            for (int n2 = 0; n2 < n; name = name.replaceAll(s, ""), ++n2) {
                s = stringArray[n2];
            }
            name = name.toLowerCase();
            Path yml = this.outputdir.resolve(String.format(".config/%s.%s", name, "yml"));
            String value = Serialization.asYaml(config);
            if (!this.doWrite) return new AbstractMap.SimpleEntry<String, String>(yml.toString(), value);
            yml.toFile().getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(yml.toFile());){
                writer.write(value);
                AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(yml.toString(), value);
                return simpleEntry;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing resources");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map.Entry<String, String> write(Project project) {
        try {
            Path yml = this.outputdir.resolve(String.format(".project.%s", "yml"));
            String value = Serialization.asYaml(project);
            if (!this.doWrite) return new AbstractMap.SimpleEntry<String, String>(yml.toString(), value);
            yml.toFile().getParentFile().mkdirs();
            try (FileWriter writer = new FileWriter(yml.toFile());){
                writer.write(value);
                AbstractMap.SimpleEntry<String, String> simpleEntry = new AbstractMap.SimpleEntry<String, String>(yml.toString(), value);
                return simpleEntry;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing resources");
        }
    }

    @Override
    public Map<String, String> write(String group, KubernetesList list) {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            Path json = this.outputdir.resolve(String.format("%s.%s", group, "json"));
            String jsonValue = Serialization.asJson(list);
            if (this.doWrite) {
                json.toFile().getParentFile().mkdirs();
                try (FileWriter writer = new FileWriter(json.toFile());){
                    writer.write(jsonValue);
                    result.put(json.toString(), jsonValue);
                }
            } else {
                result.put(json.toString(), jsonValue);
            }
            Path yml = this.outputdir.resolve(String.format("%s.%s", group, "yml"));
            String yamlValue = Serialization.asYaml(list);
            if (this.doWrite) {
                yml.toFile().getParentFile().mkdirs();
                try (FileWriter writer = new FileWriter(yml.toFile());){
                    writer.write(yamlValue);
                    result.put(yml.toString(), yamlValue);
                }
            } else {
                result.put(yml.toString(), yamlValue);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing resources");
        }
    }
}

