/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.project;

import io.ap4k.kubernetes.config.Configurator;
import io.ap4k.kubernetes.config.KubernetesConfigFluent;
import io.ap4k.project.Project;
import io.ap4k.utils.Strings;

public class ApplyProjectInfo
extends Configurator<KubernetesConfigFluent> {
    private static final String APP_GROUP = "app.group";
    private static final String APP_NAME = "app.name";
    private static final String APP_VERSION = "app.version";
    private static final String USER_NAME_KEY = "user.name";
    private static final String FALLBACK_USER_NAME = "default";
    private static final String DEFAULT_GROUP = System.getProperty("user.name", "default").replaceAll(" *", "");
    private final Project project;

    public ApplyProjectInfo(Project project) {
        this.project = project;
    }

    public void visit(KubernetesConfigFluent fluent) {
        fluent.withProject(this.project);
        fluent.withGroup(System.getProperty(APP_GROUP, Strings.isNotNullOrEmpty(fluent.getGroup()) ? fluent.getGroup() : DEFAULT_GROUP)).withName(System.getProperty(APP_NAME, Strings.isNotNullOrEmpty(fluent.getName()) ? fluent.getName() : this.project.getBuildInfo().getName())).withVersion(System.getProperty(APP_VERSION, Strings.isNotNullOrEmpty(fluent.getVersion()) ? fluent.getVersion() : this.project.getBuildInfo().getVersion()));
    }
}

