/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.project;

import io.ap4k.Ap4kException;
import io.ap4k.project.BuildInfo;
import io.ap4k.project.BuildInfoReader;
import io.ap4k.utils.Strings;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BazelInfoReader
implements BuildInfoReader {
    private static final String BUILD = "BUILD";
    private static final String OPEN_BRACKET = "{";
    private static final String CLOSE_BRACKET = "}";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String EQUALS = "=";
    private static final String DASH = "-";
    private static final String DOT = ".";
    private static final String JAVA_BINARY = "java_binary";
    private static final String NAME = "name";
    private static final Pattern NAME_AND_VERSION = Pattern.compile("(?<name>[^ ]+)-(?<version>[0-9\\.]+)");
    private static final String BAZEL_BIN = "bazel-bin";
    private static final String BAZEL_OUT = "bazel-out";

    @Override
    public int order() {
        return 300;
    }

    @Override
    public boolean isApplicable(Path root) {
        return root.resolve(BUILD).toFile().exists();
    }

    @Override
    public BuildInfo getInfo(Path root) {
        Path build = root.resolve(BUILD);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(BazelInfoReader.readBuild(build));
        String name = properties.getOrDefault(NAME, properties.getOrDefault(NAME, root.getFileName().toString()));
        String version = (String)properties.get("version");
        String extension = properties.getOrDefault("extension", "jar");
        String classifier = (String)properties.get("classifier");
        String destinationDir = properties.getOrDefault("DESTINATION_DIR", BAZEL_BIN);
        Path outputDir = root.resolve(destinationDir);
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (Strings.isNotNullOrEmpty(version)) {
            sb.append(DASH).append(version);
        }
        if (Strings.isNotNullOrEmpty(classifier)) {
            sb.append(DASH).append(classifier);
        }
        sb.append(DOT).append(extension);
        return new BuildInfo(name, version, extension, outputDir.resolve(sb.toString()), root.resolve(BAZEL_OUT));
    }

    protected static Map<String, String> readBuild(Path path) {
        AtomicBoolean inJavaBinary = new AtomicBoolean();
        AtomicInteger quotes = new AtomicInteger(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            Files.lines(path).map(l -> l.replaceAll("[ ]*", "")).forEach(l -> {
                if (l.startsWith(JAVA_BINARY)) {
                    inJavaBinary.set(true);
                }
                if (l.contains(OPEN_BRACKET)) {
                    quotes.incrementAndGet();
                }
                if (l.contains(CLOSE_BRACKET)) {
                    quotes.decrementAndGet();
                }
                if (quotes.get() == 0) {
                    inJavaBinary.set(false);
                }
                if ((inJavaBinary.get() || quotes.get() == 0) && l.contains(EQUALS)) {
                    String key = l.substring(0, l.lastIndexOf(EQUALS));
                    String value = l.substring(l.lastIndexOf(EQUALS) + 1).replaceAll(DOUBLE_QUOTE, "").replaceAll(",$", "");
                    Matcher matcher = NAME_AND_VERSION.matcher(value);
                    if (key.equals(NAME) && matcher.matches()) {
                        properties.put(NAME, matcher.group(NAME));
                        properties.put("version", matcher.group("version"));
                    } else {
                        properties.put(key, value);
                    }
                }
            });
        }
        catch (IOException e) {
            throw Ap4kException.launderThrowable(e);
        }
        return properties;
    }
}

