/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.project;

import io.ap4k.project.BuildInfo;
import io.ap4k.project.BuildInfoReader;
import io.ap4k.project.Project;
import java.io.File;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;

public class FileProjectFactory {
    private static Project PROJECT = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Project create(File file) {
        if (PROJECT != null) {
            return PROJECT;
        }
        Class<FileProjectFactory> clazz = FileProjectFactory.class;
        synchronized (FileProjectFactory.class) {
            if (PROJECT == null) {
                PROJECT = FileProjectFactory.createInternal(file);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return PROJECT;
        }
    }

    private static Project createInternal(File f) {
        Path path;
        Optional<BuildInfo> info = FileProjectFactory.getProjectInfo(path);
        for (path = f.toPath(); path != null && !info.isPresent(); path = path.getParent()) {
            info = FileProjectFactory.getProjectInfo(path);
        }
        return new Project(path, info.orElseThrow(() -> new IllegalStateException("Could not find matching project info read")));
    }

    private static Optional<BuildInfo> getProjectInfo(Path path) {
        if (path == null) {
            return Optional.empty();
        }
        return StreamSupport.stream(ServiceLoader.load(BuildInfoReader.class, FileProjectFactory.class.getClassLoader()).spliterator(), false).filter(r -> r.isApplicable(path)).sorted(Comparator.comparingInt(BuildInfoReader::order)).findFirst().map(r -> r.getInfo(path));
    }
}

