/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.project;

import io.ap4k.Ap4kException;
import io.ap4k.project.BuildInfo;
import io.ap4k.project.BuildInfoReader;
import io.ap4k.utils.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;

public class GradleInfoReader
implements BuildInfoReader {
    private static final String BUILD_GRADLE = "build.gradle";
    private static final String SETTINGS_GRADLE = "settings.gradle";
    private static final String GRADLE_PROPERTIES = "gradle.properties";
    private static final String BUILD = "build";
    private static final String LIBS = "libs";
    private static final String CLASSES = "classes";
    private static final String GROOVY = "groovy";
    private static final String JAVA = "groovy";
    private static final String MAIN = "main";
    private static final String OPEN_BRACKET = "{";
    private static final String CLOSE_BRACKET = "}";
    private static final String QUOTE = "'";
    private static final String EQUALS = "=";
    private static final String DASH = "-";
    private static final String DOT = ".";
    private static final String BASENAME = "baseName";
    private static final String SHADOW_JAR = "shadowJar";
    private static final String ROOT_PROJECT_PREFIX = "rootProject.";

    @Override
    public int order() {
        return 100;
    }

    @Override
    public boolean isApplicable(Path root) {
        return root.resolve(BUILD_GRADLE).toFile().exists();
    }

    @Override
    public BuildInfo getInfo(Path root) {
        Path buildGradle = root.resolve(BUILD_GRADLE);
        Path settingsGradle = root.resolve(SETTINGS_GRADLE);
        Path gradleProperties = root.resolve(GRADLE_PROPERTIES);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(GradleInfoReader.readSettingsGradle(settingsGradle));
        properties.putAll(GradleInfoReader.readGradleProperties(gradleProperties));
        properties.putAll(GradleInfoReader.readBuildGradle(buildGradle));
        String name = properties.getOrDefault("name", properties.getOrDefault(BASENAME, root.getFileName().toString()));
        String version = (String)properties.get("version");
        String classifier = (String)properties.get("classifier");
        String extension = properties.getOrDefault("extension", "jar");
        String destinationDir = properties.getOrDefault("DESTINATION_DIR", BUILD + File.separator + LIBS + File.separator);
        Path outputDir = root.resolve(destinationDir);
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        if (Strings.isNotNullOrEmpty(version)) {
            sb.append(DASH).append(version);
        }
        if (Strings.isNotNullOrEmpty(classifier)) {
            sb.append(DASH).append(classifier);
        }
        sb.append(DOT).append(extension);
        return new BuildInfo(name, version, extension, outputDir.resolve(sb.toString()), root.resolve(BUILD).resolve(CLASSES).resolve("groovy").resolve(MAIN));
    }

    protected static Map<String, String> readSettingsGradle(Path path) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (path.toFile().exists()) {
            try {
                Files.lines(path).map(l -> l.replaceAll("[ ]*", "")).forEach(l -> {
                    String key = l.substring(0, l.lastIndexOf(EQUALS));
                    if (key.startsWith(ROOT_PROJECT_PREFIX)) {
                        key = key.substring(ROOT_PROJECT_PREFIX.length());
                        String value = l.substring(l.lastIndexOf(EQUALS) + 1).replaceAll(QUOTE, "");
                        properties.put(key, value);
                    }
                });
            }
            catch (IOException e) {
                throw Ap4kException.launderThrowable(e);
            }
        }
        return properties;
    }

    protected static Map<String, String> readBuildGradle(Path path) {
        AtomicBoolean inJar = new AtomicBoolean();
        AtomicBoolean inShadowJar = new AtomicBoolean();
        AtomicInteger quotes = new AtomicInteger(0);
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            Files.lines(path).map(l -> l.replaceAll("[ ]*", "")).forEach(l -> {
                if (l.startsWith("jar")) {
                    inJar.set(true);
                }
                if (l.startsWith(SHADOW_JAR)) {
                    inShadowJar.set(true);
                    properties.put("classifier", "all");
                }
                if (l.contains(OPEN_BRACKET)) {
                    quotes.incrementAndGet();
                }
                if (l.contains(CLOSE_BRACKET)) {
                    quotes.decrementAndGet();
                }
                if (quotes.get() == 0) {
                    inJar.set(false);
                    inShadowJar.set(false);
                }
                if ((inShadowJar.get() || inJar.get() || quotes.get() == 0) && l.contains(EQUALS)) {
                    String key = l.substring(0, l.lastIndexOf(EQUALS));
                    String value = l.substring(l.lastIndexOf(EQUALS) + 1).replaceAll(QUOTE, "");
                    properties.put(key, value);
                }
            });
        }
        catch (IOException e) {
            throw Ap4kException.launderThrowable(e);
        }
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Map<String, String> readGradleProperties(Path gradlePropertiesPath) {
        HashMap<String, String> result = new HashMap<String, String>();
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(gradlePropertiesPath.toFile());){
            properties.load(fis);
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> result.put(String.valueOf(k), String.valueOf(v))));
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }
}

