/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.project;

import io.ap4k.project.BuildInfo;
import io.ap4k.project.BuildInfoReader;
import io.ap4k.utils.Strings;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MavenInfoReader
implements BuildInfoReader {
    private static final String ARTIFACT_ID = "artifactId";
    private static final String PACKAGING = "packaging";
    private static final String PARENT = "parent";
    private static final String POM_XML = "pom.xml";
    private static final String TARGET = "target";
    private static final String CLASSES = "classes";
    public static String OUTPUTFILE_FORMAT = "%s-%s.%s";

    @Override
    public int order() {
        return 200;
    }

    @Override
    public boolean isApplicable(Path root) {
        return root.resolve(POM_XML).toFile().exists();
    }

    @Override
    public BuildInfo getInfo(Path root) {
        Document document = MavenInfoReader.parse(root.resolve(POM_XML));
        String name = MavenInfoReader.getArtifactId(document);
        String version = MavenInfoReader.getVersion(document);
        String packaging = MavenInfoReader.getPackaging(document);
        return new BuildInfo(name, version, packaging, root.resolve(TARGET).resolve(String.format(OUTPUTFILE_FORMAT, name, version, packaging)), root.resolve(TARGET).resolve(CLASSES));
    }

    protected static Document parse(Path pom) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(pom.toFile());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read: " + pom.toAbsolutePath());
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Failed to parse: " + pom.toAbsolutePath());
        }
        catch (SAXException e) {
            throw new RuntimeException("Failed to parse: " + pom.toAbsolutePath());
        }
    }

    public static String getArtifactId(Document document) {
        return MavenInfoReader.getElement(document.getDocumentElement(), ARTIFACT_ID).map(e -> e.getTextContent()).orElseThrow(() -> new RuntimeException("Failed to read artifact id from maven project."));
    }

    public static String getVersion(Document document) {
        String version = MavenInfoReader.getElement(document.getDocumentElement(), "version").map(e -> e.getTextContent()).orElse(null);
        return Strings.isNotNullOrEmpty(version) ? version : MavenInfoReader.getParentVersion(document);
    }

    public static String getPackaging(Document document) {
        return MavenInfoReader.getElement(document.getDocumentElement(), PACKAGING).map(e -> e.getTextContent()).orElse(BuildInfo.DEFAULT_PACKAGING);
    }

    private static String getParentVersion(Document document) {
        return MavenInfoReader.getElement(document.getDocumentElement(), PARENT, "version").map(e -> e.getTextContent()).orElseThrow(() -> new RuntimeException("Failed to read parent version from maven project."));
    }

    private static Optional<Element> getChildElement(Element element, String name) {
        NodeList list = element.getElementsByTagName(name);
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (n.getNodeType() != 1 || !n.getParentNode().equals(element)) continue;
            return Optional.of((Element)n);
        }
        return Optional.empty();
    }

    private static Optional<Element> getElement(Element element, String ... names) {
        if (names.length > 1) {
            String[] remaining = new String[names.length - 1];
            System.arraycopy(names, 1, remaining, 0, names.length - 1);
            String first = names[0];
            return MavenInfoReader.getElement(MavenInfoReader.getChildElement(element, first).orElseThrow(() -> new IllegalStateException("Could not read child element: " + first)), remaining);
        }
        if (names.length == 1) {
            return MavenInfoReader.getChildElement(element, names[0]);
        }
        throw new IllegalStateException("Could not read element.");
    }
}

