/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.project;

import io.ap4k.deps.jackson.core.type.TypeReference;
import io.ap4k.project.BuildInfo;
import io.ap4k.utils.Serialization;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class Project {
    public static String DEFAULT_AP4K_OUTPUT_DIR = "META-INF/ap4k";
    private Path root;
    private String ap4kInputDir;
    private String ap4kOutputDir;
    private BuildInfo buildInfo;

    public Project() {
    }

    public Project(Path root, BuildInfo buildInfo) {
        this(root, null, DEFAULT_AP4K_OUTPUT_DIR, buildInfo);
    }

    public Project(Path root, String ap4kInputDir, String ap4kOutputDir, BuildInfo buildInfo) {
        this.root = root;
        this.ap4kInputDir = ap4kInputDir;
        this.ap4kOutputDir = ap4kOutputDir;
        this.buildInfo = buildInfo;
    }

    public Path getRoot() {
        return this.root;
    }

    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public String getAp4kInputDir() {
        return this.ap4kInputDir;
    }

    public String getAp4kOutputDir() {
        return this.ap4kOutputDir;
    }

    public Project withAp4kInputDir(String ap4kInputDir) {
        return new Project(this.root, ap4kInputDir, this.ap4kOutputDir, this.buildInfo);
    }

    public Project withAp4kOutputDir(String ap4kOutputDir) {
        return new Project(this.root, this.ap4kInputDir, ap4kOutputDir, this.buildInfo);
    }

    public Map<String, Object> parseAppResourceFile(String resourceName) throws IOException {
        Path path = this.getBuildInfo().getApplicationResourceOutputDir().resolve(resourceName);
        if (!path.toFile().exists()) {
            throw new IllegalArgumentException("No application resources file found at: " + path.toFile().getAbsolutePath());
        }
        if (resourceName.endsWith(".properties")) {
            Properties properties = new Properties();
            properties.load(new FileInputStream(path.toFile().getAbsoluteFile()));
            return properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
        }
        if (resourceName.endsWith(".yaml") || resourceName.endsWith(".yml")) {
            return (Map)Serialization.yamlMapper().readValue((InputStream)new FileInputStream(path.toFile().getAbsoluteFile()), (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        throw new IllegalArgumentException("resource type is not supported");
    }
}

