/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.utils;

import io.ap4k.kubernetes.config.KubernetesConfig;
import io.ap4k.kubernetes.config.Port;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class Ports {
    private static final List<String> HTTP_PORT_NAMES = Arrays.asList("http", "https", "web");
    private static final List<Integer> HTTP_PORT_NUMBERS = Arrays.asList(80, 443, 8080, 8443);

    public static Optional<Port> getHttpPort(KubernetesConfig config) {
        if (config.getPorts().length == 1) {
            return Optional.of(config.getPorts()[0]);
        }
        Optional<Port> port = Arrays.stream(config.getPorts()).filter(p -> HTTP_PORT_NAMES.contains(p.getName())).findFirst();
        if (port.isPresent()) {
            return port;
        }
        port = Arrays.stream(config.getPorts()).filter(p -> HTTP_PORT_NUMBERS.contains(p.getHostPort())).findFirst();
        if (port.isPresent()) {
            return port;
        }
        return Optional.empty();
    }
}

