/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.utils;

import io.ap4k.Ap4kException;
import io.ap4k.deps.jackson.core.JsonFactory;
import io.ap4k.deps.jackson.core.JsonProcessingException;
import io.ap4k.deps.jackson.core.type.TypeReference;
import io.ap4k.deps.jackson.databind.ObjectMapper;
import io.ap4k.deps.jackson.databind.SerializationFeature;
import io.ap4k.deps.jackson.dataformat.yaml.YAMLFactory;
import io.ap4k.deps.kubernetes.api.model.KubernetesResource;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Serialization {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper(){
        {
            this.configure(SerializationFeature.INDENT_OUTPUT, true);
            this.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            this.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        }
    };
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory()){
        {
            this.configure(SerializationFeature.INDENT_OUTPUT, true);
            this.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, false);
            this.configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, false);
        }
    };
    private static final String DOCUMENT_DELIMITER = "---";

    public static ObjectMapper jsonMapper() {
        return JSON_MAPPER;
    }

    public static ObjectMapper yamlMapper() {
        return YAML_MAPPER;
    }

    public static <T> String asJson(T object) {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw Ap4kException.launderThrowable(e);
        }
    }

    public static <T> String asYaml(T object) {
        try {
            return YAML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw Ap4kException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is) {
        return Serialization.unmarshal(is, JSON_MAPPER);
    }

    public static <T> T unmarshal(InputStream is, ObjectMapper mapper) {
        return Serialization.unmarshal(is, mapper, Collections.emptyMap());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, ObjectMapper mapper, Map<String, String> parameters) {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readerFor(KubernetesResource.class).readValue((InputStream)bis);
            return (T)object;
        }
        catch (IOException e) {
            throw Ap4kException.launderThrowable(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(String str, final Class<T> type) {
        try (ByteArrayInputStream is = new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));){
            T t = Serialization.unmarshal((InputStream)is, new TypeReference<T>(){

                public Type getType() {
                    return type;
                }
            });
            return t;
        }
        catch (IOException e) {
            throw Ap4kException.launderThrowable(e);
        }
    }

    public static <T> T unmarshal(InputStream is, final Class<T> type) {
        return Serialization.unmarshal(is, new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T unmarshal(InputStream is, TypeReference<T> type) {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            int intch;
            bis.mark(-1);
            while ((intch = bis.read()) > -1 && Character.isWhitespace(intch)) {
            }
            bis.reset();
            ObjectMapper mapper = JSON_MAPPER;
            if (intch != 123) {
                mapper = YAML_MAPPER;
            }
            Object object = mapper.readValue((InputStream)bis, type);
            return (T)object;
        }
        catch (IOException e) {
            throw Ap4kException.launderThrowable(e);
        }
    }

    private static List<KubernetesResource> getKubernetesResourceList(String specFile) {
        String[] documents;
        ArrayList<KubernetesResource> documentList = new ArrayList<KubernetesResource>();
        for (String document : documents = Serialization.splitSpecFile(specFile)) {
            if (!Serialization.validate(document)) continue;
            ByteArrayInputStream documentInputStream = new ByteArrayInputStream(document.getBytes());
            Object resource = Serialization.unmarshal(documentInputStream);
            documentList.add((KubernetesResource)resource);
        }
        return documentList;
    }

    private static boolean containsMultipleDocuments(String specFile) {
        String[] documents = Serialization.splitSpecFile(specFile);
        int nValidDocuments = 0;
        for (String document : documents) {
            if (!Serialization.validate(document)) continue;
            ++nValidDocuments;
        }
        return nValidDocuments > 1;
    }

    private static String[] splitSpecFile(String aSpecFile) {
        ArrayList<String> documents = new ArrayList<String>();
        String[] lines = aSpecFile.split(System.lineSeparator());
        StringBuilder builder = new StringBuilder();
        for (int nLine = 0; nLine < lines.length; ++nLine) {
            if (lines[nLine].length() >= DOCUMENT_DELIMITER.length() && !lines[nLine].substring(0, DOCUMENT_DELIMITER.length()).equals(DOCUMENT_DELIMITER) || lines[nLine].length() < DOCUMENT_DELIMITER.length()) {
                builder.append(lines[nLine] + System.lineSeparator());
                continue;
            }
            documents.add(builder.toString());
            builder.setLength(0);
        }
        if (!builder.toString().isEmpty()) {
            documents.add(builder.toString());
        }
        return documents.toArray(new String[documents.size()]);
    }

    private static boolean validate(String document) {
        Matcher keyValueMatcher = Pattern.compile("(\\S+):\\s(\\S*)(?:\\b(?!:)|$)").matcher(document);
        return !document.isEmpty() && keyValueMatcher.find();
    }

    private static String readSpecFileFromInputStream(InputStream inputStream) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            return outputStream.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read InputStream." + e);
        }
    }
}

