/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.applicationcrd.api.model;

import io.ap4k.deps.applicationcrd.api.model.Application;
import io.ap4k.deps.applicationcrd.api.model.ApplicationFluent;
import io.ap4k.deps.applicationcrd.api.model.ApplicationFluentImpl;
import io.ap4k.deps.javax.validation.Validator;
import io.ap4k.deps.kubernetes.api.builder.ValidationUtils;
import io.ap4k.deps.kubernetes.api.builder.VisitableBuilder;

public class ApplicationBuilder
extends ApplicationFluentImpl<ApplicationBuilder>
implements VisitableBuilder<Application, ApplicationBuilder> {
    ApplicationFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ApplicationBuilder() {
        this(true);
    }

    public ApplicationBuilder(Boolean validationEnabled) {
        this(new Application(), validationEnabled);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Application(), validationEnabled);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent, Application instance) {
        this(fluent, instance, true);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent, Application instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ApplicationBuilder(Application instance) {
        this(instance, (Boolean)true);
    }

    public ApplicationBuilder(Application instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public ApplicationBuilder(Validator validator) {
        this(new Application(), (Boolean)true);
    }

    public ApplicationBuilder(ApplicationFluent<?> fluent, Application instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public ApplicationBuilder(Application instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Application build() {
        Application buildable = new Application(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationBuilder that = (ApplicationBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

