/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.applicationcrd.api.model;

import io.ap4k.deps.applicationcrd.api.model.Application;
import io.ap4k.deps.applicationcrd.api.model.ApplicationFluent;
import io.ap4k.deps.applicationcrd.api.model.ApplicationSpec;
import io.ap4k.deps.applicationcrd.api.model.ApplicationSpecBuilder;
import io.ap4k.deps.applicationcrd.api.model.ApplicationSpecFluentImpl;
import io.ap4k.deps.applicationcrd.api.model.ApplicationStatus;
import io.ap4k.deps.applicationcrd.api.model.ApplicationStatusBuilder;
import io.ap4k.deps.applicationcrd.api.model.ApplicationStatusFluentImpl;
import io.ap4k.deps.kubernetes.api.builder.BaseFluent;
import io.ap4k.deps.kubernetes.api.builder.Nested;
import io.ap4k.deps.kubernetes.api.model.ObjectMeta;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaBuilder;
import io.ap4k.deps.kubernetes.api.model.ObjectMetaFluentImpl;

public class ApplicationFluentImpl<A extends ApplicationFluent<A>>
extends BaseFluent<A>
implements ApplicationFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ApplicationSpecBuilder spec;
    private ApplicationStatusBuilder status;

    public ApplicationFluentImpl() {
    }

    public ApplicationFluentImpl(Application instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ApplicationFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ApplicationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ApplicationFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ApplicationFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ApplicationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ApplicationSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ApplicationSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ApplicationSpec spec) {
        this._visitables.remove(this.spec);
        if (spec != null) {
            this.spec = new ApplicationSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ApplicationFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ApplicationFluent.SpecNested<A> withNewSpecLike(ApplicationSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ApplicationFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ApplicationFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ApplicationSpecBuilder().build());
    }

    @Override
    public ApplicationFluent.SpecNested<A> editOrNewSpecLike(ApplicationSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ApplicationStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ApplicationStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ApplicationStatus status) {
        this._visitables.remove(this.status);
        if (status != null) {
            this.status = new ApplicationStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ApplicationFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ApplicationFluent.StatusNested<A> withNewStatusLike(ApplicationStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ApplicationFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ApplicationFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ApplicationStatusBuilder().build());
    }

    @Override
    public ApplicationFluent.StatusNested<A> editOrNewStatusLike(ApplicationStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApplicationFluentImpl that = (ApplicationFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public class StatusNestedImpl<N>
    extends ApplicationStatusFluentImpl<ApplicationFluent.StatusNested<N>>
    implements ApplicationFluent.StatusNested<N>,
    Nested<N> {
        private final ApplicationStatusBuilder builder;

        StatusNestedImpl(ApplicationStatus item) {
            this.builder = new ApplicationStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ApplicationStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ApplicationSpecFluentImpl<ApplicationFluent.SpecNested<N>>
    implements ApplicationFluent.SpecNested<N>,
    Nested<N> {
        private final ApplicationSpecBuilder builder;

        SpecNestedImpl(ApplicationSpec item) {
            this.builder = new ApplicationSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ApplicationSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ApplicationFluent.MetadataNested<N>>
    implements ApplicationFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ApplicationFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

