/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.deser.impl;

import io.ap4k.deps.jackson.core.JsonParser;
import io.ap4k.deps.jackson.core.JsonToken;
import io.ap4k.deps.jackson.databind.DeserializationContext;
import io.ap4k.deps.jackson.databind.JavaType;
import io.ap4k.deps.jackson.databind.JsonDeserializer;
import io.ap4k.deps.jackson.databind.JsonMappingException;
import io.ap4k.deps.jackson.databind.PropertyName;
import io.ap4k.deps.jackson.databind.deser.SettableBeanProperty;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedMember;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedMethod;
import io.ap4k.deps.jackson.databind.introspect.BeanPropertyDefinition;
import io.ap4k.deps.jackson.databind.jsontype.TypeDeserializer;
import io.ap4k.deps.jackson.databind.util.Annotations;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public final class SetterlessProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedMethod _annotated;
    protected final Method _getter;

    public SetterlessProperty(BeanPropertyDefinition propDef, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedMethod method) {
        super(propDef, type, typeDeser, contextAnnotations);
        this._annotated = method;
        this._getter = method.getAnnotated();
    }

    protected SetterlessProperty(SetterlessProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._annotated = src._annotated;
        this._getter = src._getter;
    }

    protected SetterlessProperty(SetterlessProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._annotated = src._annotated;
        this._getter = src._getter;
    }

    @Override
    public SetterlessProperty withName(PropertyName newName) {
        return new SetterlessProperty(this, newName);
    }

    @Override
    public SetterlessProperty withValueDeserializer(JsonDeserializer<?> deser) {
        return new SetterlessProperty(this, deser);
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotated.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public final void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object toModify;
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.VALUE_NULL) {
            return;
        }
        if (this._valueTypeDeserializer != null) {
            throw JsonMappingException.from(p, "Problem deserializing 'setterless' property (\"" + this.getName() + "\"): no way to handle typed deser with setterless yet");
        }
        try {
            toModify = this._getter.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            this._throwAsIOE(p, e);
            return;
        }
        if (toModify == null) {
            throw JsonMappingException.from(p, "Problem deserializing 'setterless' property '" + this.getName() + "': get method returned null");
        }
        this._valueDeserializer.deserialize(p, ctxt, toModify);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        this.deserializeAndSet(p, ctxt, instance);
        return instance;
    }

    @Override
    public final void set(Object instance, Object value) throws IOException {
        throw new UnsupportedOperationException("Should never call 'set' on setterless property");
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        this.set(instance, value);
        return null;
    }
}

