/*
 * Decompiled with CFR 0.152.
 */
package io.ap4k.deps.jackson.databind.ser;

import io.ap4k.deps.jackson.core.JsonGenerator;
import io.ap4k.deps.jackson.databind.BeanProperty;
import io.ap4k.deps.jackson.databind.JsonMappingException;
import io.ap4k.deps.jackson.databind.JsonSerializer;
import io.ap4k.deps.jackson.databind.SerializerProvider;
import io.ap4k.deps.jackson.databind.introspect.AnnotatedMember;
import io.ap4k.deps.jackson.databind.ser.ContextualSerializer;
import io.ap4k.deps.jackson.databind.ser.PropertyFilter;
import io.ap4k.deps.jackson.databind.ser.std.MapSerializer;
import java.util.Map;

public class AnyGetterWriter {
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected JsonSerializer<Object> _serializer;
    protected MapSerializer _mapSerializer;

    public AnyGetterWriter(BeanProperty property, AnnotatedMember accessor, JsonSerializer<?> serializer) {
        this._accessor = accessor;
        this._property = property;
        this._serializer = serializer;
        if (serializer instanceof MapSerializer) {
            this._mapSerializer = (MapSerializer)serializer;
        }
    }

    public void getAndSerialize(Object bean, JsonGenerator gen, SerializerProvider provider) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            throw JsonMappingException.from(gen, "Value returned by 'any-getter' (" + this._accessor.getName() + "()) not java.util.Map but " + value.getClass().getName());
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFields((Map)value, gen, provider);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    public void getAndFilter(Object bean, JsonGenerator gen, SerializerProvider provider, PropertyFilter filter) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            throw JsonMappingException.from(gen, "Value returned by 'any-getter' (" + this._accessor.getName() + "()) not java.util.Map but " + value.getClass().getName());
        }
        if (this._mapSerializer != null) {
            this._mapSerializer.serializeFilteredFields((Map)value, gen, provider, filter, null);
            return;
        }
        this._serializer.serialize(value, gen, provider);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this._serializer instanceof ContextualSerializer) {
            JsonSerializer<?> ser = provider.handlePrimaryContextualization(this._serializer, this._property);
            this._serializer = ser;
            if (ser instanceof MapSerializer) {
                this._mapSerializer = (MapSerializer)ser;
            }
        }
    }
}

